/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.cylinder;

import georegression.fitting.cylinder.CodecCylinder3D_F64;
import georegression.metric.MiscOps;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.shapes.Cylinder3D_F64;
import java.util.List;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.data.DMatrixRMaj;

public class CylinderToPointSignedDistanceJacobian_F64
implements FunctionNtoMxN<DMatrixRMaj> {
    private Cylinder3D_F64 cylinder = new Cylinder3D_F64();
    private List<Point3D_F64> points;
    private CodecCylinder3D_F64 codec = new CodecCylinder3D_F64();

    public void setPoints(List<Point3D_F64> points) {
        this.points = points;
    }

    @Override
    public int getNumOfInputsN() {
        return 7;
    }

    @Override
    public int getNumOfOutputsM() {
        return this.points.size();
    }

    @Override
    public void process(double[] input, DMatrixRMaj output) {
        this.codec.decode(input, this.cylinder);
        Point3D_F64 cp = this.cylinder.line.p;
        Vector3D_F64 cs = this.cylinder.line.slope;
        double slopeDot = cs.dot(cs);
        double slopeNorm = Math.sqrt(slopeDot);
        int index = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            Point3D_F64 p = this.points.get(i);
            double x = cp.x - p.x;
            double y = cp.y - p.y;
            double z = cp.z - p.z;
            double cc = x * x + y * y + z * z;
            double xdots = MiscOps.dot(x, y, z, cs);
            double b = xdots / slopeNorm;
            double distance = cc - b * b;
            if (distance < 0.0) {
                output.data[index++] = 0.0;
                output.data[index++] = 0.0;
                output.data[index++] = 0.0;
                output.data[index++] = 0.0;
                output.data[index++] = 0.0;
                output.data[index++] = 0.0;
                output.data[index++] = -1.0;
                continue;
            }
            distance = Math.sqrt(distance);
            output.data[index++] = (cp.x - p.x - xdots * cs.x / slopeDot) / distance;
            output.data[index++] = (cp.y - p.y - xdots * cs.y / slopeDot) / distance;
            output.data[index++] = (cp.z - p.z - xdots * cs.z / slopeDot) / distance;
            output.data[index++] = -xdots * ((cp.x - p.x) / slopeDot - xdots / slopeDot * (cs.x / slopeDot)) / distance;
            output.data[index++] = -xdots * ((cp.y - p.y) / slopeDot - xdots / slopeDot * (cs.y / slopeDot)) / distance;
            output.data[index++] = -xdots * ((cp.z - p.z) / slopeDot - xdots / slopeDot * (cs.z / slopeDot)) / distance;
            output.data[index++] = -1.0;
        }
    }

    @Override
    public DMatrixRMaj declareMatrixMxN() {
        return new DMatrixRMaj(this.getNumOfOutputsM(), this.getNumOfInputsN());
    }
}

