/*
 * Decompiled with CFR 0.152.
 */
package deepboof.misc;

import deepboof.misc.TensorOps;
import deepboof.tensors.Tensor_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TensorFactory_F64 {
    public static Tensor_F64 zeros(Random rand, int ... shape) {
        Tensor_F64 out = new Tensor_F64();
        if (rand != null) {
            out.subtensor = true;
            out.startIndex = rand.nextInt(20) + 1;
        }
        out.d = new double[out.startIndex + TensorOps.tensorLength(shape)];
        out.reshape(shape);
        return out;
    }

    public static Tensor_F64 random(Random rand, boolean subTensor, int ... shape) {
        return TensorFactory_F64.randomMM(rand, subTensor, -1.0, 1.0, shape);
    }

    public static Tensor_F64 randomMM(Random rand, boolean subTensor, double min, double max, int ... shape) {
        Tensor_F64 out = TensorFactory_F64.zeros(subTensor ? rand : null, shape);
        TensorFactory_F64.randomMM(rand, min, max, out);
        return out;
    }

    public static List<Tensor_F64> randomMM(Random rand, boolean subTensor, double min, double max, List<int[]> shapes) {
        ArrayList<Tensor_F64> out = new ArrayList<Tensor_F64>();
        for (int[] shape : shapes) {
            out.add(TensorFactory_F64.randomMM(rand, subTensor, min, max, shape));
        }
        return out;
    }

    public static void randomMM(Random rand, double min, double max, Tensor_F64 tensor) {
        int N = tensor.length();
        for (int i = 0; i < N; ++i) {
            tensor.d[tensor.startIndex + i] = rand.nextDouble() * (max - min) + min;
        }
    }
}

