/*
 * Decompiled with CFR 0.152.
 */
package deepboof.impl.backward.standard;

import deepboof.BaseTensor;
import deepboof.DFunction;
import deepboof.Tensor;
import deepboof.impl.forward.standard.BaseFunction;
import deepboof.misc.TensorOps;
import java.util.List;

public abstract class BaseDFunction<T extends Tensor<T>>
extends BaseFunction<T>
implements DFunction<T> {
    protected boolean learningMode = false;

    @Override
    public void learning() {
        this.learningMode = true;
    }

    @Override
    public void evaluating() {
        this.learningMode = false;
    }

    @Override
    public void backwards(T input, T dout, T gradientInput, List<T> gradientParameters) {
        if (this.shapeInput == null) {
            throw new IllegalArgumentException("Must initialize first!");
        }
        if (!this.learningMode) {
            throw new IllegalArgumentException("Must be in learning mode ot invoke backwards");
        }
        TensorOps.checkShape("input", -1, this.shapeInput, ((BaseTensor)input).getShape(), true);
        TensorOps.checkShape("dout", -1, this.shapeOutput, ((BaseTensor)dout).getShape(), true);
        TensorOps.checkShape("gradientInput", -1, this.shapeInput, ((BaseTensor)gradientInput).getShape(), true);
        TensorOps.checkShape("gradientParameters", this.shapeParameters, gradientParameters, false);
        this._backwards(input, dout, gradientInput, gradientParameters);
    }

    protected abstract void _backwards(T var1, T var2, T var3, List<T> var4);

    @Override
    public boolean isLearning() {
        return this.learningMode;
    }
}

