/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.pyramid;

import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ConfigDiscreteLevels;
import boofcv.struct.pyramid.ImagePyramidBase;
import javax.annotation.Nullable;

public abstract class PyramidDiscrete<T extends ImageBase<T>>
extends ImagePyramidBase<T> {
    private ConfigDiscreteLevels configLayers = new ConfigDiscreteLevels();
    protected int[] levelScales;

    public PyramidDiscrete(ImageType<T> imageType, boolean saveOriginalReference, @Nullable ConfigDiscreteLevels configLayers) {
        super(imageType, saveOriginalReference);
        if (configLayers != null) {
            this.configLayers.setTo(configLayers);
        }
    }

    protected PyramidDiscrete(PyramidDiscrete<T> orig) {
        super(orig);
        this.configLayers.setTo(orig.configLayers);
    }

    @Override
    public void initialize(int width, int height) {
        this.computeScales(width, height);
        super.initialize(width, height);
    }

    protected void computeScales(int width, int height) {
        this.levelScales = new int[this.configLayers.computeLayers(width, height)];
        this.levelScales[0] = 1;
        for (int i = 1; i < this.levelScales.length; ++i) {
            this.levelScales[i] = 2 * this.levelScales[i - 1];
        }
    }

    public int[] getScales() {
        return this.levelScales;
    }

    @Override
    public double getScale(int layer) {
        return this.levelScales[layer];
    }

    @Override
    public int getNumLayers() {
        return this.levelScales.length;
    }

    public ConfigDiscreteLevels getConfigLayers() {
        return this.configLayers;
    }
}

