/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.pyramid;

import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ImagePyramid;

public abstract class ImagePyramidBase<T extends ImageBase<T>>
implements ImagePyramid<T> {
    protected int bottomWidth;
    protected int bottomHeight;
    public T[] layers;
    protected boolean saveOriginalReference;
    ImageType<T> imageType;

    public ImagePyramidBase(ImageType<T> imageType, boolean saveOriginalReference) {
        this.imageType = imageType;
        this.saveOriginalReference = saveOriginalReference;
    }

    protected ImagePyramidBase(ImagePyramidBase<T> orig) {
        this.imageType = orig.imageType;
        this.saveOriginalReference = orig.saveOriginalReference;
        if (orig.layers != null) {
            this.layers = this.imageType.createArray(orig.layers.length);
            for (int i = 0; i < this.layers.length; ++i) {
                if (orig.layers[i] == null) continue;
                this.layers[i] = ((ImageBase)orig.layers[i]).createSameShape();
            }
        }
    }

    @Override
    public void initialize(int width, int height) {
        if (this.bottomWidth == width && this.bottomHeight == height) {
            return;
        }
        this.bottomWidth = width;
        this.bottomHeight = height;
        this.layers = this.imageType.createArray(this.getNumLayers());
        double scaleFactor = this.getScale(0);
        if (scaleFactor == 1.0) {
            if (!this.saveOriginalReference) {
                this.layers[0] = this.imageType.createImage(this.bottomWidth, this.bottomHeight);
            }
        } else {
            this.layers[0] = this.imageType.createImage((int)Math.ceil((double)this.bottomWidth / scaleFactor), (int)Math.ceil((double)this.bottomHeight / scaleFactor));
        }
        for (int i = 1; i < this.layers.length; ++i) {
            scaleFactor = this.getScale(i);
            this.layers[i] = this.imageType.createImage((int)Math.ceil((double)this.bottomWidth / scaleFactor), (int)Math.ceil((double)this.bottomHeight / scaleFactor));
        }
    }

    @Override
    public boolean isInitialized() {
        return this.layers != null;
    }

    protected void checkScales() {
        if (this.getScale(0) < 0.0) {
            throw new IllegalArgumentException("The first layer must be more than zero.");
        }
        double prevScale = 0.0;
        for (int i = 0; i < this.getNumLayers(); ++i) {
            double s = this.getScale(i);
            if (s < prevScale) {
                throw new IllegalArgumentException("Higher layers must be the same size or larger than previous layers.");
            }
            prevScale = s;
        }
    }

    @Override
    public void setTo(ImagePyramid<T> input) {
        for (int i = 0; i < this.layers.length; ++i) {
            ((ImageBase)this.getLayer(i)).setTo(input.getLayer(i));
        }
    }

    @Override
    public T getLayer(int layerNum) {
        return this.layers[layerNum];
    }

    public void setFirstLayer(T image) {
        if (!this.saveOriginalReference) {
            throw new IllegalArgumentException("Attempting to set the first layer when saveOriginalReference is false");
        }
        this.layers[0] = image;
    }

    @Override
    public int getWidth(int layer) {
        return ((ImageBase)this.layers[layer]).width;
    }

    @Override
    public int getHeight(int layer) {
        return ((ImageBase)this.layers[layer]).height;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public int getInputWidth() {
        return this.bottomWidth;
    }

    @Override
    public int getInputHeight() {
        return this.bottomHeight;
    }

    public boolean isSaveOriginalReference() {
        return this.saveOriginalReference;
    }

    public void setSaveOriginalReference(boolean save) {
        this.saveOriginalReference = save;
    }
}

