/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.pyramid;

import boofcv.struct.Configuration;

public class ConfigDiscreteLevels
implements Configuration {
    public int numLevelsRequested = -1;
    public int minWidth = -1;
    public int minHeight = -1;

    public static ConfigDiscreteLevels levels(int numLevels) {
        return new ConfigDiscreteLevels(numLevels, -1, -1);
    }

    public static ConfigDiscreteLevels minSize(int minWidth, int minHeight) {
        return new ConfigDiscreteLevels(-1, minWidth, minHeight);
    }

    public static ConfigDiscreteLevels minSize(int sideLength) {
        return new ConfigDiscreteLevels(-1, sideLength, sideLength);
    }

    public ConfigDiscreteLevels() {
    }

    public ConfigDiscreteLevels(int numLevelsRequested, int minWidth, int minHeight) {
        this.numLevelsRequested = numLevelsRequested;
        this.minWidth = minWidth;
        this.minHeight = minHeight;
    }

    public int computeLayers(int width, int height) {
        if (this.numLevelsRequested > 0) {
            return this.numLevelsRequested;
        }
        if (this.minWidth > 0) {
            return this.computeNumLevels(width, this.minWidth);
        }
        if (this.minHeight > 0) {
            return this.computeNumLevels(height, this.minHeight);
        }
        throw new IllegalArgumentException("Need to specify numLevels or minWidth or minHeight");
    }

    int computeNumLevels(int length, int minLength) {
        if (length <= minLength) {
            return 1;
        }
        double scale = (double)length / (double)minLength;
        double levels = Math.log(scale) / Math.log(2.0);
        return (int)Math.floor(levels) + 1;
    }

    public void setTo(ConfigDiscreteLevels config) {
        this.numLevelsRequested = config.numLevelsRequested;
        this.minWidth = config.minWidth;
        this.minHeight = config.minHeight;
    }

    @Override
    public void checkValidity() {
    }
}

