/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageType;
import java.lang.reflect.Array;

public abstract class ImageGray<T extends ImageGray<T>>
extends ImageBase<T> {
    protected ImageGray(int width, int height) {
        this.imageType = ImageType.single(this.getClass());
        this.initialize(width, height);
    }

    protected ImageGray() {
        this.imageType = ImageType.single(this.getClass());
    }

    protected void initialize(int width, int height) {
        this._setData(Array.newInstance(this.getDataType().getDataType(), width * height));
        this.startIndex = 0;
        this.stride = width;
        this.width = width;
        this.height = height;
    }

    @Override
    public T subimage(int x0, int y0, int x1, int y1, T subimage) {
        if (x0 < 0 || y0 < 0) {
            throw new IllegalArgumentException("x0 or y0 is less than zero");
        }
        if (x1 < x0 || y1 < y0) {
            throw new IllegalArgumentException("x1 or y1 is less than x0 or y0 respectively");
        }
        if (x1 > this.width || y1 > this.height) {
            throw new IllegalArgumentException("x1 or y1 is more than the width or height respectively");
        }
        if (subimage == null) {
            subimage = (ImageGray)this.createNew(-1, -1);
        }
        ((ImageGray)subimage)._setData(this._getData());
        ((ImageGray)subimage).stride = Math.max(this.width, this.stride);
        ((ImageGray)subimage).width = x1 - x0;
        ((ImageGray)subimage).height = y1 - y0;
        ((ImageGray)subimage).startIndex = this.startIndex + y0 * this.stride + x0;
        ((ImageGray)subimage).subImage = true;
        ((ImageGray)subimage).imageType = this.imageType;
        return subimage;
    }

    @Override
    public void reshape(int width, int height) {
        if (this.width == width && this.height == height) {
            return;
        }
        if (this.isSubimage()) {
            throw new IllegalArgumentException("Can't reshape sub-images");
        }
        Object data = this._getData();
        if (Array.getLength(data) < width * height) {
            ImageGray a = (ImageGray)this.createNew(width, height);
            this._setData(a._getData());
        }
        this.stride = width;
        this.width = width;
        this.height = height;
    }

    public void reshape(ImageBase img) {
        this.reshape(img.width, img.height);
    }

    @Override
    public void setTo(T orig) {
        if (this.width != ((ImageGray)orig).width || this.height != ((ImageGray)orig).height) {
            this.reshape(((ImageGray)orig).width, ((ImageGray)orig).height);
        }
        if (!((ImageBase)orig).isSubimage() && !this.isSubimage()) {
            System.arraycopy(((ImageGray)orig)._getData(), ((ImageGray)orig).startIndex, this._getData(), this.startIndex, this.stride * this.height);
        } else {
            int indexSrc = ((ImageGray)orig).startIndex;
            int indexDst = this.startIndex;
            for (int y = 0; y < this.height; ++y) {
                System.arraycopy(((ImageGray)orig)._getData(), indexSrc, this._getData(), indexDst, this.width);
                indexSrc += ((ImageGray)orig).stride;
                indexDst += this.stride;
            }
        }
    }

    public <B extends ImageGray<B>> B createSameShape(Class<B> type) {
        return GeneralizedImageOps.createSingleBand(type, this.width, this.height);
    }

    @Override
    public void copyRow(int row, int col0, int col1, int offset, Object array) {
        int idxSrc = this.startIndex + this.stride * row + col0;
        System.arraycopy(this._getData(), idxSrc, array, offset, col1 - col0);
    }

    public abstract void print();

    protected abstract Object _getData();

    public abstract ImageDataType getDataType();

    protected abstract void _setData(Object var1);
}

