/*
 * Decompiled with CFR 0.152.
 */
package boofcv.generate;

import boofcv.generate.CodeGeneratorUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public abstract class CodeGeneratorBase {
    protected PrintStream out;
    protected String className;
    protected boolean overwrite = true;

    public CodeGeneratorBase(boolean useDefaultName) {
        if (useDefaultName) {
            this.autoSelectName();
        }
    }

    public CodeGeneratorBase() {
        this.autoSelectName();
    }

    public void parseArguments(String[] args) {
    }

    public void autoSelectName() {
        this.className = this.getClass().getSimpleName();
        if (this.className.startsWith("Generate")) {
            int l = "Generate".length();
            this.className = this.className.substring(l);
            try {
                this.initFile();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            System.out.println("Class name doesn't start with Generate");
        }
    }

    protected void printParallel(String var, String lower, String upper, String body) {
        this.out.println();
        this.out.printf("\t\t//CONCURRENT_BELOW BoofConcurrency.loopFor(%s, %s, %s -> {\n", lower, upper, var);
        this.out.printf("\t\tfor( int %s = %s; %s < %s; %s++ ) {\n", var, lower, var, upper, var);
        this.out.print(body);
        this.out.print("\t\t}\n");
        this.out.print("\t\t//CONCURRENT_ABOVE });\n");
    }

    protected void printParallelBlock(String var0, String var1, String lower, String upper, String minBlock, String body) {
        this.out.println();
        this.out.printf("\t\t//CONCURRENT_BELOW BoofConcurrency.loopBlocks(%s, %s, %s,(%s,%s)->{\n", lower, upper, minBlock, var0, var1);
        this.out.printf("\t\tfinal int %s = %s, %s = %s;\n", var0, lower, var1, upper);
        this.out.print(body);
        this.out.print("\t\t//CONCURRENT_INLINE });\n");
    }

    public abstract void generate() throws FileNotFoundException;

    public void initFile() throws FileNotFoundException {
        File file = new File(this.className + ".java");
        if (this.overwrite) {
            boolean skip = false;
            if (new File("change.txt").exists()) {
                skip = true;
                System.out.println("Can't overwrite. Current directory is project root. Needs to the module.");
            } else if (!new File("src").exists()) {
                skip = true;
                System.out.println("Can't overwrite. src not in current directory");
            }
            if (!(skip || (file = new File(this.packageToPath(this.getClass()), file.getName())).getParentFile().exists() || file.getParentFile().mkdirs())) {
                throw new RuntimeException("Failed to create path " + file.getParentFile().getPath());
            }
        }
        System.out.println(file.getAbsolutePath());
        this.out = new PrintStream(new FileOutputStream(file));
        this.out.print(CodeGeneratorUtil.copyright);
        this.out.println();
        this.out.println("package " + this.getPackage() + ";");
        this.out.println();
    }

    public File packageToPath(Class c) {
        String name = c.getCanonicalName();
        String[] words = name.split("\\.");
        String path = "src/main/java/";
        for (int i = 0; i < words.length - 1; ++i) {
            path = path + words[i] + "/";
        }
        return new File(path);
    }

    public void setOutputFile(String className) throws FileNotFoundException {
        if (this.className != null) {
            throw new IllegalArgumentException("ClassName already set.  Out of date code?");
        }
        this.className = className;
        this.initFile();
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String generateDocString() {
        return " * <p>\n * DO NOT MODIFY. This code was automatically generated by " + this.getClass().getSimpleName() + ".\n * <p>\n";
    }

    public String generatedAnnotation() {
        return "@Generated(\"" + this.getClass().getName() + "\")\n";
    }

    public String getPackage() {
        return this.getClass().getPackage().getName();
    }
}

