/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.transform.wavelet;

import boofcv.alg.transform.wavelet.UtilWavelet;
import boofcv.core.image.border.BorderIndex1D_Reflect;
import boofcv.core.image.border.BorderIndex1D_Wrap;
import boofcv.struct.border.BorderIndex1D;
import boofcv.struct.border.BorderType;
import boofcv.struct.wavelet.WaveletDescription;
import boofcv.struct.wavelet.WlBorderCoef;
import boofcv.struct.wavelet.WlBorderCoefFixed;
import boofcv.struct.wavelet.WlBorderCoefStandard;
import boofcv.struct.wavelet.WlCoef_F32;
import boofcv.struct.wavelet.WlCoef_I32;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class FactoryWaveletDaub {
    public static WaveletDescription<WlCoef_F32> daubJ_F32(int J) {
        if (J != 4) {
            throw new IllegalArgumentException("Only 4 is currently supported");
        }
        WlCoef_F32 coef = new WlCoef_F32();
        coef.offsetScaling = 0;
        coef.offsetWavelet = 0;
        coef.scaling = new float[4];
        coef.wavelet = new float[4];
        double sqrt3 = Math.sqrt(3.0);
        double div = 4.0 * Math.sqrt(2.0);
        coef.scaling[0] = (float)((1.0 + sqrt3) / div);
        coef.scaling[1] = (float)((3.0 + sqrt3) / div);
        coef.scaling[2] = (float)((3.0 - sqrt3) / div);
        coef.scaling[3] = (float)((1.0 - sqrt3) / div);
        coef.wavelet[0] = coef.scaling[3];
        coef.wavelet[1] = -coef.scaling[2];
        coef.wavelet[2] = coef.scaling[1];
        coef.wavelet[3] = -coef.scaling[0];
        WlBorderCoefStandard<WlCoef_F32> inverse = new WlBorderCoefStandard<WlCoef_F32>(coef);
        return new WaveletDescription<WlCoef_F32>(new BorderIndex1D_Wrap(), coef, inverse);
    }

    public static WaveletDescription<WlCoef_F32> biorthogonal_F32(int J, BorderType borderType) {
        WlBorderCoef<WlCoef_F32> inverse;
        BorderIndex1D border;
        if (J != 5) {
            throw new IllegalArgumentException("Only 5 is currently supported");
        }
        WlCoef_F32 forward = new WlCoef_F32();
        forward.offsetScaling = -2;
        forward.offsetWavelet = 0;
        forward.scaling = new float[5];
        forward.wavelet = new float[3];
        forward.scaling[0] = -0.125f;
        forward.scaling[1] = 0.25f;
        forward.scaling[2] = 0.75f;
        forward.scaling[3] = 0.25f;
        forward.scaling[4] = -0.125f;
        forward.wavelet[0] = -0.5f;
        forward.wavelet[1] = 1.0f;
        forward.wavelet[2] = -0.5f;
        if (borderType == BorderType.REFLECT) {
            WlCoef_F32 inner = FactoryWaveletDaub.computeInnerInverseBiorthogonal(forward);
            border = new BorderIndex1D_Reflect();
            inverse = FactoryWaveletDaub.computeBorderCoefficients(border, forward, inner);
        } else if (borderType == BorderType.WRAP) {
            WlCoef_F32 inner = FactoryWaveletDaub.computeInnerInverseBiorthogonal(forward);
            inverse = new WlBorderCoefStandard<WlCoef_F32>(inner);
            border = new BorderIndex1D_Wrap();
        } else {
            throw new IllegalArgumentException("Unsupported border type: " + (Object)((Object)borderType));
        }
        return new WaveletDescription<WlCoef_F32>(border, forward, inverse);
    }

    private static WlCoef_F32 computeInnerInverseBiorthogonal(WlCoef_F32 coef) {
        int i;
        WlCoef_F32 ret = new WlCoef_F32();
        ret.offsetScaling = -coef.wavelet.length / 2;
        ret.offsetWavelet = 1 - coef.scaling.length / 2;
        ret.scaling = new float[coef.wavelet.length];
        ret.wavelet = new float[coef.scaling.length];
        for (i = 0; i < ret.scaling.length; ++i) {
            ret.scaling[i] = i % 2 == 0 ? -coef.wavelet[i] : coef.wavelet[i];
        }
        for (i = 0; i < ret.wavelet.length; ++i) {
            ret.wavelet[i] = i % 2 == 1 ? -coef.scaling[i] : coef.scaling[i];
        }
        return ret;
    }

    private static WlBorderCoef<WlCoef_F32> computeBorderCoefficients(BorderIndex1D border, WlCoef_F32 forward, WlCoef_F32 inverse) {
        int i;
        int N = Math.max(forward.getScalingLength(), forward.getWaveletLength());
        N += N % 2;
        border.setLength(N *= 2);
        DMatrixRMaj A = new DMatrixRMaj(N, N);
        for (int i2 = 0; i2 < N; i2 += 2) {
            int index;
            int j;
            for (j = 0; j < forward.scaling.length; ++j) {
                index = border.getIndex(j + i2 + forward.offsetScaling);
                A.add(i2, index, forward.scaling[j]);
            }
            for (j = 0; j < forward.wavelet.length; ++j) {
                index = border.getIndex(j + i2 + forward.offsetWavelet);
                A.add(i2 + 1, index, forward.wavelet[j]);
            }
        }
        LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.linear(N);
        if (!solver.setA(A) || solver.quality() < 1.0E-5) {
            throw new IllegalArgumentException("Can't invert matrix");
        }
        DMatrixRMaj A_inv = new DMatrixRMaj(N, N);
        solver.invert(A_inv);
        int numBorder = UtilWavelet.borderForwardLower(inverse) / 2;
        WlBorderCoefFixed<WlCoef_F32> ret = new WlBorderCoefFixed<WlCoef_F32>(numBorder, numBorder + 1);
        ret.setInnerCoef(inverse);
        for (i = 0; i < ret.getLowerLength(); ++i) {
            FactoryWaveletDaub.computeLowerCoef(inverse, A_inv, ret, i * 2);
        }
        for (i = 0; i < ret.getUpperLength(); ++i) {
            FactoryWaveletDaub.computeUpperCoef(inverse, N, A_inv, ret, i * 2);
        }
        return ret;
    }

    private static void computeLowerCoef(WlCoef_F32 inverse, DMatrixRMaj a_inv, WlBorderCoefFixed ret, int col) {
        int j;
        int lengthWavelet = inverse.wavelet.length + inverse.offsetWavelet + col;
        int lengthScaling = inverse.scaling.length + inverse.offsetScaling + col;
        lengthWavelet = Math.min(lengthWavelet, inverse.wavelet.length);
        lengthScaling = Math.min(lengthScaling, inverse.scaling.length);
        float[] coefScaling = new float[lengthScaling];
        float[] coefWavelet = new float[lengthWavelet];
        for (j = 0; j < lengthScaling; ++j) {
            coefScaling[j] = (float)a_inv.get(j, col);
        }
        for (j = 0; j < lengthWavelet; ++j) {
            coefWavelet[j] = (float)a_inv.get(j, col + 1);
        }
        ret.lowerCoef[col] = new WlCoef_F32(coefScaling, 0, coefWavelet, 0);
    }

    private static void computeUpperCoef(WlCoef_F32 inverse, int n, DMatrixRMaj a_inv, WlBorderCoefFixed ret, int col) {
        int j;
        int indexEnd = n - col - 2;
        int lengthWavelet = indexEnd + inverse.offsetWavelet + inverse.wavelet.length;
        int lengthScaling = indexEnd + inverse.offsetScaling + inverse.scaling.length;
        lengthWavelet = lengthWavelet > n ? inverse.wavelet.length - (lengthWavelet - n) : inverse.wavelet.length;
        lengthScaling = lengthScaling > n ? inverse.scaling.length - (lengthScaling - n) : inverse.scaling.length;
        float[] coefScaling = new float[lengthScaling];
        float[] coefWavelet = new float[lengthWavelet];
        for (j = 0; j < lengthScaling; ++j) {
            coefScaling[j] = (float)a_inv.get(indexEnd + j + inverse.offsetScaling, n - 2 - col);
        }
        for (j = 0; j < lengthWavelet; ++j) {
            coefWavelet[j] = (float)a_inv.get(indexEnd + j + inverse.offsetWavelet, n - 2 - col + 1);
        }
        ret.upperCoef[col / 2] = new WlCoef_F32(coefScaling, inverse.offsetScaling, coefWavelet, inverse.offsetWavelet);
    }

    public static WaveletDescription<WlCoef_I32> biorthogonal_I32(int J, BorderType borderType) {
        BorderIndex1D border;
        WlBorderCoef<WlCoef_I32> inverse;
        if (J != 5) {
            throw new IllegalArgumentException("Only 5 is currently supported");
        }
        WlCoef_I32 forward = new WlCoef_I32();
        forward.offsetScaling = -2;
        forward.offsetWavelet = 0;
        forward.scaling = new int[5];
        forward.wavelet = new int[3];
        forward.denominatorScaling = 8;
        forward.scaling[0] = -1;
        forward.scaling[1] = 2;
        forward.scaling[2] = 6;
        forward.scaling[3] = 2;
        forward.scaling[4] = -1;
        forward.denominatorWavelet = 2;
        forward.wavelet[0] = -1;
        forward.wavelet[1] = 2;
        forward.wavelet[2] = -1;
        if (borderType == BorderType.WRAP) {
            WlCoef_I32 inner = FactoryWaveletDaub.computeInnerBiorthogonalInverse(forward);
            inverse = new WlBorderCoefStandard<WlCoef_I32>(inner);
            border = new BorderIndex1D_Wrap();
        } else if (borderType == BorderType.REFLECT) {
            WlCoef_I32 inner = FactoryWaveletDaub.computeInnerBiorthogonalInverse(forward);
            inverse = FactoryWaveletDaub.convertToInt((WlBorderCoefFixed)FactoryWaveletDaub.biorthogonal_F32(J, borderType).getInverse(), inner);
            border = new BorderIndex1D_Reflect();
        } else {
            throw new IllegalArgumentException("Unsupported border type: " + (Object)((Object)borderType));
        }
        return new WaveletDescription<WlCoef_I32>(border, forward, inverse);
    }

    private static WlCoef_I32 computeInnerBiorthogonalInverse(WlCoef_I32 coef) {
        int i;
        WlCoef_I32 ret = new WlCoef_I32();
        ret.offsetScaling = -coef.wavelet.length / 2;
        ret.offsetWavelet = 1 - coef.scaling.length / 2;
        ret.denominatorScaling = coef.denominatorWavelet;
        ret.denominatorWavelet = coef.denominatorScaling;
        ret.scaling = new int[coef.wavelet.length];
        ret.wavelet = new int[coef.scaling.length];
        for (i = 0; i < ret.scaling.length; ++i) {
            ret.scaling[i] = i % 2 == 0 ? -coef.wavelet[i] : coef.wavelet[i];
        }
        for (i = 0; i < ret.wavelet.length; ++i) {
            ret.wavelet[i] = i % 2 == 1 ? -coef.scaling[i] : coef.scaling[i];
        }
        return ret;
    }

    public static WlBorderCoefFixed<WlCoef_I32> convertToInt(WlBorderCoefFixed<WlCoef_F32> orig, WlCoef_I32 inner) {
        WlCoef_I32 r;
        WlCoef_F32 o;
        int i;
        WlBorderCoefFixed<WlCoef_I32> ret = new WlBorderCoefFixed<WlCoef_I32>(orig.getLowerLength(), orig.getUpperLength());
        for (i = 0; i < orig.getLowerLength(); ++i) {
            o = orig.getLower(i);
            r = new WlCoef_I32();
            ret.setLower(i, r);
            FactoryWaveletDaub.convertCoef_F32_to_I32(inner.denominatorScaling, inner.denominatorWavelet, o, r);
        }
        for (i = 0; i < orig.getUpperLength(); ++i) {
            o = orig.getUpper(i);
            r = new WlCoef_I32();
            ret.setUpper(i, r);
            FactoryWaveletDaub.convertCoef_F32_to_I32(inner.denominatorScaling, inner.denominatorWavelet, o, r);
        }
        ret.setInnerCoef(inner);
        return ret;
    }

    private static void convertCoef_F32_to_I32(int denominatorScaling, int denominatorWavelet, WlCoef_F32 o, WlCoef_I32 r) {
        int j;
        r.denominatorScaling = denominatorScaling;
        r.denominatorWavelet = denominatorWavelet;
        r.scaling = new int[o.scaling.length];
        r.wavelet = new int[o.wavelet.length];
        r.offsetScaling = o.offsetScaling;
        r.offsetWavelet = o.offsetWavelet;
        for (j = 0; j < o.scaling.length; ++j) {
            r.scaling[j] = Math.round(o.scaling[j] * (float)denominatorScaling);
        }
        for (j = 0; j < o.wavelet.length; ++j) {
            r.wavelet[j] = Math.round(o.wavelet[j] * (float)denominatorWavelet);
        }
    }
}

