/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.tracker;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.tracker.ConfigTrackerDda;
import boofcv.abst.tracker.DdaManagerDetectDescribePoint;
import boofcv.abst.tracker.DdaManagerGeneralPoint;
import boofcv.abst.tracker.DetectDescribeAssociateTwoPass;
import boofcv.abst.tracker.PointTrackerTwoPass;
import boofcv.abst.tracker.PointTrackerTwoPassKltPyramid;
import boofcv.alg.feature.detect.interest.EasyGeneralFeatureDetector;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.tracker.klt.ConfigPKlt;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.factory.tracker.FactoryPointTracker;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.PyramidDiscrete;

public class FactoryPointTrackerTwoPass {
    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTrackerTwoPass<I> klt(ConfigPKlt config, ConfigGeneralDetector configExtract, Class<I> imageType, Class<D> derivType) {
        GeneralFeatureDetector detector = FactoryPointTracker.createShiTomasi(configExtract, derivType);
        InterpolateRectangle<I> interpInput = FactoryInterpolation.bilinearRectangle(imageType);
        InterpolateRectangle<D> interpDeriv = FactoryInterpolation.bilinearRectangle(derivType);
        ImageGradient<I, D> gradient = FactoryDerivative.sobel(imageType, derivType);
        PyramidDiscrete<I> pyramid = FactoryPyramid.discreteGaussian(config.pyramidLevels, -1.0, 2, true, ImageType.single(imageType));
        return new PointTrackerTwoPassKltPyramid<I, D>(config.config, config.toleranceFB, config.templateRadius, pyramid, detector, gradient, interpInput, interpDeriv);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>, Desc extends TupleDesc> PointTrackerTwoPass<I> dda(GeneralFeatureDetector<I, D> detector, DescribeRegionPoint<I, Desc> describe, AssociateDescription2D<Desc> associate1, AssociateDescription2D<Desc> associate2, double scale, ConfigTrackerDda config, Class<I> imageType) {
        EasyGeneralFeatureDetector<I, D> easy = new EasyGeneralFeatureDetector<I, D>(detector, imageType, null);
        DdaManagerGeneralPoint<I, D, Desc> manager = new DdaManagerGeneralPoint<I, D, Desc>(easy, describe, scale);
        if (associate2 == null) {
            associate2 = associate1;
        }
        return new DetectDescribeAssociateTwoPass(manager, associate1, associate2, config);
    }

    public static <I extends ImageGray<I>, Desc extends TupleDesc> PointTrackerTwoPass<I> dda(DetectDescribePoint<I, Desc> detectDescribe, AssociateDescription2D<Desc> associate1, AssociateDescription2D<Desc> associate2, ConfigTrackerDda config) {
        DdaManagerDetectDescribePoint<I, Desc> manager = new DdaManagerDetectDescribePoint<I, Desc>(detectDescribe);
        if (associate2 == null) {
            associate2 = associate1;
        }
        return new DetectDescribeAssociateTwoPass<I, Desc>(manager, associate1, associate2, config);
    }
}

