/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.tracker;

import boofcv.abst.feature.associate.AssociateDescTo2D;
import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.associate.ScoreAssociateHamming_B;
import boofcv.abst.feature.associate.ScoreAssociateNccFeature;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.associate.WrapAssociateSurfBasic;
import boofcv.abst.feature.describe.ConfigSurfDescribe;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.describe.WrapDescribeBrief;
import boofcv.abst.feature.describe.WrapDescribePixelRegionNCC;
import boofcv.abst.feature.detdesc.DetectDescribeFusion;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.interest.ConfigFastCorner;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.detect.interest.ConfigPointDetector;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.abst.feature.detect.interest.PointDetectorTypes;
import boofcv.abst.feature.orientation.ConfigAverageIntegral;
import boofcv.abst.feature.orientation.ConfigSlidingIntegral;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.tracker.ConfigTrackerDda;
import boofcv.abst.tracker.DdaManagerDetectDescribePoint;
import boofcv.abst.tracker.DdaManagerGeneralPoint;
import boofcv.abst.tracker.DetectDescribeAssociate;
import boofcv.abst.tracker.PointTracker;
import boofcv.abst.tracker.PointTrackerCombined;
import boofcv.abst.tracker.PointTrackerKltPyramid;
import boofcv.alg.feature.associate.AssociateSurfBasic;
import boofcv.alg.feature.describe.DescribePointBrief;
import boofcv.alg.feature.describe.DescribePointPixelRegionNCC;
import boofcv.alg.feature.describe.brief.FactoryBriefDefinition;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.alg.feature.detect.interest.EasyGeneralFeatureDetector;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.tracker.combined.CombinedTrackerScalePoint;
import boofcv.alg.tracker.klt.ConfigPKlt;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.factory.feature.associate.ConfigAssociateGreedy;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.describe.FactoryDescribePointAlgs;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPointAlg;
import boofcv.factory.feature.detect.interest.FactoryDetectPoint;
import boofcv.factory.feature.detect.interest.FactoryInterestPoint;
import boofcv.factory.feature.orientation.FactoryOrientation;
import boofcv.factory.feature.orientation.FactoryOrientationAlgs;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.factory.tracker.ConfigPointTracker;
import boofcv.factory.tracker.FactoryTrackerAlg;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.NccFeature;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ConfigDiscreteLevels;
import boofcv.struct.pyramid.PyramidDiscrete;
import java.util.Random;
import javax.annotation.Nullable;

public class FactoryPointTracker {
    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTracker<I> tracker(ConfigPointTracker config, Class<I> imageType, @Nullable Class<D> derivType) {
        if (config.typeTracker == ConfigPointTracker.TrackerType.KLT) {
            return FactoryPointTracker.klt(config.klt, config.detDesc.detectPoint, imageType, derivType);
        }
        DetectDescribePoint<I, BrightFeature> detDesc = FactoryDetectDescribe.generic(config.detDesc, imageType);
        AssociateDescription associate = FactoryAssociation.generic(config.associate, detDesc);
        switch (config.typeTracker) {
            case DDA: {
                return FactoryPointTracker.dda(detDesc, new AssociateDescTo2D(associate), config.dda);
            }
            case HYBRID: {
                return FactoryPointTracker.combined(detDesc, associate, config.klt, config.hybrid.reactivateThreshold, imageType);
            }
        }
        throw new RuntimeException("BUG! KLT all trackers should have been handled already");
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTracker<I> klt(int numLevels, @Nullable ConfigPointDetector configDetect, int featureRadius, Class<I> imageType, Class<D> derivType) {
        ConfigPKlt config = new ConfigPKlt();
        config.pyramidLevels = ConfigDiscreteLevels.levels(numLevels);
        config.templateRadius = featureRadius;
        return FactoryPointTracker.klt(config, configDetect, imageType, derivType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTrackerKltPyramid<I, D> klt(@Nullable ConfigPKlt config, @Nullable ConfigPointDetector configDetect, Class<I> imageType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        if (config == null) {
            config = new ConfigPKlt();
        }
        config.checkValidity();
        if (configDetect == null) {
            configDetect = new ConfigPointDetector();
            configDetect.type = PointDetectorTypes.SHI_TOMASI;
        }
        configDetect.checkValidity();
        GeneralFeatureDetector<I, D> detector = FactoryDetectPoint.create(configDetect, imageType, derivType);
        InterpolateRectangle<I> interpInput = FactoryInterpolation.bilinearRectangle(imageType);
        InterpolateRectangle<D> interpDeriv = FactoryInterpolation.bilinearRectangle(derivType);
        ImageGradient<I, D> gradient = FactoryDerivative.sobel(imageType, derivType);
        PyramidDiscrete<I> pyramid = FactoryPyramid.discreteGaussian(config.pyramidLevels, -1.0, 2, true, ImageType.single(imageType));
        return new PointTrackerKltPyramid<I, D>(config.config, config.toleranceFB, config.templateRadius, config.pruneClose, pyramid, detector, gradient, interpInput, interpDeriv, derivType);
    }

    public static <I extends ImageGray<I>> PointTracker<I> dda_FH_SURF_Fast(ConfigFastHessian configDetector, ConfigSurfDescribe.Fast configDescribe, ConfigAverageIntegral configOrientation, Class<I> imageType) {
        ScoreAssociation<TupleDesc_F64> score = FactoryAssociation.scoreEuclidean(TupleDesc_F64.class, true);
        AssociateSurfBasic assoc = new AssociateSurfBasic(FactoryAssociation.greedy(new ConfigAssociateGreedy(true, 5.0), score));
        AssociateDescTo2D<BrightFeature> generalAssoc = new AssociateDescTo2D<BrightFeature>(new WrapAssociateSurfBasic(assoc));
        DetectDescribePoint<I, BrightFeature> fused = FactoryDetectDescribe.surfFast(configDetector, configDescribe, configOrientation, imageType);
        DdaManagerDetectDescribePoint<I, BrightFeature> manager = new DdaManagerDetectDescribePoint<I, BrightFeature>(fused);
        return new DetectDescribeAssociate<I, BrightFeature>(manager, generalAssoc, new ConfigTrackerDda());
    }

    public static <I extends ImageGray<I>> PointTracker<I> dda_FH_SURF_Stable(ConfigFastHessian configDetector, ConfigSurfDescribe.Stability configDescribe, ConfigSlidingIntegral configOrientation, Class<I> imageType) {
        ScoreAssociation<TupleDesc_F64> score = FactoryAssociation.scoreEuclidean(TupleDesc_F64.class, true);
        AssociateSurfBasic assoc = new AssociateSurfBasic(FactoryAssociation.greedy(new ConfigAssociateGreedy(true, 5.0), score));
        AssociateDescTo2D<BrightFeature> generalAssoc = new AssociateDescTo2D<BrightFeature>(new WrapAssociateSurfBasic(assoc));
        DetectDescribePoint<I, BrightFeature> fused = FactoryDetectDescribe.surfStable(configDetector, configDescribe, configOrientation, imageType);
        DdaManagerDetectDescribePoint<I, BrightFeature> manager = new DdaManagerDetectDescribePoint<I, BrightFeature>(fused);
        return new DetectDescribeAssociate<I, BrightFeature>(manager, generalAssoc, new ConfigTrackerDda());
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTracker<I> dda_ST_BRIEF(int maxAssociationError, ConfigGeneralDetector configExtract, Class<I> imageType, Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        DescribePointBrief<I> brief = FactoryDescribePointAlgs.brief(FactoryBriefDefinition.gaussian2(new Random(123L), 16, 512), FactoryBlurFilter.gaussian(ImageType.single(imageType), 0.0, 4));
        GeneralFeatureDetector<I, D> detectPoint = FactoryPointTracker.createShiTomasi(configExtract, derivType);
        EasyGeneralFeatureDetector<I, D> easy = new EasyGeneralFeatureDetector<I, D>(detectPoint, imageType, derivType);
        ScoreAssociateHamming_B score = new ScoreAssociateHamming_B();
        AssociateDescTo2D<TupleDesc_B> association = new AssociateDescTo2D<TupleDesc_B>(FactoryAssociation.greedy(new ConfigAssociateGreedy(true, maxAssociationError), score));
        DdaManagerGeneralPoint manager = new DdaManagerGeneralPoint(easy, new WrapDescribeBrief<I>(brief, imageType), 1.0);
        return new DetectDescribeAssociate(manager, association, new ConfigTrackerDda());
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTracker<I> dda_FAST_BRIEF(ConfigFastCorner configFast, ConfigGeneralDetector configExtract, int maxAssociationError, Class<I> imageType) {
        DescribePointBrief<I> brief = FactoryDescribePointAlgs.brief(FactoryBriefDefinition.gaussian2(new Random(123L), 16, 512), FactoryBlurFilter.gaussian(ImageType.single(imageType), 0.0, 4));
        GeneralFeatureDetector corner = FactoryDetectPoint.createFast(configExtract, configFast, imageType);
        EasyGeneralFeatureDetector easy = new EasyGeneralFeatureDetector(corner, imageType, null);
        ScoreAssociateHamming_B score = new ScoreAssociateHamming_B();
        AssociateDescTo2D<TupleDesc_B> association = new AssociateDescTo2D<TupleDesc_B>(FactoryAssociation.greedy(new ConfigAssociateGreedy(true, maxAssociationError), score));
        DdaManagerGeneralPoint manager = new DdaManagerGeneralPoint(easy, new WrapDescribeBrief<I>(brief, imageType), 1.0);
        return new DetectDescribeAssociate(manager, association, new ConfigTrackerDda());
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTracker<I> dda_ST_NCC(ConfigGeneralDetector configExtract, int describeRadius, Class<I> imageType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        int w = 2 * describeRadius + 1;
        DescribePointPixelRegionNCC<I> alg = FactoryDescribePointAlgs.pixelRegionNCC(w, w, imageType);
        GeneralFeatureDetector<I, D> corner = FactoryPointTracker.createShiTomasi(configExtract, derivType);
        EasyGeneralFeatureDetector<I, D> easy = new EasyGeneralFeatureDetector<I, D>(corner, imageType, derivType);
        ScoreAssociateNccFeature score = new ScoreAssociateNccFeature();
        AssociateDescTo2D<NccFeature> association = new AssociateDescTo2D<NccFeature>(FactoryAssociation.greedy(new ConfigAssociateGreedy(true, Double.MAX_VALUE), score));
        DdaManagerGeneralPoint manager = new DdaManagerGeneralPoint(easy, new WrapDescribePixelRegionNCC<I>(alg, imageType), 1.0);
        return new DetectDescribeAssociate(manager, association, new ConfigTrackerDda());
    }

    public static <I extends ImageGray<I>, Desc extends TupleDesc> DetectDescribeAssociate<I, Desc> dda(InterestPointDetector<I> detector, OrientationImage<I> orientation, DescribeRegionPoint<I, Desc> describe, AssociateDescription2D<Desc> associate, ConfigTrackerDda config) {
        DetectDescribeFusion<I, Desc> fused = new DetectDescribeFusion<I, Desc>(detector, orientation, describe);
        DdaManagerDetectDescribePoint<I, Desc> manager = new DdaManagerDetectDescribePoint<I, Desc>(fused);
        DetectDescribeAssociate<I, Desc> dat = new DetectDescribeAssociate<I, Desc>(manager, associate, config);
        return dat;
    }

    public static <I extends ImageGray<I>, Desc extends TupleDesc> DetectDescribeAssociate<I, Desc> dda(DetectDescribePoint<I, Desc> detDesc, AssociateDescription2D<Desc> associate, ConfigTrackerDda config) {
        DdaManagerDetectDescribePoint<I, Desc> manager = new DdaManagerDetectDescribePoint<I, Desc>(detDesc);
        DetectDescribeAssociate<I, Desc> dat = new DetectDescribeAssociate<I, Desc>(manager, associate, config);
        return dat;
    }

    public static <I extends ImageGray<I>> PointTracker<I> combined_FH_SURF_KLT(ConfigPKlt kltConfig, int reactivateThreshold, ConfigFastHessian configDetector, ConfigSurfDescribe.Stability configDescribe, ConfigSlidingIntegral configOrientation, Class<I> imageType) {
        ScoreAssociation<TupleDesc_F64> score = FactoryAssociation.defaultScore(TupleDesc_F64.class);
        AssociateSurfBasic assoc = new AssociateSurfBasic(FactoryAssociation.greedy(new ConfigAssociateGreedy(true, Double.MAX_VALUE), score));
        WrapAssociateSurfBasic generalAssoc = new WrapAssociateSurfBasic(assoc);
        DetectDescribePoint<I, BrightFeature> fused = FactoryDetectDescribe.surfStable(configDetector, configDescribe, configOrientation, imageType);
        return FactoryPointTracker.combined(fused, generalAssoc, kltConfig, reactivateThreshold, imageType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTracker<I> combined_ST_SURF_KLT(ConfigGeneralDetector configExtract, ConfigPKlt kltConfig, int reactivateThreshold, ConfigSurfDescribe.Stability configDescribe, ConfigSlidingIntegral configOrientation, Class<I> imageType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        GeneralFeatureDetector<I, D> corner = FactoryPointTracker.createShiTomasi(configExtract, derivType);
        InterestPointDetector<I> detector = FactoryInterestPoint.wrapPoint(corner, 1.0, imageType, derivType);
        DescribeRegionPoint<I, BrightFeature> regionDesc = FactoryDescribeRegionPoint.surfStable(configDescribe, imageType);
        ScoreAssociation<TupleDesc_F64> score = FactoryAssociation.scoreEuclidean(TupleDesc_F64.class, true);
        AssociateSurfBasic assoc = new AssociateSurfBasic(FactoryAssociation.greedy(new ConfigAssociateGreedy(true, Double.MAX_VALUE), score));
        WrapAssociateSurfBasic generalAssoc = new WrapAssociateSurfBasic(assoc);
        OrientationImage<I> orientation = null;
        if (configOrientation != null) {
            Class integralType = GIntegralImageOps.getIntegralType(imageType);
            OrientationIntegral orientationII = FactoryOrientationAlgs.sliding_ii(configOrientation, integralType);
            orientation = FactoryOrientation.convertImage(orientationII, imageType);
        }
        return FactoryPointTracker.combined(detector, orientation, regionDesc, generalAssoc, kltConfig, reactivateThreshold, imageType);
    }

    public static <I extends ImageGray<I>, Desc extends TupleDesc> PointTracker<I> combined(InterestPointDetector<I> detector, OrientationImage<I> orientation, DescribeRegionPoint<I, Desc> describe, AssociateDescription<Desc> associate, ConfigPKlt kltConfig, int reactivateThreshold, Class<I> imageType) {
        DetectDescribeFusion<I, Desc> fused = new DetectDescribeFusion<I, Desc>(detector, orientation, describe);
        return FactoryPointTracker.combined(fused, associate, kltConfig, reactivateThreshold, imageType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>, Desc extends TupleDesc> PointTracker<I> combined(DetectDescribePoint<I, Desc> detector, AssociateDescription<Desc> associate, ConfigPKlt kltConfig, int reactivateThreshold, Class<I> imageType) {
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        if (kltConfig == null) {
            kltConfig = new ConfigPKlt();
        }
        CombinedTrackerScalePoint tracker = FactoryTrackerAlg.combined(detector, associate, kltConfig, imageType, derivType);
        return new PointTrackerCombined(tracker, kltConfig.pyramidLevels, reactivateThreshold, imageType, derivType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>, Desc extends TupleDesc> PointTracker<I> dda(GeneralFeatureDetector<I, D> detector, DescribeRegionPoint<I, Desc> describe, AssociateDescription2D<Desc> associate, double scale, Class<I> imageType) {
        EasyGeneralFeatureDetector<I, D> easy = new EasyGeneralFeatureDetector<I, D>(detector, imageType, null);
        DdaManagerGeneralPoint<I, D, Desc> manager = new DdaManagerGeneralPoint<I, D, Desc>(easy, describe, scale);
        return new DetectDescribeAssociate(manager, associate, new ConfigTrackerDda());
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> GeneralFeatureDetector<I, D> createShiTomasi(ConfigGeneralDetector config, Class<D> derivType) {
        GradientCornerIntensity<D> cornerIntensity = FactoryIntensityPointAlg.shiTomasi(1, false, derivType);
        return FactoryDetectPoint.createGeneral(cornerIntensity, config);
    }
}

