/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.geo;

import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.abst.geo.Estimate1ofPnP;
import boofcv.abst.geo.Estimate1ofPrNP;
import boofcv.abst.geo.Estimate1ofTrifocalTensor;
import boofcv.abst.geo.EstimateNofEpipolar;
import boofcv.abst.geo.EstimateNofPnP;
import boofcv.abst.geo.RefineEpipolar;
import boofcv.abst.geo.RefinePnP;
import boofcv.abst.geo.RefineThreeViewProjective;
import boofcv.abst.geo.RefineTriangulateEpipolar;
import boofcv.abst.geo.RefineTriangulateMetric;
import boofcv.abst.geo.RefineTriangulateProjective;
import boofcv.abst.geo.Triangulate2ViewsMetric;
import boofcv.abst.geo.Triangulate2ViewsProjective;
import boofcv.abst.geo.TriangulateNViewsMetric;
import boofcv.abst.geo.TriangulateNViewsProjective;
import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.BundleAdjustmentSchur;
import boofcv.abst.geo.bundle.BundleAdjustmentSchur_DDRM;
import boofcv.abst.geo.bundle.BundleAdjustmentSchur_DSCC;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.abst.geo.f.Estimate1toNofEpipolar;
import boofcv.abst.geo.f.EstimateNto1ofEpipolar;
import boofcv.abst.geo.f.LeastSquaresFundamental;
import boofcv.abst.geo.f.WrapEssentialNister5;
import boofcv.abst.geo.f.WrapFundamentalLinear7;
import boofcv.abst.geo.f.WrapFundamentalLinear8;
import boofcv.abst.geo.h.HomographyDLT_to_Epipolar;
import boofcv.abst.geo.h.HomographyTLS_to_Epipolar;
import boofcv.abst.geo.h.LeastSquaresHomography;
import boofcv.abst.geo.pose.Estimate1toNofPnP;
import boofcv.abst.geo.pose.EstimateNto1ofPnP;
import boofcv.abst.geo.pose.IPPE_to_EstimatePnP;
import boofcv.abst.geo.pose.PnPRefineRodrigues;
import boofcv.abst.geo.pose.WrapP3PLineDistance;
import boofcv.abst.geo.pose.WrapPRnPDirectLinearTransform;
import boofcv.abst.geo.pose.WrapPnPLepetitEPnP;
import boofcv.abst.geo.triangulate.TriangulateRefineEpipolarLS;
import boofcv.abst.geo.triangulate.TriangulateRefineMetricLS;
import boofcv.abst.geo.triangulate.TriangulateRefineProjectiveLS;
import boofcv.abst.geo.triangulate.TriangulateThenRefineMetric;
import boofcv.abst.geo.triangulate.TriangulateThenRefineProjective;
import boofcv.abst.geo.triangulate.Wrap2ViewPixelDepthLinear;
import boofcv.abst.geo.triangulate.Wrap2ViewsTriangulateGeometric;
import boofcv.abst.geo.triangulate.Wrap2ViewsTriangulateProjectiveDLT;
import boofcv.abst.geo.triangulate.WrapNViewsTriangulateMetricDLT;
import boofcv.abst.geo.triangulate.WrapNViewsTriangulateProjectiveDLT;
import boofcv.abst.geo.trifocal.WrapRefineThreeViewProjectiveGeometric;
import boofcv.abst.geo.trifocal.WrapTrifocalAlgebraicPoint7;
import boofcv.abst.geo.trifocal.WrapTrifocalLinearPoint7;
import boofcv.alg.geo.ModelObservationResidualN;
import boofcv.alg.geo.bundle.BundleAdjustmentMetricResidualFunction;
import boofcv.alg.geo.bundle.BundleAdjustmentMetricSchurJacobian_DDRM;
import boofcv.alg.geo.bundle.BundleAdjustmentMetricSchurJacobian_DSCC;
import boofcv.alg.geo.bundle.BundleAdjustmentProjectiveResidualFunction;
import boofcv.alg.geo.bundle.BundleAdjustmentProjectiveSchurJacobian_DDRM;
import boofcv.alg.geo.bundle.BundleAdjustmentProjectiveSchurJacobian_DSCC;
import boofcv.alg.geo.bundle.CodecSceneStructureMetric;
import boofcv.alg.geo.bundle.CodecSceneStructureProjective;
import boofcv.alg.geo.f.DistanceEpipolarConstraint;
import boofcv.alg.geo.h.HomographyDirectLinearTransform;
import boofcv.alg.geo.h.HomographyResidualSampson;
import boofcv.alg.geo.h.HomographyResidualTransfer;
import boofcv.alg.geo.h.HomographyTotalLeastSquares;
import boofcv.alg.geo.pose.P3PFinsterwalder;
import boofcv.alg.geo.pose.P3PGrunert;
import boofcv.alg.geo.pose.PRnPDirectLinearTransform;
import boofcv.alg.geo.pose.PnPLepetitEPnP;
import boofcv.alg.geo.pose.PoseFromPairLinear6;
import boofcv.alg.geo.trifocal.RefineThreeViewProjectiveGeometric;
import boofcv.alg.geo.trifocal.TrifocalAlgebraicPoint7;
import boofcv.factory.geo.ConfigBundleAdjustment;
import boofcv.factory.geo.ConfigThreeViewRefine;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.ConfigTrifocal;
import boofcv.factory.geo.EnumEssential;
import boofcv.factory.geo.EnumFundamental;
import boofcv.factory.geo.EnumPNP;
import boofcv.factory.geo.EpipolarError;
import boofcv.misc.ConfigConverge;
import boofcv.struct.geo.AssociatedPair;
import georegression.fitting.MotionTransformPoint;
import georegression.fitting.se.FitSpecialEuclideanOps_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import javax.annotation.Nullable;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.FactoryOptimizationSparse;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.UnconstrainedLeastSquaresSchur;
import org.ddogleg.optimization.lm.ConfigLevenbergMarquardt;
import org.ddogleg.optimization.trustregion.ConfigTrustRegion;
import org.ddogleg.solver.PolynomialOps;
import org.ddogleg.solver.RootFinderType;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;

public class FactoryMultiView {
    public static BundleAdjustment<SceneStructureMetric> bundleSparseMetric(@Nullable ConfigBundleAdjustment config) {
        if (config == null) {
            config = new ConfigBundleAdjustment();
        }
        UnconstrainedLeastSquaresSchur<DMatrixSparseCSC> minimizer = config.configOptimizer instanceof ConfigTrustRegion ? FactoryOptimizationSparse.doglegSchur((ConfigTrustRegion)config.configOptimizer) : FactoryOptimizationSparse.levenbergMarquardtSchur((ConfigLevenbergMarquardt)config.configOptimizer);
        return new BundleAdjustmentSchur_DSCC<SceneStructureMetric>(minimizer, (BundleAdjustmentSchur.FunctionResiduals<SceneStructureMetric>)new BundleAdjustmentMetricResidualFunction(), new BundleAdjustmentMetricSchurJacobian_DSCC(), (BundleAdjustmentSchur.Codec<SceneStructureMetric>)new CodecSceneStructureMetric());
    }

    public static BundleAdjustment<SceneStructureProjective> bundleSparseProjective(@Nullable ConfigBundleAdjustment config) {
        if (config == null) {
            config = new ConfigBundleAdjustment();
        }
        UnconstrainedLeastSquaresSchur<DMatrixSparseCSC> minimizer = config.configOptimizer instanceof ConfigTrustRegion ? FactoryOptimizationSparse.doglegSchur((ConfigTrustRegion)config.configOptimizer) : FactoryOptimizationSparse.levenbergMarquardtSchur((ConfigLevenbergMarquardt)config.configOptimizer);
        return new BundleAdjustmentSchur_DSCC<SceneStructureProjective>(minimizer, (BundleAdjustmentSchur.FunctionResiduals<SceneStructureProjective>)new BundleAdjustmentProjectiveResidualFunction(), new BundleAdjustmentProjectiveSchurJacobian_DSCC(), (BundleAdjustmentSchur.Codec<SceneStructureProjective>)new CodecSceneStructureProjective());
    }

    public static BundleAdjustment<SceneStructureMetric> bundleDenseMetric(boolean robust, @Nullable ConfigBundleAdjustment config) {
        if (config == null) {
            config = new ConfigBundleAdjustment();
        }
        UnconstrainedLeastSquaresSchur<DMatrixRMaj> minimizer = config.configOptimizer instanceof ConfigTrustRegion ? FactoryOptimization.doglegSchur(robust, (ConfigTrustRegion)config.configOptimizer) : FactoryOptimization.levenbergMarquardtSchur(robust, (ConfigLevenbergMarquardt)config.configOptimizer);
        return new BundleAdjustmentSchur_DDRM<SceneStructureMetric>(minimizer, (BundleAdjustmentSchur.FunctionResiduals<SceneStructureMetric>)new BundleAdjustmentMetricResidualFunction(), new BundleAdjustmentMetricSchurJacobian_DDRM(), (BundleAdjustmentSchur.Codec<SceneStructureMetric>)new CodecSceneStructureMetric());
    }

    public static BundleAdjustment<SceneStructureProjective> bundleDenseProjective(boolean robust, @Nullable ConfigBundleAdjustment config) {
        if (config == null) {
            config = new ConfigBundleAdjustment();
        }
        UnconstrainedLeastSquaresSchur<DMatrixRMaj> minimizer = config.configOptimizer instanceof ConfigTrustRegion ? FactoryOptimization.doglegSchur(robust, (ConfigTrustRegion)config.configOptimizer) : FactoryOptimization.levenbergMarquardtSchur(robust, (ConfigLevenbergMarquardt)config.configOptimizer);
        return new BundleAdjustmentSchur_DDRM<SceneStructureProjective>(minimizer, (BundleAdjustmentSchur.FunctionResiduals<SceneStructureProjective>)new BundleAdjustmentProjectiveResidualFunction(), new BundleAdjustmentProjectiveSchurJacobian_DDRM(), (BundleAdjustmentSchur.Codec<SceneStructureProjective>)new CodecSceneStructureProjective());
    }

    public static Estimate1ofEpipolar homographyDLT(boolean normalizeInput) {
        HomographyDirectLinearTransform alg = new HomographyDirectLinearTransform(normalizeInput);
        return new HomographyDLT_to_Epipolar(alg);
    }

    public static Estimate1ofEpipolar homographyTLS() {
        HomographyTotalLeastSquares alg = new HomographyTotalLeastSquares();
        return new HomographyTLS_to_Epipolar(alg);
    }

    public static RefineEpipolar homographyRefine(double tol, int maxIterations, EpipolarError type) {
        ModelObservationResidualN<DMatrixRMaj, AssociatedPair> residuals;
        switch (type) {
            case SIMPLE: {
                residuals = new HomographyResidualTransfer();
                break;
            }
            case SAMPSON: {
                residuals = new HomographyResidualSampson();
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported: " + (Object)((Object)type));
            }
        }
        return new LeastSquaresHomography(tol, maxIterations, residuals);
    }

    public static EstimateNofEpipolar fundamental_N(EnumFundamental which) {
        switch (which) {
            case LINEAR_8: {
                return new Estimate1toNofEpipolar(new WrapFundamentalLinear8(true));
            }
            case LINEAR_7: {
                return new WrapFundamentalLinear7(true);
            }
        }
        throw new IllegalArgumentException("Unknown algorithm " + (Object)((Object)which));
    }

    public static EstimateNofEpipolar essential_N(EnumEssential which) {
        switch (which) {
            case LINEAR_8: {
                return new Estimate1toNofEpipolar(new WrapFundamentalLinear8(false));
            }
            case LINEAR_7: {
                return new WrapFundamentalLinear7(false);
            }
            case NISTER_5: {
                return new WrapEssentialNister5();
            }
        }
        throw new IllegalArgumentException("Unknown algorithm " + (Object)((Object)which));
    }

    public static Estimate1ofEpipolar fundamental_1(EnumFundamental which, int numRemoveAmbiguity) {
        switch (which) {
            case LINEAR_8: {
                return new WrapFundamentalLinear8(true);
            }
        }
        if (numRemoveAmbiguity <= 0) {
            throw new IllegalArgumentException("numRemoveAmbiguity must be greater than zero");
        }
        EstimateNofEpipolar alg = FactoryMultiView.fundamental_N(which);
        DistanceEpipolarConstraint distance = new DistanceEpipolarConstraint();
        return new EstimateNto1ofEpipolar(alg, distance, numRemoveAmbiguity);
    }

    public static Estimate1ofEpipolar essential_1(EnumEssential which, int numRemoveAmbiguity) {
        switch (which) {
            case LINEAR_8: {
                return new WrapFundamentalLinear8(false);
            }
        }
        if (numRemoveAmbiguity <= 0) {
            throw new IllegalArgumentException("numRemoveAmbiguity must be greater than zero");
        }
        EstimateNofEpipolar alg = FactoryMultiView.essential_N(which);
        DistanceEpipolarConstraint distance = new DistanceEpipolarConstraint();
        return new EstimateNto1ofEpipolar(alg, distance, numRemoveAmbiguity);
    }

    public static RefineEpipolar fundamentalRefine(double tol, int maxIterations, EpipolarError type) {
        switch (type) {
            case SAMPSON: {
                return new LeastSquaresFundamental(tol, maxIterations, true);
            }
            case SIMPLE: {
                return new LeastSquaresFundamental(tol, maxIterations, false);
            }
        }
        throw new IllegalArgumentException("Type not supported: " + (Object)((Object)type));
    }

    public static Estimate1ofTrifocalTensor trifocal_1(@Nullable ConfigTrifocal config) {
        if (config == null) {
            config = new ConfigTrifocal();
        }
        switch (config.which) {
            case LINEAR_7: {
                return new WrapTrifocalLinearPoint7();
            }
            case ALGEBRAIC_7: {
                ConfigConverge cc = config.converge;
                UnconstrainedLeastSquares<DMatrixRMaj> optimizer = FactoryOptimization.levenbergMarquardt(null, false);
                TrifocalAlgebraicPoint7 alg = new TrifocalAlgebraicPoint7(optimizer, cc.maxIterations, cc.ftol, cc.gtol);
                return new WrapTrifocalAlgebraicPoint7(alg);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)config.which));
    }

    public static RefineThreeViewProjective threeViewRefine(@Nullable ConfigThreeViewRefine config) {
        if (config == null) {
            config = new ConfigThreeViewRefine();
        }
        switch (config.which) {
            case GEOMETRIC: {
                RefineThreeViewProjectiveGeometric alg = new RefineThreeViewProjectiveGeometric();
                alg.getConverge().setTo(config.converge);
                alg.setScale(config.normalizePixels);
                return new WrapRefineThreeViewProjectiveGeometric(alg);
            }
        }
        throw new IllegalArgumentException("Unknown algorithm " + (Object)((Object)config.which));
    }

    public static EstimateNofPnP pnp_N(EnumPNP which, int numIterations) {
        MotionTransformPoint<Se3_F64, Point3D_F64> motionFit = FitSpecialEuclideanOps_F64.fitPoints3D();
        switch (which) {
            case P3P_GRUNERT: {
                P3PGrunert grunert = new P3PGrunert(PolynomialOps.createRootFinder(5, RootFinderType.STURM));
                return new WrapP3PLineDistance(grunert, motionFit);
            }
            case P3P_FINSTERWALDER: {
                P3PFinsterwalder finster = new P3PFinsterwalder(PolynomialOps.createRootFinder(4, RootFinderType.STURM));
                return new WrapP3PLineDistance(finster, motionFit);
            }
            case EPNP: {
                Estimate1ofPnP epnp = FactoryMultiView.pnp_1(which, numIterations, 0);
                return new Estimate1toNofPnP(epnp);
            }
            case IPPE: {
                Estimate1ofEpipolar H = FactoryMultiView.homographyTLS();
                return new Estimate1toNofPnP(new IPPE_to_EstimatePnP(H));
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)which) + " not known");
    }

    public static Estimate1ofPnP pnp_1(EnumPNP which, int numIterations, int numTest) {
        if (which == EnumPNP.EPNP) {
            PnPLepetitEPnP alg = new PnPLepetitEPnP(0.1);
            alg.setNumIterations(numIterations);
            return new WrapPnPLepetitEPnP(alg);
        }
        if (which == EnumPNP.IPPE) {
            Estimate1ofEpipolar H = FactoryMultiView.homographyTLS();
            return new IPPE_to_EstimatePnP(H);
        }
        FastQueue<Se3_F64> solutions = new FastQueue<Se3_F64>(4, Se3_F64::new);
        return new EstimateNto1ofPnP(FactoryMultiView.pnp_N(which, -1), solutions, numTest);
    }

    public static Estimate1ofPrNP prnp_1() {
        return new WrapPRnPDirectLinearTransform(new PRnPDirectLinearTransform());
    }

    public static Estimate1ofPnP computePnPwithEPnP(int numIterations, double magicNumber) {
        PnPLepetitEPnP alg = new PnPLepetitEPnP(magicNumber);
        alg.setNumIterations(numIterations);
        return new WrapPnPLepetitEPnP(alg);
    }

    public static RefinePnP pnpRefine(double tol, int maxIterations) {
        return new PnPRefineRodrigues(tol, maxIterations);
    }

    public static PoseFromPairLinear6 poseFromPair() {
        return new PoseFromPairLinear6();
    }

    public static Triangulate2ViewsMetric triangulate2ViewMetric(@Nullable ConfigTriangulation config) {
        if (config == null) {
            config = new ConfigTriangulation();
        }
        switch (config.type) {
            case DLT: {
                return new Wrap2ViewPixelDepthLinear();
            }
            case GEOMETRIC: {
                return new Wrap2ViewsTriangulateGeometric();
            }
        }
        throw new IllegalArgumentException("Unknown or unsupported type " + (Object)((Object)config.type));
    }

    public static Triangulate2ViewsProjective triangulate2ViewProjective(@Nullable ConfigTriangulation config) {
        if (config == null) {
            config = new ConfigTriangulation();
        }
        switch (config.type) {
            case DLT: {
                return new Wrap2ViewsTriangulateProjectiveDLT();
            }
        }
        throw new IllegalArgumentException("Unknown or unsupported type " + (Object)((Object)config.type));
    }

    public static TriangulateNViewsMetric triangulateNViewCalibrated(@Nullable ConfigTriangulation config) {
        if (config == null) {
            config = new ConfigTriangulation();
        }
        switch (config.type) {
            case DLT: {
                return new WrapNViewsTriangulateMetricDLT();
            }
            case GEOMETRIC: {
                WrapNViewsTriangulateMetricDLT estimator = new WrapNViewsTriangulateMetricDLT();
                TriangulateRefineMetricLS refiner = new TriangulateRefineMetricLS(config.converge.gtol, config.converge.maxIterations);
                return new TriangulateThenRefineMetric(estimator, refiner);
            }
        }
        throw new IllegalArgumentException("Unknown or unsupported type " + (Object)((Object)config.type));
    }

    public static TriangulateNViewsProjective triangulateNView(@Nullable ConfigTriangulation config) {
        if (config == null) {
            config = new ConfigTriangulation();
        }
        switch (config.type) {
            case DLT: {
                return new WrapNViewsTriangulateProjectiveDLT();
            }
            case GEOMETRIC: 
            case ALGEBRAIC: {
                WrapNViewsTriangulateProjectiveDLT estimator = new WrapNViewsTriangulateProjectiveDLT();
                TriangulateRefineProjectiveLS refiner = new TriangulateRefineProjectiveLS(config.converge.gtol, config.converge.maxIterations);
                return new TriangulateThenRefineProjective(estimator, refiner);
            }
        }
        throw new IllegalArgumentException("Unknown or unsupported type " + (Object)((Object)config.type));
    }

    public static RefineTriangulateEpipolar triangulateRefineEpipolar(ConfigConverge config) {
        return new TriangulateRefineEpipolarLS(config.gtol, config.maxIterations);
    }

    public static RefineTriangulateMetric triangulateRefineMetric(ConfigConverge config) {
        return new TriangulateRefineMetricLS(config.gtol, config.maxIterations);
    }

    public static RefineTriangulateProjective triangulateRefineProj(ConfigConverge config) {
        return new TriangulateRefineProjectiveLS(config.gtol, config.maxIterations);
    }
}

