/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.abst.fiducial.calib.CalibrationDetectorChessboardBinary;
import boofcv.abst.fiducial.calib.CalibrationDetectorChessboardX;
import boofcv.abst.fiducial.calib.CalibrationDetectorCircleHexagonalGrid;
import boofcv.abst.fiducial.calib.CalibrationDetectorCircleRegularGrid;
import boofcv.abst.fiducial.calib.CalibrationDetectorSquareFiducialGrid;
import boofcv.abst.fiducial.calib.CalibrationDetectorSquareGrid;
import boofcv.abst.fiducial.calib.ConfigChessboardBinary;
import boofcv.abst.fiducial.calib.ConfigChessboardX;
import boofcv.abst.fiducial.calib.ConfigCircleHexagonalGrid;
import boofcv.abst.fiducial.calib.ConfigCircleRegularGrid;
import boofcv.abst.fiducial.calib.ConfigGridDimen;
import boofcv.abst.fiducial.calib.ConfigSquareGrid;
import boofcv.abst.fiducial.calib.ConfigSquareGridBinary;
import javax.annotation.Nullable;

public class FactoryFiducialCalibration {
    public static CalibrationDetectorSquareGrid squareGrid(@Nullable ConfigSquareGrid config, ConfigGridDimen configDimen) {
        if (config == null) {
            config = new ConfigSquareGrid();
        }
        config.checkValidity();
        return new CalibrationDetectorSquareGrid(config, configDimen);
    }

    public static CalibrationDetectorChessboardBinary chessboardB(@Nullable ConfigChessboardBinary configDet, ConfigGridDimen configGrid) {
        if (configDet == null) {
            configDet = new ConfigChessboardBinary();
        }
        configDet.checkValidity();
        return new CalibrationDetectorChessboardBinary(configDet, configGrid);
    }

    public static CalibrationDetectorChessboardX chessboardX(@Nullable ConfigChessboardX config, ConfigGridDimen dimen) {
        if (config == null) {
            config = new ConfigChessboardX();
        }
        config.checkValidity();
        return new CalibrationDetectorChessboardX(config, dimen);
    }

    public static CalibrationDetectorSquareFiducialGrid binaryGrid(ConfigSquareGridBinary config) {
        config.checkValidity();
        return new CalibrationDetectorSquareFiducialGrid(config);
    }

    public static CalibrationDetectorCircleHexagonalGrid circleHexagonalGrid(@Nullable ConfigCircleHexagonalGrid config, ConfigGridDimen configGrid) {
        if (config == null) {
            config = new ConfigCircleHexagonalGrid();
        }
        config.checkValidity();
        return new CalibrationDetectorCircleHexagonalGrid(config, configGrid);
    }

    public static CalibrationDetectorCircleRegularGrid circleRegularGrid(@Nullable ConfigCircleRegularGrid config, ConfigGridDimen configGrid) {
        if (config == null) {
            config = new ConfigCircleRegularGrid();
        }
        config.checkValidity();
        return new CalibrationDetectorCircleRegularGrid(config, configGrid);
    }
}

