/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.factory.fiducial.ConfigLlah;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.shape.ConfigEllipseEdgeCheck;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;
import boofcv.struct.ConnectRule;

public class ConfigUchiyaMarker
implements Configuration {
    public double markerLength = -1.0;
    public ConfigThreshold threshold = ConfigThreshold.local(ThresholdType.LOCAL_MEAN, ConfigLength.fixed(20.0));
    public ConfigLlah llah = new ConfigLlah();
    public ConfigRansac ransac = new ConfigRansac(200, 2.0);
    public ConnectRule contourRule = ConnectRule.EIGHT;
    public int contourMinimumLength = 5;
    public double maxDistanceFromEllipse = 3.0;
    public double minimumMinorAxis = 0.5;
    public double maxMajorToMinorRatio = 5.0;
    public ConfigEllipseEdgeCheck checkEdge = new ConfigEllipseEdgeCheck();

    public ConfigUchiyaMarker() {
        this.llah.numberOfNeighborsN = 7;
        this.llah.sizeOfCombinationM = 5;
        this.llah.quantizationK = 32;
        this.llah.hashType = ConfigLlah.HashType.AFFINE;
        this.llah.hashTableSize = Integer.MAX_VALUE;
    }

    public void setTo(ConfigUchiyaMarker src) {
        this.markerLength = src.markerLength;
        this.threshold.setTo(src.threshold);
        this.llah.setTo(src.llah);
        this.ransac.setTo(src.ransac);
        this.contourRule = src.contourRule;
        this.markerLength = src.markerLength;
        this.contourMinimumLength = src.contourMinimumLength;
        this.maxDistanceFromEllipse = src.maxDistanceFromEllipse;
        this.minimumMinorAxis = src.minimumMinorAxis;
        this.maxMajorToMinorRatio = src.maxMajorToMinorRatio;
        this.checkEdge.setTo(src.checkEdge);
    }

    @Override
    public void checkValidity() {
        this.llah.checkValidity();
        if (this.markerLength <= 0.0) {
            throw new IllegalArgumentException("Marker length must set!");
        }
    }
}

