/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.disparity;

import boofcv.factory.feature.disparity.BlockMatchingApproach;
import boofcv.factory.feature.disparity.ConfigDisparityError;
import boofcv.factory.feature.disparity.DisparitySgmError;
import boofcv.struct.Configuration;
import boofcv.struct.border.BorderType;

public class ConfigDisparitySGM
implements Configuration {
    public int disparityMin = 0;
    public int disparityRange = 100;
    public int maxError = -1;
    public int validateRtoL = 1;
    public double texture = 0.15;
    public boolean subpixel = true;
    public int penaltySmallChange = 200;
    public int penaltyLargeChange = 2000;
    public Paths paths = Paths.P8;
    public DisparitySgmError errorType = DisparitySgmError.CENSUS;
    public boolean useBlocks = true;
    public ConfigDisparityError.Census configCensus = new ConfigDisparityError.Census();
    public ConfigDisparityError.HMI configHMI = new ConfigDisparityError.HMI();
    public ConfigBlockMatchError configBlockMatch = new ConfigBlockMatchError();
    public BorderType border = BorderType.REFLECT;

    public void setTo(ConfigDisparitySGM src) {
        this.disparityMin = src.disparityMin;
        this.disparityRange = src.disparityRange;
        this.maxError = src.maxError;
        this.validateRtoL = src.validateRtoL;
        this.texture = src.texture;
        this.subpixel = src.subpixel;
        this.penaltySmallChange = src.penaltySmallChange;
        this.penaltyLargeChange = src.penaltyLargeChange;
        this.paths = src.paths;
        this.errorType = src.errorType;
        this.useBlocks = src.useBlocks;
        this.configCensus.setTo(src.configCensus);
        this.configHMI.setTo(src.configHMI);
        this.configBlockMatch.setTo(src.configBlockMatch);
        this.border = src.border;
    }

    @Override
    public void checkValidity() {
        if (this.penaltyLargeChange <= this.penaltySmallChange) {
            throw new IllegalArgumentException("large penalty must be larger than small");
        }
        if (this.penaltySmallChange < 0 || this.penaltySmallChange > 2047) {
            throw new IllegalArgumentException("Invalid value for penaltySmallChange.");
        }
        if (this.penaltyLargeChange < 0 || this.penaltyLargeChange > 2047) {
            throw new IllegalArgumentException("Invalid value for penaltySmallChange.");
        }
        if (this.disparityMin < 0) {
            throw new IllegalArgumentException("Minimum disparity must be >= 0");
        }
        this.configBlockMatch.checkValidity();
    }

    public static enum Paths {
        P1(1),
        P2(2),
        P4(4),
        P8(8),
        P16(16);

        private int count;

        private Paths(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class ConfigBlockMatchError
    implements Configuration {
        public int radiusX = 2;
        public int radiusY = 2;
        public BlockMatchingApproach approach = BlockMatchingApproach.BEST5;

        public void setTo(ConfigBlockMatchError src) {
            this.radiusX = src.radiusX;
            this.radiusY = src.radiusY;
        }

        @Override
        public void checkValidity() {
            if (this.radiusX <= 0 || this.radiusY <= 0) {
                throw new IllegalArgumentException("Radius must be positive");
            }
        }
    }
}

