/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detdesc;

import boofcv.abst.feature.describe.ConfigSiftDescribe;
import boofcv.abst.feature.describe.ConfigSiftScaleSpace;
import boofcv.abst.feature.describe.ConfigSurfDescribe;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.detdesc.ConfigCompleteSift;
import boofcv.abst.feature.detdesc.DetectDescribeFusion;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detdesc.DetectDescribe_CompleteSift;
import boofcv.abst.feature.detdesc.SurfPlanar_to_DetectDescribePoint;
import boofcv.abst.feature.detdesc.WrapDetectDescribeSurf;
import boofcv.abst.feature.detdesc.WrapDetectDescribeSurf_MT;
import boofcv.abst.feature.detect.extract.NonMaxLimiter;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigSiftDetector;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.abst.feature.orientation.ConfigAverageIntegral;
import boofcv.abst.feature.orientation.ConfigSiftOrientation;
import boofcv.abst.feature.orientation.ConfigSlidingIntegral;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.describe.DescribePointSift;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.feature.describe.DescribePointSurfMod;
import boofcv.alg.feature.describe.DescribePointSurfPlanar;
import boofcv.alg.feature.detdesc.CompleteSift;
import boofcv.alg.feature.detdesc.DetectDescribeSurfPlanar;
import boofcv.alg.feature.detdesc.DetectDescribeSurfPlanar_MT;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.orientation.OrientationHistogramSift;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.feature.describe.ConfigDescribeRegionPoint;
import boofcv.factory.feature.describe.FactoryDescribePointAlgs;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.factory.feature.detdesc.ConfigDetectDescribe;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.factory.feature.detect.interest.ConfigDetectInterestPoint;
import boofcv.factory.feature.detect.interest.FactoryDetectPoint;
import boofcv.factory.feature.detect.interest.FactoryInterestPoint;
import boofcv.factory.feature.detect.interest.FactoryInterestPointAlgs;
import boofcv.factory.feature.orientation.FactoryOrientation;
import boofcv.factory.feature.orientation.FactoryOrientationAlgs;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import javax.annotation.Nullable;

public class FactoryDetectDescribe {
    public static <T extends ImageGray<T>> DetectDescribePoint<T, BrightFeature> generic(ConfigDetectDescribe config, Class<T> imageType) {
        DescribeRegionPoint<T, TupleDesc<TupleDesc_F64>> descriptor;
        InterestPointDetector<T> detector;
        DetectDescribePoint<T, BrightFeature> detDesc = null;
        if (config.typeDetector == ConfigDetectInterestPoint.DetectorType.FAST_HESSIAN) {
            switch (config.typeDescribe) {
                case SURF_FAST: {
                    detDesc = FactoryDetectDescribe.surfFast(config.detectFastHessian, config.describeSurfFast, null, imageType);
                    break;
                }
                case SURF_STABLE: {
                    detDesc = FactoryDetectDescribe.surfStable(config.detectFastHessian, config.describeSurfStability, null, imageType);
                }
            }
        } else if (config.typeDescribe == ConfigDescribeRegionPoint.DescriptorType.SIFT) {
            ConfigCompleteSift configSift = new ConfigCompleteSift();
            configSift.scaleSpace = config.scaleSpaceSift;
            configSift.detector = config.detectSift;
            configSift.describe = config.describeSift;
            detDesc = FactoryDetectDescribe.sift(configSift, imageType);
        }
        if (detDesc != null) {
            return detDesc;
        }
        switch (config.typeDetector) {
            case FAST_HESSIAN: {
                detector = FactoryInterestPoint.fastHessian(config.detectFastHessian, imageType);
                break;
            }
            case SIFT: {
                detector = FactoryInterestPoint.sift(config.scaleSpaceSift, config.detectSift, imageType);
                break;
            }
            case POINT: {
                GeneralFeatureDetector alg = FactoryDetectPoint.create(config.detectPoint, imageType, null);
                detector = FactoryInterestPoint.wrapPoint(alg, config.detectPoint.scaleRadius, imageType, alg.getDerivType());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown detector");
            }
        }
        switch (config.typeDescribe) {
            case SURF_FAST: {
                descriptor = FactoryDescribeRegionPoint.surfFast(config.describeSurfFast, imageType);
                break;
            }
            case SURF_STABLE: {
                descriptor = FactoryDescribeRegionPoint.surfStable(config.describeSurfStability, imageType);
                break;
            }
            case SIFT: {
                descriptor = FactoryDescribeRegionPoint.sift(config.scaleSpaceSift, config.describeSift, imageType);
                break;
            }
            case BRIEF: {
                descriptor = FactoryDescribeRegionPoint.brief(config.describeBrief, imageType);
                break;
            }
            case TEMPLATE: {
                descriptor = FactoryDescribeRegionPoint.template(config.describeTemplate, imageType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown descriptor");
            }
        }
        OrientationImage<T> orientation = null;
        if (descriptor.isOriented()) {
            Class integralType = GIntegralImageOps.getIntegralType(imageType);
            OrientationIntegral orientationII = FactoryOrientationAlgs.sliding_ii(null, integralType);
            orientation = FactoryOrientation.convertImage(orientationII, imageType);
        }
        return FactoryDetectDescribe.fuseTogether(detector, orientation, descriptor);
    }

    public static <T extends ImageGray<T>> DetectDescribePoint<T, BrightFeature> sift(@Nullable ConfigCompleteSift config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigCompleteSift();
        }
        ConfigSiftScaleSpace configSS = config.scaleSpace;
        ConfigSiftDetector configDetector = config.detector;
        ConfigSiftOrientation configOri = config.orientation;
        ConfigSiftDescribe configDesc = config.describe;
        SiftScaleSpace scaleSpace = new SiftScaleSpace(configSS.firstOctave, configSS.lastOctave, configSS.numScales, configSS.sigma0);
        OrientationHistogramSift<GrayF32> orientation = new OrientationHistogramSift<GrayF32>(configOri.histogramSize, configOri.sigmaEnlarge, GrayF32.class);
        DescribePointSift<GrayF32> describe = new DescribePointSift<GrayF32>(configDesc.widthSubregion, configDesc.widthGrid, configDesc.numHistogramBins, configDesc.sigmaToPixels, configDesc.weightingSigmaFraction, configDesc.maxDescriptorElementValue, GrayF32.class);
        NonMaxSuppression nns = FactoryFeatureExtractor.nonmax(configDetector.extract);
        NonMaxLimiter nonMax = new NonMaxLimiter(nns, configDetector.maxFeaturesPerScale);
        CompleteSift dds = new CompleteSift(scaleSpace, configDetector.edgeR, nonMax, orientation, describe);
        return new DetectDescribe_CompleteSift<T>(dds, imageType);
    }

    public static <T extends ImageGray<T>, II extends ImageGray<II>> DetectDescribePoint<T, BrightFeature> surfFast(@Nullable ConfigFastHessian configDetector, @Nullable ConfigSurfDescribe.Fast configDesc, @Nullable ConfigAverageIntegral configOrientation, Class<T> imageType) {
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        FastHessianFeatureDetector detector = FactoryInterestPointAlgs.fastHessian(configDetector);
        DescribePointSurf describe = FactoryDescribePointAlgs.surfSpeed(configDesc, integralType);
        OrientationIntegral orientation = FactoryOrientationAlgs.average_ii(configOrientation, integralType);
        if (BoofConcurrency.USE_CONCURRENT) {
            return new WrapDetectDescribeSurf_MT(detector, orientation, describe, imageType);
        }
        return new WrapDetectDescribeSurf(detector, orientation, describe, imageType);
    }

    public static <T extends ImageGray<T>, II extends ImageGray<II>> DetectDescribePoint<T, BrightFeature> surfColorFast(@Nullable ConfigFastHessian configDetector, @Nullable ConfigSurfDescribe.Fast configDesc, @Nullable ConfigAverageIntegral configOrientation, ImageType<T> imageType) {
        Class bandType = imageType.getImageClass();
        Class integralType = GIntegralImageOps.getIntegralType(bandType);
        FastHessianFeatureDetector detector = FactoryInterestPointAlgs.fastHessian(configDetector);
        DescribePointSurf describe = FactoryDescribePointAlgs.surfSpeed(configDesc, integralType);
        OrientationIntegral orientation = FactoryOrientationAlgs.average_ii(configOrientation, integralType);
        if (imageType.getFamily() == ImageType.Family.PLANAR) {
            DescribePointSurfPlanar describeMulti = new DescribePointSurfPlanar(describe, imageType.getNumBands());
            DetectDescribeSurfPlanar detectDesc = FactoryDetectDescribe.createDescribeSurfPlanar(detector, orientation, describeMulti);
            return new SurfPlanar_to_DetectDescribePoint(detectDesc, bandType, integralType);
        }
        throw new IllegalArgumentException("Image type not supported");
    }

    protected static <II extends ImageGray<II>> DetectDescribeSurfPlanar<II> createDescribeSurfPlanar(FastHessianFeatureDetector<II> detector, OrientationIntegral<II> orientation, DescribePointSurfPlanar<II> describeMulti) {
        DetectDescribeSurfPlanar detectDesc = BoofConcurrency.USE_CONCURRENT ? new DetectDescribeSurfPlanar_MT<II>(detector, orientation, describeMulti) : new DetectDescribeSurfPlanar<II>(detector, orientation, describeMulti);
        return detectDesc;
    }

    public static <T extends ImageGray<T>, II extends ImageGray<II>> DetectDescribePoint<T, BrightFeature> surfStable(@Nullable ConfigFastHessian configDetector, @Nullable ConfigSurfDescribe.Stability configDescribe, @Nullable ConfigSlidingIntegral configOrientation, Class<T> imageType) {
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        FastHessianFeatureDetector detector = FactoryInterestPointAlgs.fastHessian(configDetector);
        DescribePointSurfMod describe = FactoryDescribePointAlgs.surfStability(configDescribe, integralType);
        OrientationIntegral orientation = FactoryOrientationAlgs.sliding_ii(configOrientation, integralType);
        if (BoofConcurrency.USE_CONCURRENT) {
            return new WrapDetectDescribeSurf_MT(detector, orientation, describe, imageType);
        }
        return new WrapDetectDescribeSurf(detector, orientation, describe, imageType);
    }

    public static <T extends ImageMultiBand<T>, II extends ImageGray<II>> DetectDescribePoint<T, BrightFeature> surfColorStable(@Nullable ConfigFastHessian configDetector, @Nullable ConfigSurfDescribe.Stability configDescribe, @Nullable ConfigSlidingIntegral configOrientation, ImageType<T> imageType) {
        Class bandType = imageType.getImageClass();
        Class integralType = GIntegralImageOps.getIntegralType(bandType);
        FastHessianFeatureDetector detector = FactoryInterestPointAlgs.fastHessian(configDetector);
        DescribePointSurfMod describe = FactoryDescribePointAlgs.surfStability(configDescribe, integralType);
        OrientationIntegral orientation = FactoryOrientationAlgs.sliding_ii(configOrientation, integralType);
        if (imageType.getFamily() == ImageType.Family.PLANAR) {
            DescribePointSurfPlanar describeMulti = new DescribePointSurfPlanar(describe, imageType.getNumBands());
            DetectDescribeSurfPlanar detectDesc = FactoryDetectDescribe.createDescribeSurfPlanar(detector, orientation, describeMulti);
            return new SurfPlanar_to_DetectDescribePoint(detectDesc, bandType, integralType);
        }
        throw new IllegalArgumentException("Image type not supported");
    }

    public static <T extends ImageGray<T>, D extends TupleDesc> DetectDescribePoint<T, D> fuseTogether(InterestPointDetector<T> detector, @Nullable OrientationImage<T> orientation, DescribeRegionPoint<T, D> describe) {
        return new DetectDescribeFusion<T, D>(detector, orientation, describe);
    }
}

