/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.associate.EnforceUniqueByScore;
import boofcv.abst.feature.associate.ScoreAssociateEuclideanSq_F32;
import boofcv.abst.feature.associate.ScoreAssociateEuclideanSq_F64;
import boofcv.abst.feature.associate.ScoreAssociateEuclidean_F64;
import boofcv.abst.feature.associate.ScoreAssociateHamming_B;
import boofcv.abst.feature.associate.ScoreAssociateNccFeature;
import boofcv.abst.feature.associate.ScoreAssociateSad_F32;
import boofcv.abst.feature.associate.ScoreAssociateSad_F64;
import boofcv.abst.feature.associate.ScoreAssociateSad_S8;
import boofcv.abst.feature.associate.ScoreAssociateSad_U8;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.associate.WrapAssociateGreedy;
import boofcv.abst.feature.describe.DescriptorInfo;
import boofcv.alg.descriptor.KdTreeTuple_F64;
import boofcv.alg.feature.associate.AssociateGreedy;
import boofcv.alg.feature.associate.AssociateGreedyBase;
import boofcv.alg.feature.associate.AssociateGreedy_MT;
import boofcv.alg.feature.associate.AssociateNearestNeighbor;
import boofcv.alg.feature.associate.AssociateNearestNeighbor_MT;
import boofcv.alg.feature.associate.AssociateNearestNeighbor_ST;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.feature.associate.ConfigAssociate;
import boofcv.factory.feature.associate.ConfigAssociateGreedy;
import boofcv.factory.feature.associate.ConfigAssociateNearestNeighbor;
import boofcv.struct.feature.NccFeature;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.feature.TupleDesc_F32;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.feature.TupleDesc_S8;
import boofcv.struct.feature.TupleDesc_U8;
import javax.annotation.Nullable;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;

public class FactoryAssociation {
    public static <D> AssociateDescription<D> generic(ConfigAssociate config, DescriptorInfo info) {
        int DOF = info.createDescription().size();
        switch (config.type) {
            case GREEDY: {
                ScoreAssociation scorer = FactoryAssociation.defaultScore(info.getDescriptionType());
                return FactoryAssociation.greedy(config.greedy, scorer);
            }
            case KD_TREE: {
                return FactoryAssociation.kdtree(config.nearestNeighbor, DOF);
            }
            case RANDOM_FOREST: {
                return FactoryAssociation.kdRandomForest(config.nearestNeighbor, DOF, 10, 5, 1233445565L);
            }
        }
        throw new IllegalArgumentException("Unknown association: " + (Object)((Object)config.type));
    }

    public static <D> AssociateDescription<D> ensureUnique(AssociateDescription<D> associate) {
        if (!associate.uniqueDestination() || !associate.uniqueSource()) {
            return new EnforceUniqueByScore.Describe<D>(associate, true, true);
        }
        return associate;
    }

    public static <D> AssociateDescription2D<D> ensureUnique(AssociateDescription2D<D> associate) {
        if (!associate.uniqueDestination() || !associate.uniqueSource()) {
            return new EnforceUniqueByScore.Describe2D<D>(associate, true, true);
        }
        return associate;
    }

    public static <D> AssociateDescription<D> greedy(ConfigAssociateGreedy config, ScoreAssociation<D> score) {
        AssociateGreedyBase alg = BoofConcurrency.USE_CONCURRENT ? new AssociateGreedy_MT<D>(score, config.forwardsBackwards) : new AssociateGreedy<D>(score, config.forwardsBackwards);
        alg.setMaxFitError(config.maxErrorThreshold);
        alg.setRatioTest(config.scoreRatioThreshold);
        return new WrapAssociateGreedy(alg);
    }

    public static AssociateDescription<TupleDesc_F64> kdtree(@Nullable ConfigAssociateNearestNeighbor configNN, int dimension) {
        NearestNeighbor<TupleDesc_F64> nn = FactoryNearestNeighbor.kdtree(new KdTreeTuple_F64(dimension), configNN.maxNodesSearched);
        return FactoryAssociation.associateNearestNeighbor(configNN, nn);
    }

    public static AssociateDescription<TupleDesc_F64> kdRandomForest(@Nullable ConfigAssociateNearestNeighbor configNN, int dimension, int numTrees, int numConsiderSplit, long randomSeed) {
        if (configNN == null) {
            configNN = new ConfigAssociateNearestNeighbor();
        }
        NearestNeighbor<TupleDesc_F64> nn = FactoryNearestNeighbor.kdRandomForest(new KdTreeTuple_F64(dimension), configNN.maxNodesSearched, numTrees, numConsiderSplit, randomSeed);
        return FactoryAssociation.associateNearestNeighbor(configNN, nn);
    }

    public static AssociateNearestNeighbor<TupleDesc_F64> associateNearestNeighbor(@Nullable ConfigAssociateNearestNeighbor config, NearestNeighbor nn) {
        if (config == null) {
            config = new ConfigAssociateNearestNeighbor();
        }
        config.checkValidity();
        AssociateNearestNeighbor assoc = BoofConcurrency.USE_CONCURRENT ? new AssociateNearestNeighbor_MT(nn) : new AssociateNearestNeighbor_ST(nn);
        assoc.setRatioUsesSqrt(config.distanceIsSquared);
        assoc.setMaxScoreThreshold(config.maxErrorThreshold);
        assoc.setScoreRatioThreshold(config.scoreRatioThreshold);
        return assoc;
    }

    public static <D> ScoreAssociation<D> defaultScore(Class<D> tupleType) {
        if (NccFeature.class.isAssignableFrom(tupleType)) {
            return new ScoreAssociateNccFeature();
        }
        if (TupleDesc_F64.class.isAssignableFrom(tupleType)) {
            return new ScoreAssociateEuclideanSq_F64();
        }
        if (tupleType == TupleDesc_F32.class) {
            return new ScoreAssociateEuclideanSq_F32();
        }
        if (tupleType == TupleDesc_U8.class) {
            return new ScoreAssociateSad_U8();
        }
        if (tupleType == TupleDesc_B.class) {
            return new ScoreAssociateHamming_B();
        }
        throw new IllegalArgumentException("Unknown tuple type: " + tupleType);
    }

    public static <D> ScoreAssociation<D> scoreSad(Class<D> tupleType) {
        if (TupleDesc_F64.class.isAssignableFrom(tupleType)) {
            return new ScoreAssociateSad_F64();
        }
        if (tupleType == TupleDesc_F32.class) {
            return new ScoreAssociateSad_F32();
        }
        if (tupleType == TupleDesc_U8.class) {
            return new ScoreAssociateSad_U8();
        }
        if (tupleType == TupleDesc_S8.class) {
            return new ScoreAssociateSad_S8();
        }
        throw new IllegalArgumentException("SAD score not supported for type " + tupleType.getSimpleName());
    }

    public static ScoreAssociation<NccFeature> scoreNcc() {
        return new ScoreAssociateNccFeature();
    }

    public static <D> ScoreAssociation<D> scoreEuclidean(Class<D> tupleType, boolean squared) {
        if (TupleDesc_F64.class.isAssignableFrom(tupleType)) {
            if (squared) {
                return new ScoreAssociateEuclideanSq_F64();
            }
            return new ScoreAssociateEuclidean_F64();
        }
        if (tupleType == TupleDesc_F32.class && squared) {
            return new ScoreAssociateEuclideanSq_F32();
        }
        throw new IllegalArgumentException("Euclidean score not yet supported for type " + tupleType.getSimpleName());
    }

    public static <D> ScoreAssociation<D> scoreHamming(Class<D> tupleType) {
        if (tupleType == TupleDesc_B.class) {
            return new ScoreAssociateHamming_B();
        }
        throw new IllegalArgumentException("Hamming distance not yet supported for type " + tupleType.getSimpleName());
    }
}

