/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.tld;

import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class TldVarianceFilter<T extends ImageGray<T>> {
    private double thresholdLower;
    private ImageGray integral;
    private ImageGray integralSq;

    public TldVarianceFilter(Class<T> imageType) {
        if (GeneralizedImageOps.isFloatingPoint(imageType)) {
            this.integral = new GrayF32(1, 1);
            this.integralSq = new GrayF64(1, 1);
        } else {
            this.integral = new GrayS32(1, 1);
            this.integralSq = new GrayS64(1, 1);
        }
    }

    protected TldVarianceFilter() {
    }

    public void setImage(T gray) {
        this.integral.reshape(((ImageGray)gray).width, ((ImageGray)gray).height);
        this.integralSq.reshape(((ImageGray)gray).width, ((ImageGray)gray).height);
        GIntegralImageOps.transform(gray, this.integral);
        if (((ImageGray)gray).getDataType().isInteger()) {
            TldVarianceFilter.transformSq((GrayU8)gray, (GrayS64)this.integralSq);
        } else {
            TldVarianceFilter.transformSq((GrayF32)gray, (GrayF64)this.integralSq);
        }
    }

    public void selectThreshold(ImageRectangle r) {
        double variance = this.computeVarianceSafe(r.x0, r.y0, r.x1, r.y1);
        this.thresholdLower = variance * 0.5;
    }

    public boolean checkVariance(ImageRectangle r) {
        double sigma2 = this.computeVariance(r.x0, r.y0, r.x1, r.y1);
        return sigma2 >= this.thresholdLower;
    }

    protected double computeVariance(int x0, int y0, int x1, int y1) {
        double square = GIntegralImageOps.block_unsafe(this.integralSq, x0 - 1, y0 - 1, x1 - 1, y1 - 1);
        double area = (x1 - x0) * (y1 - y0);
        double mean = GIntegralImageOps.block_unsafe(this.integral, x0 - 1, y0 - 1, x1 - 1, y1 - 1) / area;
        return square / area - mean * mean;
    }

    protected double computeVarianceSafe(int x0, int y0, int x1, int y1) {
        double square = GIntegralImageOps.block_zero(this.integralSq, x0 - 1, y0 - 1, x1 - 1, y1 - 1);
        double area = (x1 - x0) * (y1 - y0);
        double mean = GIntegralImageOps.block_zero(this.integral, x0 - 1, y0 - 1, x1 - 1, y1 - 1) / area;
        return square / area - mean * mean;
    }

    public static void transformSq(GrayU8 input, GrayS64 transformed) {
        int indexSrc;
        int indexDst = transformed.startIndex;
        int end = indexSrc + input.width;
        long total = 0L;
        for (indexSrc = input.startIndex; indexSrc < end; ++indexSrc) {
            int value = input.data[indexSrc] & 0xFF;
            transformed.data[indexDst++] = total += (long)(value * value);
        }
        for (int y = 1; y < input.height; ++y) {
            indexDst = transformed.startIndex + transformed.stride * y;
            int indexPrev = indexDst - transformed.stride;
            end = indexSrc + input.width;
            total = 0L;
            for (indexSrc = input.startIndex + input.stride * y; indexSrc < end; ++indexSrc) {
                int value = input.data[indexSrc] & 0xFF;
                transformed.data[indexDst++] = transformed.data[indexPrev++] + (total += (long)(value * value));
            }
        }
    }

    public static void transformSq(GrayF32 input, GrayF64 transformed) {
        int indexSrc;
        int indexDst = transformed.startIndex;
        int end = indexSrc + input.width;
        double total = 0.0;
        for (indexSrc = input.startIndex; indexSrc < end; ++indexSrc) {
            float value = input.data[indexSrc];
            transformed.data[indexDst++] = total += (double)(value * value);
        }
        for (int y = 1; y < input.height; ++y) {
            indexDst = transformed.startIndex + transformed.stride * y;
            int indexPrev = indexDst - transformed.stride;
            end = indexSrc + input.width;
            total = 0.0;
            for (indexSrc = input.startIndex + input.stride * y; indexSrc < end; ++indexSrc) {
                float value = input.data[indexSrc];
                transformed.data[indexDst++] = transformed.data[indexPrev++] + (total += (double)(value * value));
            }
        }
    }

    public double getThresholdLower() {
        return this.thresholdLower;
    }
}

