/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.meanshift;

import boofcv.alg.tracker.meanshift.PixelLikelihood;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;
import georegression.struct.shapes.RectangleLength2D_I32;

public class LikelihoodHistCoupled_PL_U8
implements PixelLikelihood<Planar<GrayU8>> {
    Planar<GrayU8> image;
    int maxPixelValue;
    int numBins;
    float[] hist = new float[0];

    public LikelihoodHistCoupled_PL_U8(int maxPixelValue, int numBins) {
        this.maxPixelValue = maxPixelValue + 1;
        this.numBins = numBins;
    }

    @Override
    public void setImage(Planar<GrayU8> image) {
        this.image = image;
        int histElements = 1;
        for (int i = 0; i < image.getNumBands(); ++i) {
            histElements *= this.numBins;
        }
        if (this.hist.length != histElements) {
            this.hist = new float[histElements];
        }
    }

    @Override
    public boolean isInBounds(int x, int y) {
        return this.image.isInBounds(x, y);
    }

    @Override
    public void createModel(RectangleLength2D_I32 target) {
        for (int y = 0; y < target.height; ++y) {
            int index = this.image.startIndex + (y + target.y0) * this.image.stride + target.x0;
            int x = 0;
            while (x < target.width) {
                int indexBin = 0;
                int binStride = 1;
                for (int i = 0; i < this.image.getNumBands(); ++i) {
                    GrayU8 band = this.image.getBand(i);
                    int value = band.data[index] & 0xFF;
                    int bin = this.numBins * value / this.maxPixelValue;
                    indexBin += bin * binStride;
                    binStride *= this.numBins;
                }
                int n = indexBin;
                this.hist[n] = this.hist[n] + 1.0f;
                ++x;
                ++index;
            }
        }
        float total = target.width * target.height;
        int i = 0;
        while (i < this.hist.length) {
            int n = i++;
            this.hist[n] = this.hist[n] / total;
        }
    }

    @Override
    public float compute(int x, int y) {
        int index = this.image.startIndex + y * this.image.stride + x;
        int indexBin = 0;
        int binStride = 1;
        for (int i = 0; i < this.image.getNumBands(); ++i) {
            GrayU8 band = this.image.getBand(i);
            int value = band.data[index] & 0xFF;
            int bin = this.numBins * value / this.maxPixelValue;
            indexBin += bin * binStride;
            binStride *= this.numBins;
        }
        return this.hist[indexBin];
    }
}

