/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polyline;

import boofcv.misc.CircularIndex;
import georegression.fitting.line.FitLine_F64;
import georegression.geometry.UtilLine2D_F64;
import georegression.geometry.UtilPoint2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LinePolar2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.Arrays;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class FitLinesToContour {
    int maxSamples = 20;
    int maxIterations = 5;
    int minimumLineLength = 4;
    List<Point2D_I32> contour;
    FastQueue<LineGeneral2D_F64> lines = new FastQueue<LineGeneral2D_F64>(LineGeneral2D_F64::new);
    FastQueue<Point2D_F64> pointsFit = new FastQueue<Point2D_F64>(Point2D_F64::new);
    private LinePolar2D_F64 linePolar = new LinePolar2D_F64();
    private Point2D_F64 intersection = new Point2D_F64();
    private GrowQueue_I32 workCorners = new GrowQueue_I32();
    int anchor0;
    int anchor1;
    boolean verbose = false;
    GrowQueue_I32 skippedCorners = new GrowQueue_I32();

    public void setContour(List<Point2D_I32> contour) {
        this.contour = contour;
    }

    public boolean fitAnchored(int anchor0, int anchor1, GrowQueue_I32 corners, GrowQueue_I32 output) {
        int numLines;
        this.anchor0 = anchor0;
        this.anchor1 = anchor1;
        int n = numLines = anchor0 == anchor1 ? corners.size() : CircularIndex.distanceP(anchor0, anchor1, corners.size);
        if (numLines < 2) {
            throw new RuntimeException("The one line is anchored and can't be optimized");
        }
        this.lines.resize(numLines);
        if (this.verbose) {
            System.out.println("ENTER FitLinesToContour");
        }
        this.workCorners.setTo(corners);
        for (int iteration = 0; iteration < this.maxIterations; ++iteration) {
            if (!this.fitLinesUsingCorners(numLines, this.workCorners)) {
                return false;
            }
            if (!this.linesIntoCorners(numLines, this.workCorners)) {
                return false;
            }
            if (this.sanityCheckCornerOrder(numLines, this.workCorners)) continue;
            return false;
        }
        if (this.verbose) {
            System.out.println("EXIT FitLinesToContour. " + corners.size() + "  " + this.workCorners.size());
        }
        output.setTo(this.workCorners);
        return true;
    }

    boolean sanityCheckCornerOrder(int numLines, GrowQueue_I32 corners) {
        int contourAnchor0 = corners.get(this.anchor0);
        int previous = 0;
        for (int i = 1; i < numLines; ++i) {
            int contourIndex = corners.get(CircularIndex.addOffset(this.anchor0, i, corners.size()));
            int pixelsFromAnchor0 = CircularIndex.distanceP(contourAnchor0, contourIndex, this.contour.size());
            if (pixelsFromAnchor0 < previous) {
                return false;
            }
            previous = pixelsFromAnchor0;
        }
        return true;
    }

    boolean linesIntoCorners(int numLines, GrowQueue_I32 contourCorners) {
        int i;
        this.skippedCorners.reset();
        int contourIndexPrevious = contourCorners.get(this.anchor0);
        for (int i2 = 1; i2 < numLines; ++i2) {
            LineGeneral2D_F64 line0 = (LineGeneral2D_F64)this.lines.get(i2 - 1);
            LineGeneral2D_F64 line1 = (LineGeneral2D_F64)this.lines.get(i2);
            int cornerIndex = CircularIndex.addOffset(this.anchor0, i2, contourCorners.size);
            boolean skipped = false;
            if (null == Intersection2D_F64.intersection(line0, line1, this.intersection)) {
                if (this.verbose) {
                    System.out.println("  SKIPPING no intersection");
                }
                skipped = true;
            } else {
                int contourIndex = this.closestPoint(this.intersection);
                if (contourIndex != contourIndexPrevious) {
                    Point2D_I32 a = this.contour.get(contourIndexPrevious);
                    Point2D_I32 b = this.contour.get(contourIndex);
                    if (a.x == b.x && a.y == b.y) {
                        if (this.verbose) {
                            System.out.println("  SKIPPING duplicate coordinate");
                        }
                        skipped = true;
                    } else {
                        contourCorners.set(cornerIndex, contourIndex);
                        contourIndexPrevious = contourIndex;
                    }
                } else {
                    if (this.verbose) {
                        System.out.println("  SKIPPING duplicate corner index");
                    }
                    skipped = true;
                }
            }
            if (!skipped) continue;
            this.skippedCorners.add(cornerIndex);
        }
        int cornerIndex = CircularIndex.addOffset(this.anchor0, numLines, contourCorners.size);
        Point2D_I32 a = this.contour.get(contourIndexPrevious);
        Point2D_I32 b = this.contour.get(contourCorners.get(cornerIndex));
        if (a.x == b.x && a.y == b.y) {
            this.skippedCorners.add(cornerIndex);
        }
        Arrays.sort(this.skippedCorners.data, 0, this.skippedCorners.size);
        for (i = this.skippedCorners.size - 1; i >= 0; --i) {
            int index = this.skippedCorners.get(i);
            contourCorners.remove(index);
            if (this.anchor0 >= index) {
                --this.anchor0;
            }
            if (this.anchor1 < index) continue;
            --this.anchor1;
        }
        numLines -= this.skippedCorners.size;
        for (i = 0; i < numLines; ++i) {
            int c0 = CircularIndex.addOffset(this.anchor0, i, contourCorners.size);
            int c1 = CircularIndex.addOffset(this.anchor0, i + 1, contourCorners.size);
            a = this.contour.get(contourCorners.get(c0));
            b = this.contour.get(contourCorners.get(c1));
            if (a.x != b.x || a.y != b.y) continue;
            throw new RuntimeException("Well I screwed up");
        }
        return contourCorners.size() >= 3;
    }

    boolean fitLinesUsingCorners(int numLines, GrowQueue_I32 cornerIndexes) {
        for (int i = 1; i <= numLines; ++i) {
            int index1;
            int index0 = cornerIndexes.get(CircularIndex.addOffset(this.anchor0, i - 1, cornerIndexes.size));
            if (index0 == (index1 = cornerIndexes.get(CircularIndex.addOffset(this.anchor0, i, cornerIndexes.size)))) {
                return false;
            }
            if (!this.fitLine(index0, index1, (LineGeneral2D_F64)this.lines.get(i - 1))) {
                return false;
            }
            LineGeneral2D_F64 l = (LineGeneral2D_F64)this.lines.get(i - 1);
            if (!Double.isNaN(l.A) && !Double.isNaN(l.B) && !Double.isNaN(l.C)) continue;
            throw new RuntimeException("This should be impossible");
        }
        return true;
    }

    boolean fitLine(int contourIndex0, int contourIndex1, LineGeneral2D_F64 line) {
        int numPixels = CircularIndex.distanceP(contourIndex0, contourIndex1, this.contour.size());
        if (numPixels < this.minimumLineLength) {
            return false;
        }
        Point2D_I32 c0 = this.contour.get(contourIndex0);
        Point2D_I32 c1 = this.contour.get(contourIndex1);
        double scale = c0.distance(c1);
        double centerX = (double)(c1.x + c0.x) / 2.0;
        double centerY = (double)(c1.y + c0.y) / 2.0;
        int numSamples = Math.min(this.maxSamples, numPixels);
        this.pointsFit.reset();
        for (int i = 0; i < numSamples; ++i) {
            int index = i * (numPixels - 1) / (numSamples - 1);
            Point2D_I32 c = this.contour.get(CircularIndex.addOffset(contourIndex0, index, this.contour.size()));
            Point2D_F64 p = this.pointsFit.grow();
            p.x = ((double)c.x - centerX) / scale;
            p.y = ((double)c.y - centerY) / scale;
        }
        if (null == FitLine_F64.polar(this.pointsFit.toList(), this.linePolar)) {
            return false;
        }
        UtilLine2D_F64.convert(this.linePolar, line);
        line.C = scale * line.C - centerX * line.A - centerY * line.B;
        return true;
    }

    int closestPoint(Point2D_F64 target) {
        double bestDistance = Double.MAX_VALUE;
        int bestIndex = -1;
        for (int i = 0; i < this.contour.size(); ++i) {
            Point2D_I32 c = this.contour.get(i);
            double d = UtilPoint2D_F64.distanceSq(target.x, target.y, c.x, c.y);
            if (!(d < bestDistance)) continue;
            bestDistance = d;
            bestIndex = i;
        }
        return bestIndex;
    }
}

