/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polygon;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_I32;
import java.util.List;

public class ContourEdgeIntensity<T extends ImageGray<T>> {
    private int contourSamples;
    private int tangentSamples;
    private float tangentStep;
    private InterpolatePixelS<T> sampler;
    private int imageWidth;
    private int imageHeight;
    private float edgeInside;
    private float edgeOutside;

    public ContourEdgeIntensity(int contourSamples, int tangentSamples, double tangentStep, Class<T> imageType) {
        this.contourSamples = contourSamples;
        this.tangentSamples = tangentSamples;
        this.tangentStep = (float)tangentStep;
        this.sampler = FactoryInterpolation.bilinearPixelS(imageType, BorderType.EXTENDED);
    }

    public void setImage(T image) {
        this.sampler.setImage(image);
        this.imageWidth = ((ImageGray)image).width;
        this.imageHeight = ((ImageGray)image).height;
    }

    public void process(List<Point2D_I32> contour, boolean isCCW) {
        if (this.imageWidth == 0) {
            throw new RuntimeException("You didn't call setImage()");
        }
        int step = contour.size() <= this.contourSamples ? 1 : contour.size() / this.contourSamples;
        int sample = Math.max(1, Math.min(step / 2, 5));
        this.edgeInside = 0.0f;
        this.edgeOutside = 0.0f;
        int totalInside = 0;
        int totalOutside = 0;
        for (int i = 0; i < contour.size(); i += step) {
            Point2D_I32 a = contour.get(i);
            Point2D_I32 b = contour.get((i + sample) % contour.size());
            float dx = b.x - a.x;
            float dy = b.y - a.y;
            float r = (float)Math.sqrt(dx * dx + dy * dy);
            dx /= r;
            dy /= r;
            for (int j = 0; j < this.tangentSamples; ++j) {
                float length = (float)(j + 1) * this.tangentStep;
                float x = (float)a.x + length * dy;
                float y = (float)a.y - length * dx;
                if (x >= 0.0f && y >= 0.0f && x <= (float)(this.imageWidth - 1) && y <= (float)(this.imageHeight - 1)) {
                    this.edgeOutside += this.sampler.get(x, y);
                    ++totalOutside;
                }
                x = (float)a.x - length * dy;
                y = (float)a.y + length * dx;
                if (!(x >= 0.0f) || !(y >= 0.0f) || !(x <= (float)(this.imageWidth - 1)) || !(y <= (float)(this.imageHeight - 1))) continue;
                this.edgeInside += this.sampler.get(x, y);
                ++totalInside;
            }
        }
        this.edgeOutside /= (float)totalOutside;
        this.edgeInside /= (float)totalInside;
        if (!isCCW) {
            float tmp = this.edgeOutside;
            this.edgeOutside = this.edgeInside;
            this.edgeInside = tmp;
        }
    }

    public float getOutsideAverage() {
        return this.edgeOutside;
    }

    public float getInsideAverage() {
        return this.edgeInside;
    }

    public Class<T> getInputType() {
        return this.sampler.getImageType().getImageClass();
    }
}

