/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.edge;

import boofcv.alg.interpolate.ImageLineIntegral;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GImageGray;
import boofcv.core.image.GImageGrayDistorted;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F32;

public class BaseIntegralEdge<T extends ImageGray<T>> {
    Class<T> imageType;
    protected ImageLineIntegral integral;
    protected GImageGray integralImage;

    public BaseIntegralEdge(Class<T> imageType) {
        this.imageType = imageType;
        this.integral = new ImageLineIntegral();
        this.integralImage = FactoryGImageGray.create(imageType);
    }

    public void setTransform(PixelTransform<Point2D_F32> undistToDist) {
        if (undistToDist != null) {
            InterpolatePixelS<T> interpolate = FactoryInterpolation.bilinearPixelS(this.imageType, BorderType.EXTENDED);
            this.integralImage = new GImageGrayDistorted<T>(undistToDist, interpolate);
        } else {
            this.integralImage = FactoryGImageGray.create(this.imageType);
        }
    }

    public void setImage(T image) {
        this.integralImage.wrap((ImageGray)image);
        this.integral.setImage(this.integralImage);
    }

    public Class<T> getInputType() {
        return this.imageType;
    }
}

