/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes;

import boofcv.alg.shapes.FitData;
import boofcv.alg.shapes.polyline.splitmerge.PolylineSplitMerge;
import boofcv.struct.PointIndex_I32;
import georegression.fitting.curves.ClosestPointEllipseAngle_F64;
import georegression.fitting.curves.FitEllipseAlgebraic_F64;
import georegression.fitting.curves.RefineEllipseEuclideanLeastSquares_F64;
import georegression.geometry.UtilEllipse_F64;
import georegression.struct.curve.EllipseRotated_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.trig.Circle2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;
import org.ddogleg.struct.GrowQueue_I32;

public class ShapeFittingOps {
    public static List<PointIndex_I32> fitPolygon(List<Point2D_I32> sequence, boolean loop, int minimumSideLength, double cornerPenalty) {
        PolylineSplitMerge alg = new PolylineSplitMerge();
        alg.setLoops(loop);
        alg.setMinimumSideLength(minimumSideLength);
        alg.setCornerScorePenalty(cornerPenalty);
        alg.process(sequence);
        PolylineSplitMerge.CandidatePolyline best = alg.getBestPolyline();
        FastQueue<PointIndex_I32> output = new FastQueue<PointIndex_I32>(PointIndex_I32::new);
        if (best != null) {
            ShapeFittingOps.indexToPointIndex(sequence, best.splits, output);
        }
        return new ArrayList<PointIndex_I32>(output.toList());
    }

    public static FitData<EllipseRotated_F64> fitEllipse_F64(List<Point2D_F64> points, int iterations, boolean computeError, FitData<EllipseRotated_F64> outputStorage) {
        FitEllipseAlgebraic_F64 algebraic;
        if (outputStorage == null) {
            outputStorage = new FitData<EllipseRotated_F64>(new EllipseRotated_F64());
        }
        if (!(algebraic = new FitEllipseAlgebraic_F64()).process(points)) {
            FitData<Circle2D_F64> circleData = ShapeFittingOps.averageCircle_F64(points, null, null);
            Circle2D_F64 circle = (Circle2D_F64)circleData.shape;
            ((EllipseRotated_F64)outputStorage.shape).set(circle.center.x, circle.center.y, circle.radius, circle.radius, 0.0);
        } else {
            UtilEllipse_F64.convert(algebraic.getEllipse(), (EllipseRotated_F64)outputStorage.shape);
        }
        if (iterations > 0) {
            RefineEllipseEuclideanLeastSquares_F64 leastSquares = new RefineEllipseEuclideanLeastSquares_F64();
            leastSquares.setMaxIterations(iterations);
            leastSquares.refine((EllipseRotated_F64)outputStorage.shape, points);
            ((EllipseRotated_F64)outputStorage.shape).set(leastSquares.getFound());
        }
        if (computeError) {
            ClosestPointEllipseAngle_F64 closestPoint = new ClosestPointEllipseAngle_F64(1.0E-8, 100);
            closestPoint.setEllipse((EllipseRotated_F64)outputStorage.shape);
            double total = 0.0;
            for (Point2D_F64 p : points) {
                closestPoint.process(p);
                total += p.distance(closestPoint.getClosest());
            }
            outputStorage.error = total / (double)points.size();
        } else {
            outputStorage.error = 0.0;
        }
        return outputStorage;
    }

    public static FitData<EllipseRotated_F64> fitEllipse_I32(List<Point2D_I32> points, int iterations, boolean computeError, FitData<EllipseRotated_F64> outputStorage) {
        List<Point2D_F64> pointsF = ShapeFittingOps.convert_I32_F64(points);
        return ShapeFittingOps.fitEllipse_F64(pointsF, iterations, computeError, outputStorage);
    }

    public static List<Point2D_F64> convert_I32_F64(List<Point2D_I32> points) {
        return ShapeFittingOps.convert_I32_F64(points, null).toList();
    }

    public static FastQueue<Point2D_F64> convert_I32_F64(List<Point2D_I32> input, FastQueue<Point2D_F64> output) {
        if (output == null) {
            output = new FastQueue<Point2D_F64>(input.size(), Point2D_F64::new);
        } else {
            output.reset();
        }
        for (int i = 0; i < input.size(); ++i) {
            Point2D_I32 p = input.get(i);
            output.grow().set(p.x, p.y);
        }
        return output;
    }

    public static List<Point2D_F32> convert_I32_F32(List<Point2D_I32> points) {
        return ShapeFittingOps.convert_I32_F32(points, null).toList();
    }

    public static FastQueue<Point2D_F32> convert_I32_F32(List<Point2D_I32> input, FastQueue<Point2D_F32> output) {
        if (output == null) {
            output = new FastQueue<Point2D_F32>(input.size(), Point2D_F32::new);
        } else {
            output.reset();
        }
        for (int i = 0; i < input.size(); ++i) {
            Point2D_I32 p = input.get(i);
            output.grow().set(p.x, p.y);
        }
        return output;
    }

    public static FitData<Circle2D_F64> averageCircle_I32(List<Point2D_I32> points, GrowQueue_F64 optional, FitData<Circle2D_F64> outputStorage) {
        if (outputStorage == null) {
            outputStorage = new FitData<Circle2D_F64>(new Circle2D_F64());
        }
        if (optional == null) {
            optional = new GrowQueue_F64();
        }
        Circle2D_F64 circle = (Circle2D_F64)outputStorage.shape;
        int N = points.size();
        int sumX = 0;
        int sumY = 0;
        for (int i = 0; i < N; ++i) {
            Point2D_I32 p = points.get(i);
            sumX += p.x;
            sumY += p.y;
        }
        optional.reset();
        double centerX = circle.center.x = (double)sumX / (double)N;
        double centerY = circle.center.y = (double)sumY / (double)N;
        double meanR = 0.0;
        for (int i = 0; i < N; ++i) {
            Point2D_I32 p = points.get(i);
            double dx = (double)p.x - centerX;
            double dy = (double)p.y - centerY;
            double r = Math.sqrt(dx * dx + dy * dy);
            optional.push(r);
            meanR += r;
        }
        circle.radius = meanR /= (double)N;
        double variance = 0.0;
        for (int i = 0; i < N; ++i) {
            double diff = optional.get(i) - meanR;
            variance += diff * diff;
        }
        outputStorage.error = variance / (double)N;
        return outputStorage;
    }

    public static FitData<Circle2D_F64> averageCircle_F64(List<Point2D_F64> points, GrowQueue_F64 optional, FitData<Circle2D_F64> outputStorage) {
        if (outputStorage == null) {
            outputStorage = new FitData<Circle2D_F64>(new Circle2D_F64());
        }
        if (optional == null) {
            optional = new GrowQueue_F64();
        }
        Circle2D_F64 circle = (Circle2D_F64)outputStorage.shape;
        int N = points.size();
        double sumX = 0.0;
        double sumY = 0.0;
        for (int i = 0; i < N; ++i) {
            Point2D_F64 p = points.get(i);
            sumX += p.x;
            sumY += p.y;
        }
        optional.reset();
        double centerX = circle.center.x = sumX / (double)N;
        double centerY = circle.center.y = sumY / (double)N;
        double meanR = 0.0;
        for (int i = 0; i < N; ++i) {
            Point2D_F64 p = points.get(i);
            double dx = p.x - centerX;
            double dy = p.y - centerY;
            double r = Math.sqrt(dx * dx + dy * dy);
            optional.push(r);
            meanR += r;
        }
        circle.radius = meanR /= (double)N;
        double variance = 0.0;
        for (int i = 0; i < N; ++i) {
            double diff = optional.get(i) - meanR;
            variance += diff * diff;
        }
        outputStorage.error = variance / (double)N;
        return outputStorage;
    }

    public static void indexToPointIndex(List<Point2D_I32> sequence, GrowQueue_I32 indexes, FastQueue<PointIndex_I32> output) {
        output.reset();
        for (int i = 0; i < indexes.size; ++i) {
            int index = indexes.data[i];
            Point2D_I32 p = sequence.get(index);
            PointIndex_I32 o = output.grow();
            o.x = p.x;
            o.y = p.y;
            o.index = index;
        }
    }
}

