/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3.structure;

import boofcv.alg.sfm.d3.structure.VisOdomBundleAdjustment;
import boofcv.struct.ConfigGridUniform;
import boofcv.struct.ImageGrid;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.struct.FastArray;
import org.ddogleg.struct.FastQueue;

public class SelectTracksInFrameForBundleAdjustment {
    private final Random rand;
    public final ConfigGridUniform configUniform = new ConfigGridUniform();
    public int maxFeaturesPerFrame = 1;
    public int minTrackObservations = 3;
    ImageGrid<Info> grid = new ImageGrid<Info>(Info::new, Info::reset);

    public SelectTracksInFrameForBundleAdjustment(long randSeed) {
        this.rand = new Random(randSeed);
    }

    public void selectTracks(VisOdomBundleAdjustment<?> sba, List<VisOdomBundleAdjustment.BTrack> selected) {
        selected.clear();
        for (int trackIdx = 0; trackIdx < sba.tracks.size; ++trackIdx) {
            ((VisOdomBundleAdjustment.BTrack)sba.tracks.get((int)trackIdx)).selected = false;
        }
        FastQueue<VisOdomBundleAdjustment.BFrame> frames = sba.frames;
        if (frames.size < 1) {
            return;
        }
        if (this.maxFeaturesPerFrame <= 0) {
            for (int trackIdx = 0; trackIdx < sba.tracks.size; ++trackIdx) {
                VisOdomBundleAdjustment.BTrack track = (VisOdomBundleAdjustment.BTrack)sba.tracks.get(trackIdx);
                if (track.observations.size < this.minTrackObservations) continue;
                track.selected = true;
                selected.add(track);
            }
        } else {
            for (int frameIdx = 0; frameIdx < frames.size; ++frameIdx) {
                this.selectTracksInFrame((VisOdomBundleAdjustment.BFrame)frames.get(frameIdx), selected);
            }
        }
    }

    protected void selectTracksInFrame(VisOdomBundleAdjustment.BFrame frame, List<VisOdomBundleAdjustment.BTrack> selected) {
        int imageWidth = frame.camera.original.width;
        int imageHeight = frame.camera.original.height;
        int targetSize = this.configUniform.selectTargetCellSize(this.maxFeaturesPerFrame, imageWidth, imageHeight);
        this.initializeGrid(frame, imageWidth, imageHeight, targetSize);
        this.selectNewTracks(selected);
    }

    void initializeGrid(VisOdomBundleAdjustment.BFrame frame, int imageWidth, int imageHeight, int targetLength) {
        this.grid.initialize(targetLength, imageWidth, imageHeight);
        FastArray<VisOdomBundleAdjustment.BTrack> tracks = frame.tracks;
        for (int trackIdx = 0; trackIdx < tracks.size; ++trackIdx) {
            VisOdomBundleAdjustment.BTrack bt = (VisOdomBundleAdjustment.BTrack)tracks.get(trackIdx);
            VisOdomBundleAdjustment.BObservation o = bt.findObservationBy(frame);
            if (o == null) {
                throw new RuntimeException("BUG! track in frame not observed by frame");
            }
            Info cell = this.grid.getCellAtPixel((int)o.pixel.x, (int)o.pixel.y);
            if (bt.selected) {
                ++cell.alreadySelected;
                continue;
            }
            if (bt.observations.size < this.minTrackObservations) continue;
            cell.unselected.add(bt);
        }
    }

    void selectNewTracks(List<VisOdomBundleAdjustment.BTrack> selected) {
        int before;
        int total = 0;
        do {
            before = total;
            for (int cellIdx = 0; cellIdx < this.grid.cells.size && total < this.maxFeaturesPerFrame; ++cellIdx) {
                Info cell = ((Info[])this.grid.cells.data)[cellIdx];
                if (cell.alreadySelected > 0) {
                    --cell.alreadySelected;
                    ++total;
                    continue;
                }
                if (cell.unselected.isEmpty()) continue;
                int chosen = this.rand.nextInt(cell.unselected.size());
                VisOdomBundleAdjustment.BTrack bt = cell.unselected.remove(chosen);
                bt.selected = true;
                selected.add(bt);
                ++total;
            }
        } while (before != total && total < this.maxFeaturesPerFrame);
    }

    static class Info {
        public int alreadySelected = 0;
        public final List<VisOdomBundleAdjustment.BTrack> unselected = new ArrayList<VisOdomBundleAdjustment.BTrack>();

        Info() {
        }

        public void reset() {
            this.alreadySelected = 0;
            this.unselected.clear();
        }
    }
}

