/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3;

import boofcv.abst.geo.TriangulateNViewsMetric;
import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.sfm.d3.structure.MaxGeoKeyFrameManager;
import boofcv.alg.sfm.d3.structure.VisOdomBundleAdjustment;
import boofcv.alg.sfm.d3.structure.VisOdomKeyFrameManager;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;
import org.ddogleg.struct.VerbosePrint;

public abstract class VisOdomBundlePnPBase<Track extends VisOdomBundleAdjustment.BTrack>
implements VerbosePrint {
    protected int thresholdRetireTracks;
    public int maxKeyFrames = 6;
    public int minObservationsTriangulate = 3;
    public int minObservationsNotVisible = 3;
    protected VisOdomBundleAdjustment<Track> scene;
    protected VisOdomKeyFrameManager frameManager = new MaxGeoKeyFrameManager();
    protected final List<Track> inlierTracks = new ArrayList<Track>();
    protected final List<Track> visibleTracks = new ArrayList<Track>();
    protected final List<Track> initialVisible = new ArrayList<Track>();
    protected final Se3_F64 current_to_previous = new Se3_F64();
    protected final Se3_F64 previous_to_current = new Se3_F64();
    protected final Se3_F64 current_to_world = new Se3_F64();
    protected boolean first = true;
    protected final List<CameraModel> cameraModels = new ArrayList<CameraModel>();
    protected TriangulateNViewsMetric triangulateN;
    protected PrintStream profileOut;
    protected PrintStream verbose;
    protected int totalDroppedTracksBadBundle;
    List<PointTrack> removedBundleTracks = new ArrayList<PointTrack>();
    protected FastQueue<Point2D_F64> observationsNorm = new FastQueue<Point2D_F64>(Point2D_F64::new);
    protected FastQueue<Se3_F64> listOf_world_to_frame = new FastQueue<Se3_F64>(Se3_F64::new);
    protected Point3D_F64 found3D = new Point3D_F64();
    protected Se3_F64 world_to_frame = new Se3_F64();
    protected Point4D_F64 cameraLoc = new Point4D_F64();

    public void reset() {
        if (this.verbose != null) {
            this.verbose.println("VO: reset()");
        }
        this.current_to_world.reset();
        this.current_to_previous.reset();
        this.cameraModels.clear();
        this.scene.reset();
        this.first = true;
    }

    protected void updateListOfVisibleTracksForOutput() {
        for (int i = 0; i < this.initialVisible.size(); ++i) {
            VisOdomBundleAdjustment.BTrack t = (VisOdomBundleAdjustment.BTrack)this.initialVisible.get(i);
            if (t.visualTrack == null) continue;
            this.visibleTracks.add(t);
        }
    }

    protected void triangulateNotSelectedBundleTracks() {
        int minObservationsTriangulate = this.minObservationsTriangulate;
        for (int trackIdx = 0; trackIdx < this.scene.tracks.size; ++trackIdx) {
            VisOdomBundleAdjustment.BTrack bt = ((VisOdomBundleAdjustment.BTrack[])this.scene.tracks.data)[trackIdx];
            if (bt.selected || bt.observations.size < minObservationsTriangulate) continue;
            this.observationsNorm.reset();
            this.listOf_world_to_frame.reset();
            for (int obsIdx = 0; obsIdx < bt.observations.size; ++obsIdx) {
                VisOdomBundleAdjustment.BObservation bo = (VisOdomBundleAdjustment.BObservation)bt.observations.get(obsIdx);
                CameraModel cm = this.cameraModels.get(bo.frame.camera.index);
                cm.pixelToNorm.compute(bo.pixel.x, bo.pixel.y, this.observationsNorm.grow());
                bo.frame.frame_to_world.invert(this.listOf_world_to_frame.grow());
            }
            if (!this.triangulateN.triangulate(this.observationsNorm.toList(), this.listOf_world_to_frame.toList(), this.found3D)) continue;
            bt.worldLoc.x = this.found3D.x;
            bt.worldLoc.y = this.found3D.y;
            bt.worldLoc.z = this.found3D.z;
            bt.worldLoc.w = 1.0;
        }
    }

    protected boolean performKeyFrameMaintenance(PointTracker<?> tracker, int newFrames) {
        GrowQueue_I32 dropFrameIndexes = this.frameManager.selectFramesToDiscard(tracker, this.maxKeyFrames, newFrames, this.scene);
        if (dropFrameIndexes.size == 0) {
            return false;
        }
        boolean droppedCurrentFrame = dropFrameIndexes.getTail(0) == this.scene.frames.size - 1;
        this.dropFramesFromScene(dropFrameIndexes);
        this.dropTracksNotVisibleAndTooFewObservations();
        this.updateListOfVisibleTracksForOutput();
        return droppedCurrentFrame;
    }

    protected void dropFramesFromScene(GrowQueue_I32 dropFrameIndexes) {
        for (int i = dropFrameIndexes.size - 1; i >= 0; --i) {
            VisOdomBundleAdjustment.BFrame frameToDrop = (VisOdomBundleAdjustment.BFrame)this.scene.frames.get(dropFrameIndexes.get(i));
            this.scene.removeFrame(frameToDrop, this.removedBundleTracks);
            for (int removeIdx = 0; removeIdx < this.removedBundleTracks.size(); ++removeIdx) {
                this.dropVisualTrack(this.removedBundleTracks.get(removeIdx));
            }
        }
    }

    protected void dropTracksNotVisibleAndTooFewObservations() {
        int minObservationsNotVisible = this.minObservationsNotVisible;
        for (int tidx = this.scene.tracks.size - 1; tidx >= 0; --tidx) {
            VisOdomBundleAdjustment.BTrack bt = (VisOdomBundleAdjustment.BTrack)this.scene.tracks.get(tidx);
            if (bt.visualTrack != null || bt.observations.size >= minObservationsNotVisible) continue;
            bt.observations.reset();
            this.scene.tracks.removeSwap(tidx);
        }
        for (int fidx = 0; fidx < this.scene.frames.size; ++fidx) {
            VisOdomBundleAdjustment.BFrame bf = (VisOdomBundleAdjustment.BFrame)this.scene.frames.get(fidx);
            for (int tidx = bf.tracks.size - 1; tidx >= 0; --tidx) {
                VisOdomBundleAdjustment.BTrack bt = (VisOdomBundleAdjustment.BTrack)bf.tracks.get(tidx);
                if (bt.observations.size != 0) continue;
                bf.tracks.removeSwap(tidx);
            }
        }
    }

    void dropBadBundleTracks() {
        VisOdomBundleAdjustment.BTrack bt;
        int tidx;
        VisOdomBundleAdjustment.BFrame bf;
        int fidx;
        for (fidx = 0; fidx < this.scene.frames.size; ++fidx) {
            bf = (VisOdomBundleAdjustment.BFrame)this.scene.frames.get(fidx);
            bf.frame_to_world.invert(this.world_to_frame);
            for (tidx = bf.tracks.size - 1; tidx >= 0; --tidx) {
                bt = (VisOdomBundleAdjustment.BTrack)bf.tracks.get(tidx);
                if (bt.observations.size == 0) continue;
                SePointOps_F64.transform(this.world_to_frame, bt.worldLoc, this.cameraLoc);
                if (!(Math.signum(this.cameraLoc.z) * Math.signum(this.cameraLoc.w) < 0.0)) continue;
                bt.observations.reset();
            }
        }
        this.totalDroppedTracksBadBundle = this.scene.tracks.size;
        for (int tidx2 = this.scene.tracks.size - 1; tidx2 >= 0; --tidx2) {
            VisOdomBundleAdjustment.BTrack bt2 = (VisOdomBundleAdjustment.BTrack)this.scene.tracks.get(tidx2);
            if (bt2.observations.size != 0) continue;
            if (bt2.id == -1L) {
                throw new RuntimeException("BUG! Dropping a track that was never initialized");
            }
            this.scene.tracks.removeSwap(tidx2);
        }
        this.totalDroppedTracksBadBundle -= this.scene.tracks.size;
        for (fidx = 0; fidx < this.scene.frames.size; ++fidx) {
            bf = (VisOdomBundleAdjustment.BFrame)this.scene.frames.get(fidx);
            for (tidx = bf.tracks.size - 1; tidx >= 0; --tidx) {
                bt = (VisOdomBundleAdjustment.BTrack)bf.tracks.get(tidx);
                if (bt.observations.size != 0) continue;
                bf.tracks.removeSwap(tidx);
                if (bt.visualTrack == null) continue;
                this.dropVisualTrack(bt.visualTrack);
                bt.visualTrack = null;
            }
        }
    }

    protected abstract void dropVisualTrack(PointTrack var1);

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        if (configuration == null) {
            this.verbose = out;
            return;
        }
        if (configuration.contains("runtime")) {
            this.profileOut = out;
        }
        if (configuration.contains("tracking")) {
            this.verbose = out;
        }
    }

    public Se3_F64 getCurrentToWorld() {
        return this.current_to_world;
    }

    public abstract long getFrameID();

    public int getThresholdRetireTracks() {
        return this.thresholdRetireTracks;
    }

    public void setThresholdRetireTracks(int thresholdRetireTracks) {
        this.thresholdRetireTracks = thresholdRetireTracks;
    }

    public VisOdomBundleAdjustment<Track> getScene() {
        return this.scene;
    }

    public VisOdomKeyFrameManager getFrameManager() {
        return this.frameManager;
    }

    public void setFrameManager(VisOdomKeyFrameManager frameManager) {
        this.frameManager = frameManager;
    }

    public List<Track> getInlierTracks() {
        return this.inlierTracks;
    }

    public List<Track> getVisibleTracks() {
        return this.visibleTracks;
    }

    public List<CameraModel> getCameraModels() {
        return this.cameraModels;
    }

    public TriangulateNViewsMetric getTriangulateN() {
        return this.triangulateN;
    }

    public PrintStream getProfileOut() {
        return this.profileOut;
    }

    public void setProfileOut(PrintStream profileOut) {
        this.profileOut = profileOut;
    }

    public PrintStream getVerbose() {
        return this.verbose;
    }

    protected static class CameraModel {
        protected Point2Transform2_F64 pixelToNorm;
        protected Point2Transform2_F64 normToPixel;

        protected CameraModel() {
        }
    }
}

