/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.ms;

import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.struct.image.GrayS32;
import org.ddogleg.struct.GrowQueue_I32;
import org.ddogleg.struct.Stoppable;

public class RegionMergeTree
implements Stoppable {
    protected GrowQueue_I32 mergeList = new GrowQueue_I32();
    protected GrowQueue_I32 tmpMemberCount = new GrowQueue_I32();
    protected GrowQueue_I32 rootID = new GrowQueue_I32();
    protected boolean stopRequested = false;

    public void initializeMerge(int numRegions) {
        this.mergeList.resize(numRegions);
        for (int i = 0; i < numRegions; ++i) {
            this.mergeList.data[i] = i;
        }
    }

    public void performMerge(GrayS32 pixelToRegion, GrowQueue_I32 regionMemberCount) {
        this.flowIntoRootNode(regionMemberCount);
        this.setToRootNodeNewID(regionMemberCount);
        BinaryImageOps.relabel(pixelToRegion, this.mergeList.data);
    }

    protected void flowIntoRootNode(GrowQueue_I32 regionMemberCount) {
        this.rootID.resize(regionMemberCount.size);
        int count = 0;
        for (int i = 0; i < this.mergeList.size; ++i) {
            int p = this.mergeList.data[i];
            if (p == i) {
                this.rootID.data[i] = count++;
                continue;
            }
            int gp = this.mergeList.data[p];
            while (gp != p) {
                p = gp;
                gp = this.mergeList.data[p];
            }
            int n = p;
            regionMemberCount.data[n] = regionMemberCount.data[n] + regionMemberCount.data[i];
            this.mergeList.data[i] = p;
        }
    }

    protected void setToRootNodeNewID(GrowQueue_I32 regionMemberCount) {
        this.tmpMemberCount.reset();
        for (int i = 0; i < this.mergeList.size; ++i) {
            int p = this.mergeList.data[i];
            if (p == i) {
                this.mergeList.data[i] = this.rootID.data[i];
                this.tmpMemberCount.add(regionMemberCount.data[i]);
                continue;
            }
            this.mergeList.data[i] = this.rootID.data[this.mergeList.data[i]];
        }
        regionMemberCount.reset();
        regionMemberCount.addAll(this.tmpMemberCount);
    }

    protected void markMerge(int regionA, int regionB) {
        int dA = this.mergeList.data[regionA];
        int dB = this.mergeList.data[regionB];
        if (dA == dB) {
            return;
        }
        int rootA = regionA;
        while (dA != rootA) {
            rootA = dA;
            dA = this.mergeList.data[rootA];
        }
        int rootB = regionB;
        while (dB != rootB) {
            rootB = dB;
            dB = this.mergeList.data[rootB];
        }
        this.mergeList.data[regionA] = rootA;
        this.mergeList.data[regionB] = rootA;
        this.mergeList.data[rootB] = rootA;
    }

    @Override
    public void requestStop() {
        this.stopRequested = true;
    }

    @Override
    public boolean isStopRequested() {
        return this.stopRequested;
    }
}

