/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc.impl;

import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.util.PrimitiveArrays;

public class ImplImageBandMath {
    public static void minimum(Planar<GrayU8> input, GrayU8 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayU8[] bands = (GrayU8[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int minimum = Integer.MAX_VALUE;
                for (int i = startBand; i <= lastBand; ++i) {
                    int value = bands[i].data[indexInput] & 0xFF;
                    if (value >= minimum) continue;
                    minimum = value;
                }
                output.data[indexOutput] = (byte)minimum;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void maximum(Planar<GrayU8> input, GrayU8 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayU8[] bands = (GrayU8[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.startIndex + y * input.stride;
            int indexOutput = output.startIndex + y * output.stride;
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int maximum = -2147483647;
                for (int i = startBand; i <= lastBand; ++i) {
                    int value = bands[i].data[indexInput] & 0xFF;
                    if (value <= maximum) continue;
                    maximum = value;
                }
                output.data[indexOutput] = (byte)maximum;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void median(Planar<GrayU8> input, GrayU8 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayU8[] bands = (GrayU8[])input.bands;
        int numBands = lastBand - startBand + 1;
        if (numBands == 1) {
            ImageMiscOps.copy(0, 0, 0, 0, input.getWidth(), input.getHeight(), input.getBand(startBand), output);
            return;
        }
        int middle = numBands / 2;
        boolean isEven = numBands % 2 == 0;
        for (int y = 0; y < h; ++y) {
            int[] valueArray = new int[numBands];
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                for (int i = startBand; i <= lastBand; ++i) {
                    valueArray[i - startBand] = bands[i].data[indexInput] & 0xFF;
                }
                if (isEven) {
                    int val0 = QuickSelect.select(valueArray, middle + 1, numBands);
                    int val1 = PrimitiveArrays.max(valueArray, 0, middle + 1);
                    output.data[indexOutput] = (byte)((val0 + val1) / 2);
                } else {
                    output.data[indexOutput] = (byte)QuickSelect.select(valueArray, middle, numBands);
                }
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void average(Planar<GrayU8> input, GrayU8 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayU8[] bands = (GrayU8[])input.bands;
        int divisor = lastBand - startBand + 1;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int sum = bands[startBand].data[indexInput] & 0xFF;
                for (int i = startBand + 1; i <= lastBand; ++i) {
                    sum += bands[i].data[indexInput] & 0xFF;
                }
                output.data[indexOutput] = (byte)(sum / divisor);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void stdDev(Planar<GrayU8> input, GrayU8 output, GrayU8 avg, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayU8[] bands = (GrayU8[])input.bands;
        int divisor = lastBand - startBand;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int sum = 0;
                for (int i = startBand; i <= lastBand; ++i) {
                    int diff = (bands[i].data[indexInput] & 0xFF) - (avg.data[indexInput] & 0xFF);
                    sum += diff * diff;
                }
                output.data[indexOutput] = (byte)Math.sqrt(sum / divisor);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void minimum(Planar<GrayS16> input, GrayS16 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS16[] bands = (GrayS16[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                short s = Integer.MAX_VALUE;
                for (int i = startBand; i <= lastBand; ++i) {
                    short value = bands[i].data[indexInput];
                    if (value >= s) continue;
                    s = value;
                }
                output.data[indexOutput] = s;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void maximum(Planar<GrayS16> input, GrayS16 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS16[] bands = (GrayS16[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.startIndex + y * input.stride;
            int indexOutput = output.startIndex + y * output.stride;
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                short s = -2147483647;
                for (int i = startBand; i <= lastBand; ++i) {
                    short value = bands[i].data[indexInput];
                    if (value <= s) continue;
                    s = value;
                }
                output.data[indexOutput] = s;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void median(Planar<GrayS16> input, GrayS16 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS16[] bands = (GrayS16[])input.bands;
        int numBands = lastBand - startBand + 1;
        if (numBands == 1) {
            ImageMiscOps.copy(0, 0, 0, 0, input.getWidth(), input.getHeight(), input.getBand(startBand), output);
            return;
        }
        int middle = numBands / 2;
        boolean isEven = numBands % 2 == 0;
        for (int y = 0; y < h; ++y) {
            int[] valueArray = new int[numBands];
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                for (int i = startBand; i <= lastBand; ++i) {
                    valueArray[i - startBand] = bands[i].data[indexInput];
                }
                if (isEven) {
                    int val0 = QuickSelect.select(valueArray, middle, numBands);
                    int val1 = QuickSelect.select(valueArray, middle + 1, numBands);
                    output.data[indexOutput] = (short)((val0 + val1) / 2);
                } else {
                    output.data[indexOutput] = (short)QuickSelect.select(valueArray, middle, numBands);
                }
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void average(Planar<GrayS16> input, GrayS16 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS16[] bands = (GrayS16[])input.bands;
        int divisor = lastBand - startBand + 1;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int sum = bands[startBand].data[indexInput];
                for (int i = startBand + 1; i <= lastBand; ++i) {
                    sum += bands[i].data[indexInput];
                }
                output.data[indexOutput] = (short)(sum / divisor);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void stdDev(Planar<GrayS16> input, GrayS16 output, GrayS16 avg, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS16[] bands = (GrayS16[])input.bands;
        int divisor = lastBand - startBand;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int sum = 0;
                for (int i = startBand; i <= lastBand; ++i) {
                    int diff = bands[i].data[indexInput] - avg.data[indexInput];
                    sum += diff * diff;
                }
                output.data[indexOutput] = (short)Math.sqrt(sum / divisor);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void minimum(Planar<GrayU16> input, GrayU16 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayU16[] bands = (GrayU16[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int minimum = Integer.MAX_VALUE;
                for (int i = startBand; i <= lastBand; ++i) {
                    int value = bands[i].data[indexInput] & 0xFFFF;
                    if (value >= minimum) continue;
                    minimum = value;
                }
                output.data[indexOutput] = (short)minimum;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void maximum(Planar<GrayU16> input, GrayU16 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayU16[] bands = (GrayU16[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.startIndex + y * input.stride;
            int indexOutput = output.startIndex + y * output.stride;
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int maximum = -2147483647;
                for (int i = startBand; i <= lastBand; ++i) {
                    int value = bands[i].data[indexInput] & 0xFFFF;
                    if (value <= maximum) continue;
                    maximum = value;
                }
                output.data[indexOutput] = (short)maximum;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void median(Planar<GrayU16> input, GrayU16 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayU16[] bands = (GrayU16[])input.bands;
        int numBands = lastBand - startBand + 1;
        if (numBands == 1) {
            ImageMiscOps.copy(0, 0, 0, 0, input.getWidth(), input.getHeight(), input.getBand(startBand), output);
            return;
        }
        int middle = numBands / 2;
        boolean isEven = numBands % 2 == 0;
        for (int y = 0; y < h; ++y) {
            int[] valueArray = new int[numBands];
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                for (int i = startBand; i <= lastBand; ++i) {
                    valueArray[i - startBand] = bands[i].data[indexInput] & 0xFFFF;
                }
                if (isEven) {
                    int val0 = QuickSelect.select(valueArray, middle, numBands);
                    int val1 = QuickSelect.select(valueArray, middle + 1, numBands);
                    output.data[indexOutput] = (short)((val0 + val1) / 2);
                } else {
                    output.data[indexOutput] = (short)QuickSelect.select(valueArray, middle, numBands);
                }
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void average(Planar<GrayU16> input, GrayU16 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayU16[] bands = (GrayU16[])input.bands;
        int divisor = lastBand - startBand + 1;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int sum = bands[startBand].data[indexInput] & 0xFFFF;
                for (int i = startBand + 1; i <= lastBand; ++i) {
                    sum += bands[i].data[indexInput] & 0xFFFF;
                }
                output.data[indexOutput] = (short)(sum / divisor);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void stdDev(Planar<GrayU16> input, GrayU16 output, GrayU16 avg, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayU16[] bands = (GrayU16[])input.bands;
        int divisor = lastBand - startBand;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int sum = 0;
                for (int i = startBand; i <= lastBand; ++i) {
                    int diff = (bands[i].data[indexInput] & 0xFFFF) - (avg.data[indexInput] & 0xFFFF);
                    sum += diff * diff;
                }
                output.data[indexOutput] = (short)Math.sqrt(sum / divisor);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void minimum(Planar<GrayS32> input, GrayS32 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS32[] bands = (GrayS32[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int minimum = Integer.MAX_VALUE;
                for (int i = startBand; i <= lastBand; ++i) {
                    int value = bands[i].data[indexInput];
                    if (value >= minimum) continue;
                    minimum = value;
                }
                output.data[indexOutput] = minimum;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void maximum(Planar<GrayS32> input, GrayS32 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS32[] bands = (GrayS32[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.startIndex + y * input.stride;
            int indexOutput = output.startIndex + y * output.stride;
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int maximum = -2147483647;
                for (int i = startBand; i <= lastBand; ++i) {
                    int value = bands[i].data[indexInput];
                    if (value <= maximum) continue;
                    maximum = value;
                }
                output.data[indexOutput] = maximum;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void median(Planar<GrayS32> input, GrayS32 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS32[] bands = (GrayS32[])input.bands;
        int numBands = lastBand - startBand + 1;
        if (numBands == 1) {
            ImageMiscOps.copy(0, 0, 0, 0, input.getWidth(), input.getHeight(), input.getBand(startBand), output);
            return;
        }
        int middle = numBands / 2;
        boolean isEven = numBands % 2 == 0;
        for (int y = 0; y < h; ++y) {
            int[] valueArray = new int[numBands];
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                for (int i = startBand; i <= lastBand; ++i) {
                    valueArray[i - startBand] = bands[i].data[indexInput];
                }
                if (isEven) {
                    int val0 = QuickSelect.select(valueArray, middle, numBands);
                    int val1 = QuickSelect.select(valueArray, middle + 1, numBands);
                    output.data[indexOutput] = (val0 + val1) / 2;
                } else {
                    output.data[indexOutput] = QuickSelect.select(valueArray, middle, numBands);
                }
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void average(Planar<GrayS32> input, GrayS32 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS32[] bands = (GrayS32[])input.bands;
        int divisor = lastBand - startBand + 1;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int sum = bands[startBand].data[indexInput];
                for (int i = startBand + 1; i <= lastBand; ++i) {
                    sum += bands[i].data[indexInput];
                }
                output.data[indexOutput] = sum / divisor;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void stdDev(Planar<GrayS32> input, GrayS32 output, GrayS32 avg, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS32[] bands = (GrayS32[])input.bands;
        int divisor = lastBand - startBand;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int sum = 0;
                for (int i = startBand; i <= lastBand; ++i) {
                    int diff = bands[i].data[indexInput] - avg.data[indexInput];
                    sum += diff * diff;
                }
                output.data[indexOutput] = (int)Math.sqrt(sum / divisor);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void minimum(Planar<GrayS64> input, GrayS64 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS64[] bands = (GrayS64[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                long minimum = Long.MAX_VALUE;
                for (int i = startBand; i <= lastBand; ++i) {
                    long value = bands[i].data[indexInput];
                    if (value >= minimum) continue;
                    minimum = value;
                }
                output.data[indexOutput] = minimum;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void maximum(Planar<GrayS64> input, GrayS64 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS64[] bands = (GrayS64[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.startIndex + y * input.stride;
            int indexOutput = output.startIndex + y * output.stride;
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                long maximum = -9223372036854775807L;
                for (int i = startBand; i <= lastBand; ++i) {
                    long value = bands[i].data[indexInput];
                    if (value <= maximum) continue;
                    maximum = value;
                }
                output.data[indexOutput] = maximum;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void median(Planar<GrayS64> input, GrayS64 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS64[] bands = (GrayS64[])input.bands;
        int numBands = lastBand - startBand + 1;
        if (numBands == 1) {
            ImageMiscOps.copy(0, 0, 0, 0, input.getWidth(), input.getHeight(), input.getBand(startBand), output);
            return;
        }
        int middle = numBands / 2;
        boolean isEven = numBands % 2 == 0;
        for (int y = 0; y < h; ++y) {
            long[] valueArray = new long[numBands];
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                for (int i = startBand; i <= lastBand; ++i) {
                    valueArray[i - startBand] = bands[i].data[indexInput];
                }
                if (isEven) {
                    long val0 = QuickSelect.select(valueArray, middle, numBands);
                    long val1 = QuickSelect.select(valueArray, middle + 1, numBands);
                    output.data[indexOutput] = (val0 + val1) / 2L;
                } else {
                    output.data[indexOutput] = QuickSelect.select(valueArray, middle, numBands);
                }
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void average(Planar<GrayS64> input, GrayS64 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS64[] bands = (GrayS64[])input.bands;
        long divisor = lastBand - startBand + 1;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                long sum = bands[startBand].data[indexInput];
                for (int i = startBand + 1; i <= lastBand; ++i) {
                    sum += bands[i].data[indexInput];
                }
                output.data[indexOutput] = sum / divisor;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void stdDev(Planar<GrayS64> input, GrayS64 output, GrayS64 avg, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS64[] bands = (GrayS64[])input.bands;
        long divisor = lastBand - startBand;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                long sum = 0L;
                for (int i = startBand; i <= lastBand; ++i) {
                    long diff = bands[i].data[indexInput] - avg.data[indexInput];
                    sum += diff * diff;
                }
                output.data[indexOutput] = (long)Math.sqrt(sum / divisor);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void minimum(Planar<GrayF32> input, GrayF32 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayF32[] bands = (GrayF32[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                float minimum = Float.MAX_VALUE;
                for (int i = startBand; i <= lastBand; ++i) {
                    float value = bands[i].data[indexInput];
                    if (!(value < minimum)) continue;
                    minimum = value;
                }
                output.data[indexOutput] = minimum;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void maximum(Planar<GrayF32> input, GrayF32 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayF32[] bands = (GrayF32[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.startIndex + y * input.stride;
            int indexOutput = output.startIndex + y * output.stride;
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                float maximum = -3.4028235E38f;
                for (int i = startBand; i <= lastBand; ++i) {
                    float value = bands[i].data[indexInput];
                    if (!(value > maximum)) continue;
                    maximum = value;
                }
                output.data[indexOutput] = maximum;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void median(Planar<GrayF32> input, GrayF32 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayF32[] bands = (GrayF32[])input.bands;
        int numBands = lastBand - startBand + 1;
        if (numBands == 1) {
            ImageMiscOps.copy(0, 0, 0, 0, input.getWidth(), input.getHeight(), input.getBand(startBand), output);
            return;
        }
        int middle = numBands / 2;
        boolean isEven = numBands % 2 == 0;
        for (int y = 0; y < h; ++y) {
            float[] valueArray = new float[numBands];
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                for (int i = startBand; i <= lastBand; ++i) {
                    valueArray[i - startBand] = bands[i].data[indexInput];
                }
                if (isEven) {
                    float val0 = QuickSelect.select(valueArray, middle, numBands);
                    float val1 = QuickSelect.select(valueArray, middle + 1, numBands);
                    output.data[indexOutput] = (val0 + val1) / 2.0f;
                } else {
                    output.data[indexOutput] = QuickSelect.select(valueArray, middle, numBands);
                }
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void average(Planar<GrayF32> input, GrayF32 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayF32[] bands = (GrayF32[])input.bands;
        float divisor = lastBand - startBand + 1;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                float sum = bands[startBand].data[indexInput];
                for (int i = startBand + 1; i <= lastBand; ++i) {
                    sum += bands[i].data[indexInput];
                }
                output.data[indexOutput] = sum / divisor;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void stdDev(Planar<GrayF32> input, GrayF32 output, GrayF32 avg, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayF32[] bands = (GrayF32[])input.bands;
        float divisor = lastBand - startBand;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                float sum = 0.0f;
                for (int i = startBand; i <= lastBand; ++i) {
                    float diff = bands[i].data[indexInput] - avg.data[indexInput];
                    sum += diff * diff;
                }
                output.data[indexOutput] = (float)Math.sqrt(sum / divisor);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void minimum(Planar<GrayF64> input, GrayF64 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayF64[] bands = (GrayF64[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                double minimum = Double.MAX_VALUE;
                for (int i = startBand; i <= lastBand; ++i) {
                    double value = bands[i].data[indexInput];
                    if (!(value < minimum)) continue;
                    minimum = value;
                }
                output.data[indexOutput] = minimum;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void maximum(Planar<GrayF64> input, GrayF64 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayF64[] bands = (GrayF64[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.startIndex + y * input.stride;
            int indexOutput = output.startIndex + y * output.stride;
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                double maximum = -1.7976931348623157E308;
                for (int i = startBand; i <= lastBand; ++i) {
                    double value = bands[i].data[indexInput];
                    if (!(value > maximum)) continue;
                    maximum = value;
                }
                output.data[indexOutput] = maximum;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void median(Planar<GrayF64> input, GrayF64 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayF64[] bands = (GrayF64[])input.bands;
        int numBands = lastBand - startBand + 1;
        if (numBands == 1) {
            ImageMiscOps.copy(0, 0, 0, 0, input.getWidth(), input.getHeight(), input.getBand(startBand), output);
            return;
        }
        int middle = numBands / 2;
        boolean isEven = numBands % 2 == 0;
        for (int y = 0; y < h; ++y) {
            double[] valueArray = new double[numBands];
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                for (int i = startBand; i <= lastBand; ++i) {
                    valueArray[i - startBand] = bands[i].data[indexInput];
                }
                if (isEven) {
                    double val0 = QuickSelect.select(valueArray, middle, numBands);
                    double val1 = QuickSelect.select(valueArray, middle + 1, numBands);
                    output.data[indexOutput] = (val0 + val1) / 2.0;
                } else {
                    output.data[indexOutput] = QuickSelect.select(valueArray, middle, numBands);
                }
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void average(Planar<GrayF64> input, GrayF64 output, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayF64[] bands = (GrayF64[])input.bands;
        double divisor = lastBand - startBand + 1;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                double sum = bands[startBand].data[indexInput];
                for (int i = startBand + 1; i <= lastBand; ++i) {
                    sum += bands[i].data[indexInput];
                }
                output.data[indexOutput] = sum / divisor;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void stdDev(Planar<GrayF64> input, GrayF64 output, GrayF64 avg, int startBand, int lastBand) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayF64[] bands = (GrayF64[])input.bands;
        double divisor = lastBand - startBand;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                double sum = 0.0;
                for (int i = startBand; i <= lastBand; ++i) {
                    double diff = bands[i].data[indexInput] - avg.data[indexInput];
                    sum += diff * diff;
                }
                output.data[indexOutput] = Math.sqrt(sum / divisor);
                ++indexInput;
                ++indexOutput;
            }
        }
    }
}

