/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.trifocal;

import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.alg.geo.NormalizationPoint2D;
import boofcv.alg.geo.trifocal.EnforceTrifocalGeometry;
import boofcv.alg.geo.trifocal.TrifocalExtractGeometries;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.TrifocalTensor;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.decomposition.svd.SafeSvd_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class TrifocalLinearPoint7 {
    protected TrifocalTensor solutionN = new TrifocalTensor();
    protected NormalizationPoint2D N1 = new NormalizationPoint2D();
    protected NormalizationPoint2D N2 = new NormalizationPoint2D();
    protected NormalizationPoint2D N3 = new NormalizationPoint2D();
    protected DMatrixRMaj A = new DMatrixRMaj(7, 27);
    protected SingularValueDecomposition_F64<DMatrixRMaj> svdNull;
    protected DMatrixRMaj vectorizedSolution = new DMatrixRMaj(27, 1);
    protected Point2D_F64 p1_norm = new Point2D_F64();
    protected Point2D_F64 p2_norm = new Point2D_F64();
    protected Point2D_F64 p3_norm = new Point2D_F64();
    protected EnforceTrifocalGeometry enforce = new EnforceTrifocalGeometry();
    protected TrifocalExtractGeometries extractEpipoles = new TrifocalExtractGeometries();
    protected Point3D_F64 e2 = new Point3D_F64();
    protected Point3D_F64 e3 = new Point3D_F64();

    public TrifocalLinearPoint7() {
        this.svdNull = DecompositionFactory_DDRM.svd(24, 27, false, true, false);
        this.svdNull = new SafeSvd_DDRM(this.svdNull);
    }

    public boolean process(List<AssociatedTriple> observations, TrifocalTensor solution) {
        if (observations.size() < 7) {
            throw new IllegalArgumentException("At least 7 correspondences must be provided. Found " + observations.size());
        }
        LowLevelMultiViewOps.computeNormalization(observations, this.N1, this.N2, this.N3);
        this.createLinearSystem(observations);
        this.solveLinearSystem();
        this.extractEpipoles.setTensor(this.solutionN);
        this.extractEpipoles.extractEpipoles(this.e2, this.e3);
        this.enforce.process(this.e2, this.e3, this.A);
        this.enforce.extractSolution(this.solutionN);
        this.removeNormalization(solution);
        return true;
    }

    protected void createLinearSystem(List<AssociatedTriple> observations) {
        int N = observations.size();
        this.A.reshape(4 * N, 27);
        this.A.zero();
        for (int i = 0; i < N; ++i) {
            AssociatedTriple t = observations.get(i);
            this.N1.apply(t.p1, this.p1_norm);
            this.N2.apply(t.p2, this.p2_norm);
            this.N3.apply(t.p3, this.p3_norm);
            this.insert(i, 0, this.p1_norm.x);
            this.insert(i, 1, this.p1_norm.y);
            this.insert(i, 2, 1.0);
        }
    }

    private void insert(int indexObs, int K, double xk) {
        int start = 108 * indexObs + 9 * K;
        int indexT33 = 8;
        int indexTi3 = 2;
        int indexT3l = 6;
        int indexTil = 0;
        this.A.data[start + indexT33] = xk * this.p2_norm.x * this.p3_norm.x;
        this.A.data[start + indexTi3] = -xk * this.p3_norm.x;
        this.A.data[start + indexT3l] = -xk * this.p2_norm.x;
        this.A.data[start + indexTil] = xk;
        indexT3l = 7;
        indexTil = 1;
        this.A.data[(start += 27) + indexT33] = xk * this.p2_norm.x * this.p3_norm.y;
        this.A.data[start + indexTi3] = -xk * this.p3_norm.y;
        this.A.data[start + indexT3l] = -xk * this.p2_norm.x;
        this.A.data[start + indexTil] = xk;
        indexTi3 = 5;
        indexT3l = 6;
        indexTil = 3;
        this.A.data[(start += 27) + indexT33] = xk * this.p2_norm.y * this.p3_norm.x;
        this.A.data[start + indexTi3] = -xk * this.p3_norm.x;
        this.A.data[start + indexT3l] = -xk * this.p2_norm.y;
        this.A.data[start + indexTil] = xk;
        indexTi3 = 5;
        indexT3l = 7;
        indexTil = 4;
        this.A.data[(start += 27) + indexT33] = xk * this.p2_norm.y * this.p3_norm.y;
        this.A.data[start + indexTi3] = -xk * this.p3_norm.y;
        this.A.data[start + indexT3l] = -xk * this.p2_norm.y;
        this.A.data[start + indexTil] = xk;
    }

    protected boolean solveLinearSystem() {
        if (!this.svdNull.decompose(this.A)) {
            return false;
        }
        SingularOps_DDRM.nullVector(this.svdNull, true, this.vectorizedSolution);
        this.solutionN.convertFrom(this.vectorizedSolution);
        return true;
    }

    protected void removeNormalization(TrifocalTensor solution) {
        DMatrixRMaj N2_inv = this.N2.matrixInv();
        DMatrixRMaj N3_inv = this.N3.matrixInv();
        DMatrixRMaj N1 = this.N1.matrix();
        for (int i = 0; i < 3; ++i) {
            DMatrixRMaj T = solution.getT(i);
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    double sum = 0.0;
                    for (int r = 0; r < 3; ++r) {
                        double n1 = N1.get(r, i);
                        DMatrixRMaj TN = this.solutionN.getT(r);
                        for (int s = 0; s < 3; ++s) {
                            double n2 = N2_inv.get(j, s);
                            for (int t = 0; t < 3; ++t) {
                                sum += n1 * n2 * N3_inv.get(k, t) * TN.get(s, t);
                            }
                        }
                    }
                    T.set(j, k, sum);
                }
            }
        }
    }
}

