/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.triangulate;

import boofcv.alg.geo.PerspectiveOps;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import java.util.List;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ejml.data.DMatrixRMaj;

public class ResidualsTriangulateProjective
implements FunctionNtoM {
    private List<Point2D_F64> observations;
    private List<DMatrixRMaj> cameraMatrices;
    private Point4D_F64 point = new Point4D_F64();
    private Point2D_F64 predicted = new Point2D_F64();

    public void setObservations(List<Point2D_F64> observations, List<DMatrixRMaj> cameraMatrices) {
        if (observations.size() != cameraMatrices.size()) {
            throw new IllegalArgumentException("Different size lists");
        }
        this.observations = observations;
        this.cameraMatrices = cameraMatrices;
    }

    @Override
    public int getNumOfInputsN() {
        return 4;
    }

    @Override
    public int getNumOfOutputsM() {
        return this.observations.size() * 2;
    }

    @Override
    public void process(double[] input, double[] output) {
        this.point.x = input[0];
        this.point.y = input[1];
        this.point.z = input[2];
        this.point.w = input[3];
        int outputIdx = 0;
        for (int i = 0; i < this.observations.size(); ++i) {
            Point2D_F64 p = this.observations.get(i);
            DMatrixRMaj m = this.cameraMatrices.get(i);
            PerspectiveOps.renderPixel(m, this.point, this.predicted);
            output[outputIdx++] = this.predicted.x - p.x;
            output[outputIdx++] = this.predicted.y - p.y;
        }
    }
}

