/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.structure;

import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.SpecializedOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class ProjectiveStructureByFactorization {
    int maxIterations = 10;
    double minimumChangeTol = 1.0E-6;
    DMatrixRMaj depths = new DMatrixRMaj(1, 1);
    DMatrixRMaj pixels = new DMatrixRMaj(1, 1);
    double pixelScale;
    DMatrixRMaj A = new DMatrixRMaj(1, 1);
    DMatrixRMaj B = new DMatrixRMaj(1, 1);
    DMatrixRMaj P = new DMatrixRMaj(1, 4);
    DMatrixRMaj X = new DMatrixRMaj(3, 1);
    SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd(10, 10, true, true, true);
    DMatrixRMaj U = new DMatrixRMaj(1, 1);
    DMatrixRMaj Vt = new DMatrixRMaj(1, 1);

    public void initialize(int numFeatures, int numViews) {
        this.depths.reshape(numViews, numFeatures);
        this.pixels.reshape(numViews * 2, numFeatures);
        this.pixelScale = 0.0;
    }

    public void setPixels(int view, List<Point2D_F64> pixelsInView) {
        if (pixelsInView.size() != this.pixels.numCols) {
            throw new IllegalArgumentException("Pixel count must be constant and match " + this.pixels.numCols);
        }
        int row = view * 2;
        for (int i = 0; i < pixelsInView.size(); ++i) {
            Point2D_F64 p = pixelsInView.get(i);
            this.pixels.set(row, i, p.x);
            this.pixels.set(row + 1, i, p.y);
            this.pixelScale = Math.max(Math.abs(p.x), Math.abs(p.y));
        }
    }

    public void setAllDepths(double value) {
        CommonOps_DDRM.fill(this.depths, value);
    }

    public void setDepths(int view, double[] featureDepths) {
        if (featureDepths.length < this.depths.numCols) {
            throw new IllegalArgumentException("Pixel count must be constant and match " + this.pixels.numCols);
        }
        int N = this.depths.numCols;
        for (int i = 0; i < N; ++i) {
            this.depths.set(view, i, featureDepths[i]);
        }
    }

    public void setDepthsFrom3D(int view, List<Point3D_F64> locations) {
        if (locations.size() != this.pixels.numCols) {
            throw new IllegalArgumentException("Pixel count must be constant and match " + this.pixels.numCols);
        }
        int N = this.depths.numCols;
        for (int i = 0; i < N; ++i) {
            this.depths.set(view, i, locations.get((int)i).z);
        }
    }

    public boolean process() {
        int numViews = this.depths.numRows;
        int numFeatures = this.depths.numCols;
        this.P.reshape(3 * numViews, 4);
        this.X.reshape(4, numFeatures);
        this.A.reshape(numViews * 3, numFeatures);
        this.B.reshape(numViews * 3, numFeatures);
        this.normalizeDepths(this.depths);
        this.assignValuesToA(this.A);
        for (int iter = 0; iter < this.maxIterations; ++iter) {
            if (!this.svd.decompose(this.A)) {
                return false;
            }
            this.svd.getU(this.U, false);
            this.svd.getV(this.Vt, true);
            double[] sv = this.svd.getSingularValues();
            SingularOps_DDRM.descendingOrder(this.U, false, sv, this.A.numCols, this.Vt, true);
            CommonOps_DDRM.extract((DMatrix)this.U, 0, 0, (DMatrix)this.P);
            CommonOps_DDRM.multCols(this.P, sv);
            CommonOps_DDRM.extract((DMatrix)this.Vt, 0, 0, (DMatrix)this.X);
            CommonOps_DDRM.mult(this.P, this.X, this.B);
            double delta = SpecializedOps_DDRM.diffNormF(this.A, this.B) / (double)(this.A.numCols * this.A.numRows);
            DMatrixRMaj tmp = this.A;
            this.A = this.B;
            this.B = tmp;
            if (delta <= this.minimumChangeTol) break;
        }
        return true;
    }

    public void getCameraMatrix(int view, DMatrixRMaj cameraMatrix) {
        cameraMatrix.reshape(3, 4);
        CommonOps_DDRM.extract((DMatrix)this.P, view * 3, 0, (DMatrix)cameraMatrix);
        for (int col = 0; col < 4; ++col) {
            int n = cameraMatrix.getIndex(0, col);
            cameraMatrix.data[n] = cameraMatrix.data[n] * this.pixelScale;
            int n2 = cameraMatrix.getIndex(1, col);
            cameraMatrix.data[n2] = cameraMatrix.data[n2] * this.pixelScale;
        }
    }

    public void getFeature3D(int feature, Point4D_F64 out) {
        out.x = this.X.get(0, feature);
        out.y = this.X.get(1, feature);
        out.z = this.X.get(2, feature);
        out.w = this.X.get(3, feature);
    }

    public void assignValuesToA(DMatrixRMaj A) {
        for (int viewIdx = 0; viewIdx < this.depths.numRows; ++viewIdx) {
            int rowA = viewIdx * 3;
            int rowPixels = viewIdx * 2;
            for (int pointIdx = 0; pointIdx < this.depths.numCols; ++pointIdx) {
                double depth = this.depths.get(viewIdx, pointIdx);
                A.set(rowA, pointIdx, depth * this.pixels.get(rowPixels, pointIdx) / this.pixelScale);
                A.set(rowA + 1, pointIdx, depth * this.pixels.get(rowPixels + 1, pointIdx) / this.pixelScale);
                A.set(rowA + 2, pointIdx, depth);
            }
        }
    }

    public void normalizeDepths(DMatrixRMaj depths) {
        for (int row = 0; row < depths.numRows; ++row) {
            int idx = row * depths.numCols;
            double sum = 0.0;
            for (int col = 0; col < depths.numCols; ++col) {
                double v = depths.data[idx++];
                sum += v * v;
            }
            double norm = Math.sqrt(sum) / (double)depths.numCols;
            idx = row * depths.numCols;
            for (int j = 0; j < depths.numCols; ++j) {
                int n = idx++;
                depths.data[n] = depths.data[n] / norm;
            }
        }
        for (int col = 0; col < depths.numCols; ++col) {
            int row;
            double norm = 0.0;
            for (row = 0; row < depths.numRows; ++row) {
                double v = depths.get(row, col);
                norm += v * v;
            }
            norm = Math.sqrt(norm);
            for (row = 0; row < depths.numRows; ++row) {
                int n = depths.getIndex(row, col);
                depths.data[n] = depths.data[n] / norm;
            }
        }
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public double getMinimumChangeTol() {
        return this.minimumChangeTol;
    }

    public void setMinimumChangeTol(double minimumChangeTol) {
        this.minimumChangeTol = minimumChangeTol;
    }
}

