/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.structure;

import org.ejml.data.DMatrix3;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrix4x4;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.fixed.CommonOps_DDF3;
import org.ejml.dense.fixed.CommonOps_DDF4;

public class DecomposeAbsoluteDualQuadratic {
    DMatrix3x3 k = new DMatrix3x3();
    DMatrix3x3 w = new DMatrix3x3();
    DMatrix3x3 w_inv = new DMatrix3x3();
    DMatrix3 t = new DMatrix3();
    DMatrix3 p = new DMatrix3();

    public boolean decompose(DMatrix4x4 Q) {
        CommonOps_DDF4.scale(1.0 / Q.a33, Q);
        this.k.a11 = Q.a11;
        this.k.a12 = Q.a12;
        this.k.a13 = Q.a13;
        this.k.a21 = Q.a21;
        this.k.a22 = Q.a22;
        this.k.a23 = Q.a23;
        this.k.a31 = Q.a31;
        this.k.a32 = Q.a32;
        this.k.a33 = Q.a33;
        if (!CommonOps_DDF3.invert(this.k, this.w_inv)) {
            return false;
        }
        this.k.set(this.w_inv);
        this.k.a11 = Math.abs(this.k.a11);
        this.k.a22 = Math.abs(this.k.a22);
        this.k.a33 = Math.abs(this.k.a33);
        if (!CommonOps_DDF3.cholU(this.k)) {
            return false;
        }
        if (!CommonOps_DDF3.invert(this.k, this.k)) {
            return false;
        }
        CommonOps_DDF3.divide(this.k, this.k.a33);
        this.t.a1 = Q.a14;
        this.t.a2 = Q.a24;
        this.t.a3 = Q.a34;
        CommonOps_DDF3.mult(this.w_inv, this.t, this.p);
        CommonOps_DDF3.scale(-1.0, this.p);
        CommonOps_DDF3.multTransB(this.k, this.k, this.w);
        return true;
    }

    public void recomputeQ(DMatrix4x4 Q) {
        CommonOps_DDF3.multTransB(this.k, this.k, this.w);
        Q.a11 = this.w.a11;
        Q.a12 = this.w.a12;
        Q.a13 = this.w.a13;
        Q.a21 = this.w.a21;
        Q.a22 = this.w.a22;
        Q.a23 = this.w.a23;
        Q.a31 = this.w.a31;
        Q.a32 = this.w.a32;
        Q.a33 = this.w.a33;
        CommonOps_DDF3.mult(this.w, this.p, this.t);
        CommonOps_DDF3.scale(-1.0, this.t);
        Q.a14 = this.t.a1;
        Q.a24 = this.t.a2;
        Q.a34 = this.t.a3;
        Q.a41 = this.t.a1;
        Q.a42 = this.t.a2;
        Q.a43 = this.t.a3;
        Q.a44 = -CommonOps_DDF3.dot(this.t, this.p);
    }

    public boolean computeRectifyingHomography(DMatrixRMaj H) {
        H.reshape(4, 4);
        H.zero();
        for (int i = 0; i < 3; ++i) {
            for (int j = i; j < 3; ++j) {
                H.set(i, j, this.k.get(i, j));
            }
        }
        H.set(3, 0, -(this.p.a1 * this.k.a11 + this.p.a2 * this.k.a21 + this.p.a3 * this.k.a31));
        H.set(3, 1, -(this.p.a1 * this.k.a12 + this.p.a2 * this.k.a22 + this.p.a3 * this.k.a32));
        H.set(3, 2, -(this.p.a1 * this.k.a13 + this.p.a2 * this.k.a23 + this.p.a3 * this.k.a33));
        H.set(3, 3, 1.0);
        return true;
    }

    public DMatrix3x3 getW() {
        return this.w;
    }

    public DMatrix3x3 getK() {
        return this.k;
    }

    public DMatrix3 getP() {
        return this.p;
    }
}

