/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.alg.geo.DistanceFromModelMultiView;
import boofcv.alg.geo.NormalizedToPixelError;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.transform.homography.HomographyPointOps_F64;
import java.util.List;

public class DistanceHomographyCalibratedSq
implements DistanceFromModelMultiView<Homography2D_F64, AssociatedPair> {
    Homography2D_F64 model;
    private Point2D_F64 expected = new Point2D_F64();
    private NormalizedToPixelError errorCam2 = new NormalizedToPixelError();

    @Override
    public void setModel(Homography2D_F64 model) {
        this.model = model;
    }

    @Override
    public double computeDistance(AssociatedPair pt) {
        HomographyPointOps_F64.transform(this.model, pt.p1, this.expected);
        return this.errorCam2.errorSq(this.expected, pt.p2);
    }

    @Override
    public void computeDistance(List<AssociatedPair> points, double[] distance) {
        for (int i = 0; i < points.size(); ++i) {
            AssociatedPair p = points.get(i);
            HomographyPointOps_F64.transform(this.model, p.p1, this.expected);
            distance[i] = this.errorCam2.errorSq(this.expected, p.p2);
        }
    }

    @Override
    public Class<AssociatedPair> getPointType() {
        return AssociatedPair.class;
    }

    @Override
    public Class<Homography2D_F64> getModelType() {
        return Homography2D_F64.class;
    }

    @Override
    public void setIntrinsic(int view, CameraPinhole intrinsic) {
        if (view == 1) {
            this.errorCam2.set(intrinsic.fx, intrinsic.fy, intrinsic.skew);
        } else if (view != 0) {
            throw new IllegalArgumentException("View must be 0 or 1");
        }
    }

    @Override
    public int getNumberOfViews() {
        return 2;
    }
}

