/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.rectify;

import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import org.ejml.data.DMatrixRMaj;
import org.ejml.simple.SimpleMatrix;

public class RectifyCalibrated {
    DMatrixRMaj rect1 = new DMatrixRMaj(3, 3);
    DMatrixRMaj rect2 = new DMatrixRMaj(3, 3);
    Vector3D_F64 v1 = new Vector3D_F64();
    Vector3D_F64 v2 = new Vector3D_F64();
    Vector3D_F64 v3 = new Vector3D_F64();
    SimpleMatrix K = new SimpleMatrix(3, 3);
    DMatrixRMaj rectifiedR;

    public void process(DMatrixRMaj K1, Se3_F64 worldToCamera1, DMatrixRMaj K2, Se3_F64 worldToCamera2) {
        SimpleMatrix sK1 = SimpleMatrix.wrap(K1);
        SimpleMatrix sK2 = SimpleMatrix.wrap(K2);
        SimpleMatrix R1 = SimpleMatrix.wrap(worldToCamera1.getR());
        SimpleMatrix R2 = SimpleMatrix.wrap(worldToCamera2.getR());
        SimpleMatrix T1 = new SimpleMatrix(3, 1, true, new double[]{worldToCamera1.getT().x, worldToCamera1.getT().y, worldToCamera1.getT().z});
        SimpleMatrix T2 = new SimpleMatrix(3, 1, true, new double[]{worldToCamera2.getT().x, worldToCamera2.getT().y, worldToCamera2.getT().z});
        SimpleMatrix KR1 = sK1.mult(R1);
        SimpleMatrix KR2 = sK2.mult(R2);
        SimpleMatrix c1 = ((SimpleMatrix)R1.transpose()).mult((SimpleMatrix)T1.scale(-1.0));
        SimpleMatrix c2 = ((SimpleMatrix)R2.transpose()).mult((SimpleMatrix)T2.scale(-1.0));
        this.selectAxises(R1, R2, c1, c2);
        SimpleMatrix RR = new SimpleMatrix(3, 3, true, new double[]{this.v1.x, this.v1.y, this.v1.z, this.v2.x, this.v2.y, this.v2.z, this.v3.x, this.v3.y, this.v3.z});
        this.K = (SimpleMatrix)sK1.plus(sK2).scale(0.5);
        this.K.set(0, 1, 0.0);
        SimpleMatrix KRR = this.K.mult(RR);
        this.rect1.set(KRR.mult((SimpleMatrix)KR1.invert()).getDDRM());
        this.rect2.set(KRR.mult((SimpleMatrix)KR2.invert()).getDDRM());
        this.rectifiedR = RR.getDDRM();
    }

    private void selectAxises(SimpleMatrix R1, SimpleMatrix R2, SimpleMatrix c1, SimpleMatrix c2) {
        this.v1.set(c2.get(0) - c1.get(0), c2.get(1) - c1.get(1), c2.get(2) - c1.get(2));
        this.v1.normalize();
        Vector3D_F64 oldZ = new Vector3D_F64(R1.get(2, 0) + R2.get(2, 0), R1.get(2, 1) + R2.get(2, 1), R1.get(2, 2) + R2.get(2, 2));
        GeometryMath_F64.cross(oldZ, (GeoTuple3D_F64)this.v1, (GeoTuple3D_F64)this.v2);
        this.v2.normalize();
        GeometryMath_F64.cross(this.v1, (GeoTuple3D_F64)this.v2, (GeoTuple3D_F64)this.v3);
        this.v3.normalize();
    }

    public DMatrixRMaj getRect1() {
        return this.rect1;
    }

    public DMatrixRMaj getRect2() {
        return this.rect2;
    }

    public DMatrixRMaj getCalibrationMatrix() {
        return this.K.getDDRM();
    }

    public DMatrixRMaj getRectifiedRotation() {
        return this.rectifiedR;
    }
}

