/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.impl;

import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.LensDistortionOps_F32;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.distort.pinhole.PinholePtoN_F32;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.SequencePoint2Transform2_F32;
import boofcv.struct.image.ImageDimension;
import georegression.struct.point.Point2D_F32;
import georegression.struct.shapes.RectangleLength2D_F32;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.simple.SimpleMatrix;

public class ImplRectifyImageOps_F32 {
    public static void fullViewLeft(CameraPinholeBrown paramLeft, FMatrixRMaj rectifyLeft, FMatrixRMaj rectifyRight, FMatrixRMaj rectifyK, ImageDimension rectifiedSize) {
        paramLeft = new CameraPinholeBrown(paramLeft);
        Point2Transform2_F32 tranLeft = ImplRectifyImageOps_F32.transformPixelToRect(paramLeft, rectifyLeft);
        Point2D_F32 work = new Point2D_F32();
        RectangleLength2D_F32 bound = DistortImageOps.boundBox_F32(paramLeft.width, paramLeft.height, new PointToPixelTransform_F32(tranLeft), work);
        float scale = (float)Math.sqrt((float)(paramLeft.width * paramLeft.height) / (bound.width * bound.height));
        rectifiedSize.width = (int)(scale * bound.width + 0.5f);
        rectifiedSize.height = (int)(scale * bound.height + 0.5f);
        ImplRectifyImageOps_F32.adjustCalibrated(rectifyLeft, rectifyRight, rectifyK, bound, scale);
    }

    public static void fullViewLeft(int imageWidth, int imageHeight, FMatrixRMaj rectifyLeft, FMatrixRMaj rectifyRight) {
        PointTransformHomography_F32 tranLeft = new PointTransformHomography_F32(rectifyLeft);
        Point2D_F32 work = new Point2D_F32();
        RectangleLength2D_F32 bound = DistortImageOps.boundBox_F32(imageWidth, imageHeight, new PointToPixelTransform_F32(tranLeft), work);
        float scaleX = (float)imageWidth / bound.width;
        float scaleY = (float)imageHeight / bound.height;
        float scale = Math.min(scaleX, scaleY);
        ImplRectifyImageOps_F32.adjustUncalibrated(rectifyLeft, rectifyRight, bound, scale);
    }

    public static void allInsideLeft(CameraPinholeBrown paramLeft, FMatrixRMaj rectifyLeft, FMatrixRMaj rectifyRight, FMatrixRMaj rectifyK, ImageDimension rectifiedSize) {
        paramLeft = new CameraPinholeBrown(paramLeft);
        Point2Transform2_F32 tranLeft = ImplRectifyImageOps_F32.transformPixelToRect(paramLeft, rectifyLeft);
        Point2D_F32 work = new Point2D_F32();
        RectangleLength2D_F32 bound = LensDistortionOps_F32.boundBoxInside(paramLeft.width, paramLeft.height, new PointToPixelTransform_F32(tranLeft), work);
        LensDistortionOps_F32.roundInside(bound);
        float scale = (float)Math.sqrt((float)(paramLeft.width * paramLeft.height) / (bound.width * bound.height));
        rectifiedSize.width = (int)(scale * bound.width + 0.5f);
        rectifiedSize.height = (int)(scale * bound.height + 0.5f);
        ImplRectifyImageOps_F32.adjustCalibrated(rectifyLeft, rectifyRight, rectifyK, bound, scale);
    }

    public static void allInsideLeft(int imageWidth, int imageHeight, FMatrixRMaj rectifyLeft, FMatrixRMaj rectifyRight) {
        PointTransformHomography_F32 tranLeft = new PointTransformHomography_F32(rectifyLeft);
        Point2D_F32 work = new Point2D_F32();
        RectangleLength2D_F32 bound = LensDistortionOps_F32.boundBoxInside(imageWidth, imageHeight, new PointToPixelTransform_F32(tranLeft), work);
        float scaleX = (float)imageWidth / bound.width;
        float scaleY = (float)imageHeight / bound.height;
        float scale = Math.max(scaleX, scaleY);
        ImplRectifyImageOps_F32.adjustUncalibrated(rectifyLeft, rectifyRight, bound, scale);
    }

    private static void adjustCalibrated(FMatrixRMaj rectifyLeft, FMatrixRMaj rectifyRight, FMatrixRMaj rectifyK, RectangleLength2D_F32 bound, float scale) {
        float deltaX = -bound.x0 * scale;
        float deltaY = -bound.y0 * scale;
        SimpleMatrix A = new SimpleMatrix(3, 3, true, new float[]{scale, 0.0f, deltaX, 0.0f, scale, deltaY, 0.0f, 0.0f, 1.0f});
        SimpleMatrix rL = SimpleMatrix.wrap(rectifyLeft);
        SimpleMatrix rR = SimpleMatrix.wrap(rectifyRight);
        SimpleMatrix K = SimpleMatrix.wrap(rectifyK);
        SimpleMatrix K_inv = (SimpleMatrix)K.invert();
        rL = K_inv.mult(rL);
        rR = K_inv.mult(rR);
        K = A.mult(K);
        rectifyK.set(K.getFDRM());
        rectifyLeft.set(K.mult(rL).getFDRM());
        rectifyRight.set(K.mult(rR).getFDRM());
    }

    private static void adjustUncalibrated(FMatrixRMaj rectifyLeft, FMatrixRMaj rectifyRight, RectangleLength2D_F32 bound, float scale) {
        float deltaX = -bound.x0 * scale;
        float deltaY = -bound.y0 * scale;
        SimpleMatrix A = new SimpleMatrix(3, 3, true, new float[]{scale, 0.0f, deltaX, 0.0f, scale, deltaY, 0.0f, 0.0f, 1.0f});
        SimpleMatrix rL = SimpleMatrix.wrap(rectifyLeft);
        SimpleMatrix rR = SimpleMatrix.wrap(rectifyRight);
        rectifyLeft.set(A.mult(rL).getFDRM());
        rectifyRight.set(A.mult(rR).getFDRM());
    }

    public static Point2Transform2_F32 transformRectToPixel(CameraPinholeBrown param, FMatrixRMaj rectify) {
        Point2Transform2_F32 add_p_to_p = LensDistortionFactory.narrow(param).distort_F32(true, true);
        FMatrixRMaj rectifyInv = new FMatrixRMaj(3, 3);
        CommonOps_FDRM.invert(rectify, rectifyInv);
        PointTransformHomography_F32 removeRect = new PointTransformHomography_F32(rectifyInv);
        return new SequencePoint2Transform2_F32(removeRect, add_p_to_p);
    }

    public static Point2Transform2_F32 transformPixelToRect(CameraPinholeBrown param, FMatrixRMaj rectify) {
        Point2Transform2_F32 remove_p_to_p = LensDistortionFactory.narrow(param).undistort_F32(true, true);
        PointTransformHomography_F32 rectifyDistort = new PointTransformHomography_F32(rectify);
        return new SequencePoint2Transform2_F32(remove_p_to_p, rectifyDistort);
    }

    public static Point2Transform2_F32 transformPixelToRectNorm(CameraPinholeBrown param, FMatrixRMaj rectify, FMatrixRMaj rectifyK) {
        if (rectifyK.get(0, 1) != 0.0f) {
            throw new IllegalArgumentException("Skew should be zero in rectified images");
        }
        Point2Transform2_F32 remove_p_to_p = LensDistortionFactory.narrow(param).undistort_F32(true, true);
        PointTransformHomography_F32 rectifyDistort = new PointTransformHomography_F32(rectify);
        PinholePtoN_F32 pixelToNorm = new PinholePtoN_F32();
        pixelToNorm.set(rectifyK.get(0, 0), rectifyK.get(1, 1), rectifyK.get(0, 1), rectifyK.get(0, 2), rectifyK.get(1, 2));
        return new SequencePoint2Transform2_F32(remove_p_to_p, rectifyDistort, pixelToNorm);
    }
}

