/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.impl;

import boofcv.alg.distort.pinhole.PinholeNtoP_F64;
import boofcv.alg.distort.pinhole.PinholePtoN_F64;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import javax.annotation.Nullable;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.fixed.CommonOps_DDF3;
import org.ejml.dense.row.CommonOps_DDRM;

public class ImplPerspectiveOps_F64 {
    public static <C extends CameraPinhole> C adjustIntrinsic(C parameters, DMatrixRMaj adjustMatrix, C adjustedParam) {
        if (adjustedParam == null) {
            adjustedParam = (CameraPinhole)parameters.createLike();
        }
        adjustedParam.set(parameters);
        DMatrixRMaj K = ImplPerspectiveOps_F64.pinholeToMatrix(parameters, (DMatrixRMaj)null);
        DMatrixRMaj K_adj = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.mult(adjustMatrix, K, K_adj);
        ImplPerspectiveOps_F64.matrixToPinhole(K_adj, parameters.width, parameters.height, adjustedParam);
        return adjustedParam;
    }

    public static DMatrixRMaj pinholeToMatrix(double fx, double fy, double skew, double cx, double cy, @Nullable DMatrixRMaj K) {
        if (K == null) {
            K = new DMatrixRMaj(3, 3);
        } else {
            K.reshape(3, 3);
        }
        CommonOps_DDRM.fill(K, 0.0);
        K.data[0] = fx;
        K.data[1] = skew;
        K.data[2] = cx;
        K.data[4] = fy;
        K.data[5] = cy;
        K.data[8] = 1.0;
        return K;
    }

    public static DMatrixRMaj pinholeToMatrix(CameraPinhole param, @Nullable DMatrixRMaj K) {
        return ImplPerspectiveOps_F64.pinholeToMatrix(param.fx, param.fy, param.skew, param.cx, param.cy, K);
    }

    public static DMatrix3x3 pinholeToMatrix(CameraPinhole param, DMatrix3x3 K) {
        if (K == null) {
            K = new DMatrix3x3();
        } else {
            CommonOps_DDF3.fill(K, 0.0);
        }
        K.a11 = param.fx;
        K.a12 = param.skew;
        K.a13 = param.cx;
        K.a22 = param.fy;
        K.a23 = param.cy;
        K.a33 = 1.0;
        return K;
    }

    public static CameraPinhole matrixToPinhole(DMatrixRMaj K, int width, int height, CameraPinhole output) {
        if (output == null) {
            output = new CameraPinhole();
        }
        output.fx = K.get(0, 0);
        output.fy = K.get(1, 1);
        output.skew = K.get(0, 1);
        output.cx = K.get(0, 2);
        output.cy = K.get(1, 2);
        output.width = width;
        output.height = height;
        return output;
    }

    public static Point2D_F64 convertNormToPixel(CameraModel param, double x, double y, Point2D_F64 pixel) {
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        Point2Transform2_F64 normToPixel = LensDistortionFactory.narrow(param).distort_F64(false, true);
        normToPixel.compute(x, y, pixel);
        return pixel;
    }

    public static Point2D_F64 convertNormToPixel(DMatrixRMaj K, Point2D_F64 norm, Point2D_F64 pixel) {
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        PinholeNtoP_F64 alg = new PinholeNtoP_F64();
        alg.set(K.get(0, 0), K.get(1, 1), K.get(0, 1), K.get(0, 2), K.get(1, 2));
        alg.compute(norm.x, norm.y, pixel);
        return pixel;
    }

    public static Point2D_F64 convertPixelToNorm(CameraModel param, Point2D_F64 pixel, Point2D_F64 norm) {
        if (norm == null) {
            norm = new Point2D_F64();
        }
        Point2Transform2_F64 pixelToNorm = LensDistortionFactory.narrow(param).undistort_F64(true, false);
        pixelToNorm.compute(pixel.x, pixel.y, norm);
        return norm;
    }

    public static Point2D_F64 convertPixelToNorm(DMatrixRMaj K, Point2D_F64 pixel, Point2D_F64 norm) {
        if (norm == null) {
            norm = new Point2D_F64();
        }
        PinholePtoN_F64 alg = new PinholePtoN_F64();
        alg.set(K.get(0, 0), K.get(1, 1), K.get(0, 1), K.get(0, 2), K.get(1, 2));
        alg.compute(pixel.x, pixel.y, norm);
        return norm;
    }

    public static Point2D_F64 convertPixelToNorm(CameraPinhole intrinsic, double pixelX, double pixelY, Point2D_F64 norm) {
        if (norm == null) {
            norm = new Point2D_F64();
        }
        double a11 = 1.0 / intrinsic.fx;
        double a12 = -intrinsic.skew / (intrinsic.fx * intrinsic.fy);
        double a13 = (intrinsic.skew * intrinsic.cy - intrinsic.cx * intrinsic.fy) / (intrinsic.fx * intrinsic.fy);
        double a22 = 1.0 / intrinsic.fy;
        double a23 = -intrinsic.cy / intrinsic.fy;
        norm.x = a11 * pixelX + a12 * pixelY + a13;
        norm.y = a22 * pixelY + a23;
        return norm;
    }

    public static Point2D_F64 renderPixel(Se3_F64 worldToCamera, DMatrixRMaj K, Point3D_F64 X2, @Nullable Point2D_F64 pixel) {
        Point3D_F64 X_cam = new Point3D_F64();
        SePointOps_F64.transform(worldToCamera, X2, X_cam);
        if (X_cam.z <= 0.0) {
            return null;
        }
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        pixel.set(X_cam.x / X_cam.z, X_cam.y / X_cam.z);
        if (K == null) {
            return pixel;
        }
        return GeometryMath_F64.mult(K, pixel, pixel);
    }

    public static Point2D_F64 renderPixel(Se3_F64 worldToCamera, double fx, double skew, double cx, double fy, double cy, Point3D_F64 X2, @Nullable Point2D_F64 pixel) {
        Point3D_F64 X_cam = new Point3D_F64();
        SePointOps_F64.transform(worldToCamera, X2, X_cam);
        if (X_cam.z <= 0.0) {
            return null;
        }
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        double xx = X_cam.x / X_cam.z;
        double yy = X_cam.y / X_cam.z;
        pixel.x = fx * xx + skew * yy + cx;
        pixel.y = fy * yy + cy;
        return pixel;
    }

    public static void renderPixel(DMatrixRMaj worldToCamera, Point3D_F64 X2, Point3D_F64 pixelH) {
        DMatrixRMaj P = worldToCamera;
        pixelH.x = P.data[0] * X2.x + P.data[1] * X2.y + P.data[2] * X2.z + P.data[3];
        pixelH.y = P.data[4] * X2.x + P.data[5] * X2.y + P.data[6] * X2.z + P.data[7];
        pixelH.z = P.data[8] * X2.x + P.data[9] * X2.y + P.data[10] * X2.z + P.data[11];
    }

    public static void renderPixel(DMatrixRMaj worldToCamera, Point3D_F64 X2, Point2D_F64 pixel) {
        DMatrixRMaj P = worldToCamera;
        double x = P.data[0] * X2.x + P.data[1] * X2.y + P.data[2] * X2.z + P.data[3];
        double y = P.data[4] * X2.x + P.data[5] * X2.y + P.data[6] * X2.z + P.data[7];
        double z = P.data[8] * X2.x + P.data[9] * X2.y + P.data[10] * X2.z + P.data[11];
        pixel.x = x / z;
        pixel.y = y / z;
    }

    public static void renderPixel(DMatrixRMaj cameraMatrix, Point4D_F64 X2, @Nullable Point3D_F64 pixelH) {
        DMatrixRMaj P = cameraMatrix;
        pixelH.x = P.data[0] * X2.x + P.data[1] * X2.y + P.data[2] * X2.z + P.data[3] * X2.w;
        pixelH.y = P.data[4] * X2.x + P.data[5] * X2.y + P.data[6] * X2.z + P.data[7] * X2.w;
        pixelH.z = P.data[8] * X2.x + P.data[9] * X2.y + P.data[10] * X2.z + P.data[11] * X2.w;
    }

    public static void renderPixel(DMatrixRMaj cameraMatrix, Point4D_F64 X2, @Nullable Point2D_F64 pixel) {
        DMatrixRMaj P = cameraMatrix;
        double x = P.data[0] * X2.x + P.data[1] * X2.y + P.data[2] * X2.z + P.data[3] * X2.w;
        double y = P.data[4] * X2.x + P.data[5] * X2.y + P.data[6] * X2.z + P.data[7] * X2.w;
        double z = P.data[8] * X2.x + P.data[9] * X2.y + P.data[10] * X2.z + P.data[11] * X2.w;
        pixel.x = x / z;
        pixel.y = y / z;
    }

    public static DMatrixRMaj createCameraMatrix(DMatrixRMaj R, Vector3D_F64 T, @Nullable DMatrixRMaj K, @Nullable DMatrixRMaj ret) {
        if (ret == null) {
            ret = new DMatrixRMaj(3, 4);
        }
        CommonOps_DDRM.insert(R, ret, 0, 0);
        ret.data[3] = T.x;
        ret.data[7] = T.y;
        ret.data[11] = T.z;
        if (K == null) {
            return ret;
        }
        DMatrixRMaj temp = new DMatrixRMaj(3, 4);
        CommonOps_DDRM.mult(K, ret, temp);
        ret.set(temp);
        return ret;
    }
}

