/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.h;

import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.alg.geo.NormalizationPoint2D;
import boofcv.alg.geo.h.HomographyDirectLinearTransform;
import boofcv.struct.geo.AssociatedPair;
import java.util.List;
import org.ejml.data.DMatrix2x2;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.fixed.CommonOps_DDF2;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_DDRM;
import org.ejml.interfaces.SolveNullSpace;

public class HomographyTotalLeastSquares {
    SolveNullSpace<DMatrixRMaj> solverNull = new SolveNullSpaceSvd_DDRM();
    DMatrixRMaj nullspace = new DMatrixRMaj(3, 1);
    protected NormalizationPoint2D N1 = new NormalizationPoint2D();
    protected NormalizationPoint2D N2 = new NormalizationPoint2D();
    DMatrixRMaj X1 = new DMatrixRMaj(1, 1);
    DMatrixRMaj X2 = new DMatrixRMaj(1, 1);
    DMatrixRMaj A = new DMatrixRMaj(1, 1);
    private DMatrixRMaj P_plus = new DMatrixRMaj(1, 1);
    private double[] XP_bar = new double[4];

    public boolean process(List<AssociatedPair> points, DMatrixRMaj foundH) {
        if (points.size() < 4) {
            throw new IllegalArgumentException("Must be at least 4 points.");
        }
        LowLevelMultiViewOps.computeNormalization(points, this.N1, this.N2);
        LowLevelMultiViewOps.applyNormalization(points, this.N1, this.N2, this.X1, this.X2);
        this.constructA678();
        if (!this.solverNull.process(this.A, 1, this.nullspace)) {
            return false;
        }
        DMatrixRMaj H = foundH;
        H.data[6] = this.nullspace.data[0];
        H.data[7] = this.nullspace.data[1];
        H.data[8] = this.nullspace.data[2];
        H.data[2] = -(this.XP_bar[0] * H.data[6] + this.XP_bar[1] * H.data[7]);
        H.data[5] = -(this.XP_bar[2] * H.data[6] + this.XP_bar[3] * H.data[7]);
        HomographyTotalLeastSquares.backsubstitution0134(this.P_plus, this.X1, this.X2, H.data);
        HomographyDirectLinearTransform.undoNormalizationH(foundH, this.N1, this.N2);
        CommonOps_DDRM.scale(1.0 / foundH.get(2, 2), foundH);
        return true;
    }

    static void backsubstitution0134(DMatrixRMaj P_plus, DMatrixRMaj P, DMatrixRMaj X2, double[] H) {
        int N = P.numRows;
        DMatrixRMaj tmp = new DMatrixRMaj(N * 2, 1);
        double H6 = H[6];
        double H7 = H[7];
        double H8 = H[8];
        int index = 0;
        for (int i = 0; i < N; ++i) {
            double x = -X2.data[index];
            double y = -X2.data[index + 1];
            double sum = P.data[index++] * H6 + P.data[index++] * H7 + H8;
            tmp.data[i] = x * sum;
            tmp.data[i + N] = y * sum;
        }
        double h0 = 0.0;
        double h1 = 0.0;
        double h3 = 0.0;
        double h4 = 0.0;
        for (int i = 0; i < N; ++i) {
            double P_pls_0 = P_plus.data[i];
            double P_pls_1 = P_plus.data[i + N];
            double tmp_i = tmp.data[i];
            double tmp_j = tmp.data[i + N];
            h0 += P_pls_0 * tmp_i;
            h1 += P_pls_1 * tmp_i;
            h3 += P_pls_0 * tmp_j;
            h4 += P_pls_1 * tmp_j;
        }
        H[0] = -h0;
        H[1] = -h1;
        H[3] = -h3;
        H[4] = -h4;
    }

    void constructA678() {
        double P_hat_y;
        double P_hat_x;
        double x;
        int N = this.X1.numRows;
        HomographyTotalLeastSquares.computePseudo(this.X1, this.P_plus);
        DMatrixRMaj PPpXP = new DMatrixRMaj(1, 1);
        DMatrixRMaj PPpYP = new DMatrixRMaj(1, 1);
        HomographyTotalLeastSquares.computePPXP(this.X1, this.P_plus, this.X2, 0, PPpXP);
        HomographyTotalLeastSquares.computePPXP(this.X1, this.P_plus, this.X2, 1, PPpYP);
        DMatrixRMaj PPpX = new DMatrixRMaj(1, 1);
        DMatrixRMaj PPpY = new DMatrixRMaj(1, 1);
        HomographyTotalLeastSquares.computePPpX(this.X1, this.P_plus, this.X2, 0, PPpX);
        HomographyTotalLeastSquares.computePPpX(this.X1, this.P_plus, this.X2, 1, PPpY);
        HomographyTotalLeastSquares.computeEq20(this.X2, this.X1, this.XP_bar);
        this.A.reshape(N * 2, 3);
        double XP_bar_x = this.XP_bar[0];
        double XP_bar_y = this.XP_bar[1];
        double YP_bar_x = this.XP_bar[2];
        double YP_bar_y = this.XP_bar[3];
        int i = 0;
        int index = 0;
        int indexA = 0;
        while (i < N) {
            x = -this.X2.data[i * 2];
            P_hat_x = this.X1.data[index];
            P_hat_y = this.X1.data[index + 1];
            this.A.data[indexA++] = x * P_hat_x - XP_bar_x - PPpXP.data[index];
            this.A.data[indexA++] = x * P_hat_y - XP_bar_y - PPpXP.data[index + 1];
            this.A.data[indexA++] = x - PPpX.data[i];
            ++i;
            index += 2;
        }
        i = 0;
        index = 0;
        indexA = N * 3;
        while (i < N) {
            x = -this.X2.data[i * 2 + 1];
            P_hat_x = this.X1.data[index];
            P_hat_y = this.X1.data[index + 1];
            this.A.data[indexA++] = x * P_hat_x - YP_bar_x - PPpYP.data[index];
            this.A.data[indexA++] = x * P_hat_y - YP_bar_y - PPpYP.data[index + 1];
            this.A.data[indexA++] = x - PPpY.data[i];
            ++i;
            index += 2;
        }
    }

    static void computeEq20(DMatrixRMaj X2, DMatrixRMaj P, double[] output) {
        int N = X2.numRows;
        double a00 = 0.0;
        double a01 = 0.0;
        double a10 = 0.0;
        double a11 = 0.0;
        int i = 0;
        int index = 0;
        while (i < N) {
            double x1 = X2.data[index];
            double x2 = X2.data[index + 1];
            double p1 = P.data[index];
            double p2 = P.data[index + 1];
            a00 += x1 * p1;
            a01 += x1 * p2;
            a10 += x2 * p1;
            a11 += x2 * p2;
            ++i;
            index += 2;
        }
        output[0] = -a00 / (double)N;
        output[1] = -a01 / (double)N;
        output[2] = -a10 / (double)N;
        output[3] = -a11 / (double)N;
    }

    static void computePseudo(DMatrixRMaj A, DMatrixRMaj output) {
        int i;
        int N = A.numRows;
        DMatrix2x2 m = new DMatrix2x2();
        DMatrix2x2 m_inv = new DMatrix2x2();
        int index = 0;
        for (i = 0; i < N; ++i) {
            double a_i1 = A.data[index++];
            double a_i2 = A.data[index++];
            m.a11 += a_i1 * a_i1;
            m.a12 += a_i1 * a_i2;
            m.a22 += a_i2 * a_i2;
        }
        m.a21 = m.a12;
        CommonOps_DDF2.invert(m, m_inv);
        output.reshape(2, N);
        index = 0;
        for (i = 0; i < N; ++i) {
            output.data[i] = A.data[index++] * m_inv.a11 + A.data[index++] * m_inv.a12;
        }
        int end = 2 * N;
        int A_index = 0;
        for (int i2 = N; i2 < end; ++i2) {
            output.data[i2] = A.data[A_index++] * m_inv.a21 + A.data[A_index++] * m_inv.a22;
        }
    }

    static void computePPXP(DMatrixRMaj P, DMatrixRMaj P_plus, DMatrixRMaj X2, int offsetX, DMatrixRMaj output) {
        int N = P.numRows;
        output.reshape(N, 2);
        int i = 0;
        int index = 0;
        while (i < N) {
            double x = -X2.data[index + offsetX];
            output.data[index] = x * P.data[index];
            output.data[index + 1] = x * P.data[index + 1];
            ++i;
            index += 2;
        }
        double a00 = 0.0;
        double a01 = 0.0;
        double a10 = 0.0;
        double a11 = 0.0;
        int i2 = 0;
        int index2 = 0;
        while (i2 < N) {
            a00 += P_plus.data[i2] * output.data[index2];
            a01 += P_plus.data[i2] * output.data[index2 + 1];
            a10 += P_plus.data[i2 + N] * output.data[index2];
            a11 += P_plus.data[i2 + N] * output.data[index2 + 1];
            ++i2;
            index2 += 2;
        }
        i2 = 0;
        index2 = 0;
        while (i2 < N) {
            output.data[index2] = P.data[index2] * a00 + P.data[index2 + 1] * a10;
            output.data[index2 + 1] = P.data[index2] * a01 + P.data[index2 + 1] * a11;
            ++i2;
            index2 += 2;
        }
    }

    static void computePPpX(DMatrixRMaj P, DMatrixRMaj P_plus, DMatrixRMaj X2, int offsetX, DMatrixRMaj output) {
        int N = P.numRows;
        output.reshape(N, 1);
        double a00 = 0.0;
        double a10 = 0.0;
        int i = 0;
        int indexX = offsetX;
        while (i < N) {
            double x = -X2.data[indexX];
            a00 += x * P_plus.data[i];
            a10 += x * P_plus.data[i + N];
            ++i;
            indexX += 2;
        }
        int indexP = 0;
        for (i = 0; i < N; ++i) {
            output.data[i] = a00 * P.data[indexP++] + a10 * P.data[indexP++];
        }
    }
}

