/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.f.FundamentalExtractEpipoles;
import boofcv.alg.geo.impl.ProjectiveToIdentity;
import boofcv.misc.ConfigConverge;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.GeoTuple4D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.point.Vector4D_F64;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.derivative.NumericalJacobianForward_DDRM;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;

public class FundamentalToProjective {
    private DMatrixRMaj outer = new DMatrixRMaj(3, 3);
    private DMatrixRMaj KR = new DMatrixRMaj(3, 3);
    FundamentalExtractEpipoles alg = new FundamentalExtractEpipoles();
    Point3D_F64 e1 = new Point3D_F64();
    Point3D_F64 e2 = new Point3D_F64();
    Vector3D_F64 zero = new Vector3D_F64();
    ProjectiveToIdentity p2i = new ProjectiveToIdentity();
    ConfigConverge convergence = new ConfigConverge(1.0E-8, 1.0E-8, 25);
    UnconstrainedLeastSquares<DMatrixRMaj> optimizer = FactoryOptimization.levenbergMarquardt(null, true);
    FundamentalResidual residual = new FundamentalResidual();
    NumericalJacobianForward_DDRM jacobian = new NumericalJacobianForward_DDRM(this.residual);
    private double[] initialV = new double[3];

    public void twoView(DMatrixRMaj F, DMatrixRMaj cameraMatrix) {
        this.alg.process(F, this.e1, this.e2);
        this.twoView(F, this.e2, this.zero, 1.0, cameraMatrix);
    }

    public void twoView(DMatrixRMaj F, Point3D_F64 e2, Vector3D_F64 v, double lambda, DMatrixRMaj cameraMatrix) {
        GeometryMath_F64.outerProd(e2, v, this.outer);
        GeometryMath_F64.multCrossA(e2, F, this.KR);
        CommonOps_DDRM.add((DMatrixD1)this.KR, this.outer, (DMatrixD1)this.KR);
        CommonOps_DDRM.insert(this.KR, cameraMatrix, 0, 0);
        cameraMatrix.set(0, 3, lambda * e2.x);
        cameraMatrix.set(1, 3, lambda * e2.y);
        cameraMatrix.set(2, 3, lambda * e2.z);
    }

    public boolean threeView(DMatrixRMaj F21, DMatrixRMaj F31, DMatrixRMaj F322, DMatrixRMaj P2, DMatrixRMaj P3) {
        Point3D_F64 e21 = this.e1;
        Point3D_F64 e31 = this.e2;
        this.alg.process(F21, null, e21);
        this.twoView(F21, e21, this.zero, 1.0, P2);
        this.alg.process(F31, null, e31);
        if (!this.p2i.process(P2)) {
            return false;
        }
        this.residual.setF31(F31, e31);
        this.residual.setF32(F322);
        this.residual.setH(this.p2i.getPseudoInvP(), this.p2i.getU());
        this.optimizer.setFunction(this.residual, this.jacobian);
        this.optimizer.initialize(this.initialV, this.convergence.ftol, this.convergence.gtol);
        for (int i = 0; i < this.convergence.maxIterations && !this.optimizer.iterate(); ++i) {
        }
        P3.set(this.residual.computeP3(this.optimizer.getParameters()));
        return true;
    }

    public double getThreeViewError() {
        return this.optimizer.getFunctionValue();
    }

    public ConfigConverge getConvergence() {
        return this.convergence;
    }

    class FundamentalResidual
    implements FunctionNtoM {
        DMatrixRMaj F32 = new DMatrixRMaj(3, 3);
        DMatrixRMaj F32_est = new DMatrixRMaj(3, 3);
        DMatrixRMaj P3 = new DMatrixRMaj(3, 4);
        DMatrixRMaj P2inv;
        Vector4D_F64 u = new Vector4D_F64();
        DMatrixRMaj F31;
        Point3D_F64 T31;
        DMatrixRMaj R = new DMatrixRMaj(3, 3);
        Vector3D_F64 a = new Vector3D_F64();
        Vector3D_F64 v = new Vector3D_F64();

        FundamentalResidual() {
        }

        @Override
        public void process(double[] input, double[] output) {
            this.computeP3(input);
            CommonOps_DDRM.mult(this.P3, this.P2inv, this.R);
            GeometryMath_F64.mult(this.P3, (GeoTuple4D_F64)this.u, (GeoTuple3D_F64)this.a);
            GeometryMath_F64.multCrossA(this.a, this.R, this.F32_est);
            double n = NormOps_DDRM.normF(this.F32_est);
            CommonOps_DDRM.scale(1.0 / n, this.F32_est);
            for (int i = 0; i < 9; ++i) {
                output[i] = this.F32_est.data[i] - this.F32.data[i];
            }
        }

        @Override
        public int getNumOfInputsN() {
            return 3;
        }

        @Override
        public int getNumOfOutputsM() {
            return 9;
        }

        public DMatrixRMaj computeP3(double[] input) {
            this.v.x = input[0];
            this.v.y = input[1];
            this.v.z = input[2];
            FundamentalToProjective.this.twoView(this.F31, this.T31, this.v, 1.0, this.P3);
            return this.P3;
        }

        public void setF31(DMatrixRMaj F31, Point3D_F64 T31) {
            this.F31 = F31;
            this.T31 = T31;
        }

        public void setF32(DMatrixRMaj F322) {
            this.F32.set(F322);
            double n = NormOps_DDRM.normF(this.F32);
            CommonOps_DDRM.scale(1.0 / n, this.F32);
        }

        public void setH(DMatrixRMaj P2inv, DMatrixRMaj u) {
            this.P2inv = P2inv;
            this.u.x = u.data[0];
            this.u.y = u.data[1];
            this.u.z = u.data[2];
            this.u.w = u.data[3];
        }
    }
}

