/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.NormalizationPoint2D;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_DDRM;
import org.ejml.interfaces.SolveNullSpace;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public abstract class FundamentalLinear {
    protected DMatrixRMaj A = new DMatrixRMaj(1, 9);
    protected SolveNullSpace<DMatrixRMaj> solverNull = new SolveNullSpaceSvd_DDRM();
    protected SingularValueDecomposition_F64<DMatrixRMaj> svdConstraints = DecompositionFactory_DDRM.svd(3, 3, true, true, false);
    protected DMatrixRMaj svdU;
    protected DMatrixRMaj svdS;
    protected DMatrixRMaj svdV;
    protected DMatrixRMaj temp0 = new DMatrixRMaj(3, 3);
    protected NormalizationPoint2D N1 = new NormalizationPoint2D();
    protected NormalizationPoint2D N2 = new NormalizationPoint2D();
    boolean computeFundamental;

    public FundamentalLinear(boolean computeFundamental) {
        this.computeFundamental = computeFundamental;
    }

    protected boolean projectOntoEssential(DMatrixRMaj E) {
        if (!this.svdConstraints.decompose(E)) {
            return false;
        }
        this.svdV = this.svdConstraints.getV(this.svdV, false);
        this.svdU = this.svdConstraints.getU(this.svdU, false);
        this.svdS = this.svdConstraints.getW(this.svdS);
        SingularOps_DDRM.descendingOrder(this.svdU, false, this.svdS, this.svdV, false);
        this.svdS.unsafe_set(0, 0, 1.0);
        this.svdS.unsafe_set(1, 1, 1.0);
        this.svdS.unsafe_set(2, 2, 0.0);
        CommonOps_DDRM.mult(this.svdU, this.svdS, this.temp0);
        CommonOps_DDRM.multTransB(this.temp0, this.svdV, E);
        return true;
    }

    protected boolean projectOntoFundamentalSpace(DMatrixRMaj F) {
        if (!this.svdConstraints.decompose(F)) {
            return false;
        }
        this.svdV = this.svdConstraints.getV(this.svdV, false);
        this.svdU = this.svdConstraints.getU(this.svdU, false);
        this.svdS = this.svdConstraints.getW(this.svdS);
        SingularOps_DDRM.descendingOrder(this.svdU, false, this.svdS, this.svdV, false);
        this.svdS.set(2, 2, 0.0);
        CommonOps_DDRM.mult(this.svdU, this.svdS, this.temp0);
        CommonOps_DDRM.multTransB(this.temp0, this.svdV, F);
        return true;
    }

    protected void createA(List<AssociatedPair> points, DMatrixRMaj A) {
        A.reshape(points.size(), 9, false);
        A.zero();
        Point2D_F64 f_norm = new Point2D_F64();
        Point2D_F64 s_norm = new Point2D_F64();
        int size = points.size();
        for (int i = 0; i < size; ++i) {
            AssociatedPair p = points.get(i);
            Point2D_F64 f = p.p1;
            Point2D_F64 s = p.p2;
            this.N1.apply(f, f_norm);
            this.N2.apply(s, s_norm);
            A.unsafe_set(i, 0, s_norm.x * f_norm.x);
            A.unsafe_set(i, 1, s_norm.x * f_norm.y);
            A.unsafe_set(i, 2, s_norm.x);
            A.unsafe_set(i, 3, s_norm.y * f_norm.x);
            A.unsafe_set(i, 4, s_norm.y * f_norm.y);
            A.unsafe_set(i, 5, s_norm.y);
            A.unsafe_set(i, 6, f_norm.x);
            A.unsafe_set(i, 7, f_norm.y);
            A.unsafe_set(i, 8, 1.0);
        }
    }

    public DMatrixRMaj getSvdU() {
        return this.svdU;
    }

    public DMatrixRMaj getSvdS() {
        return this.svdS;
    }

    public DMatrixRMaj getSvdV() {
        return this.svdV;
    }

    public boolean isComputeFundamental() {
        return this.computeFundamental;
    }
}

