/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import georegression.struct.point.Point3D_F64;
import javax.annotation.Nullable;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class FundamentalExtractEpipoles {
    SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd(true, true, false);
    DMatrixRMaj U = new DMatrixRMaj(3, 3);
    DMatrixRMaj V = new DMatrixRMaj(3, 3);

    public void process(DMatrixRMaj F, @Nullable Point3D_F64 e1, @Nullable Point3D_F64 e2) {
        if (!this.svd.decompose(F)) {
            throw new RuntimeException("SVD Failed?!");
        }
        this.svd.getU(this.U, false);
        this.svd.getV(this.V, false);
        double[] singular = this.svd.getSingularValues();
        SingularOps_DDRM.descendingOrder(this.U, false, singular, 3, this.V, false);
        if (e2 != null) {
            e2.set(this.U.get(0, 2), this.U.get(1, 2), this.U.get(2, 2));
        }
        if (e1 != null) {
            e1.set(this.V.get(0, 2), this.V.get(1, 2), this.V.get(2, 2));
        }
    }
}

