/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.f.FundamentalExtractEpipoles;
import boofcv.misc.BoofMiscOps;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import java.util.List;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialOps;
import org.ddogleg.solver.PolynomialRoots;
import org.ddogleg.solver.RootFinderType;
import org.ejml.data.Complex_F64;
import org.ejml.data.DMatrixRMaj;

public class EpipolarMinimizeGeometricError {
    DMatrixRMaj Ft = new DMatrixRMaj(3, 3);
    DMatrixRMaj T1 = new DMatrixRMaj(3, 3);
    DMatrixRMaj T2 = new DMatrixRMaj(3, 3);
    FundamentalExtractEpipoles extract = new FundamentalExtractEpipoles();
    Point3D_F64 e1 = new Point3D_F64();
    Point3D_F64 e2 = new Point3D_F64();
    DMatrixRMaj R1 = new DMatrixRMaj(3, 3);
    DMatrixRMaj R2 = new DMatrixRMaj(3, 3);
    Vector3D_F64 l1 = new Vector3D_F64();
    Vector3D_F64 l2 = new Vector3D_F64();
    PolynomialRoots rootFinder = PolynomialOps.createRootFinder(6, RootFinderType.EVD);
    Polynomial poly = new Polynomial(6);
    double solutionT;

    public boolean process(DMatrixRMaj F21, double x1, double y1, double x2, double y2, Point2D_F64 p1, Point2D_F64 p2) {
        EpipolarMinimizeGeometricError.assignTinv(this.T1, x1, y1);
        EpipolarMinimizeGeometricError.assignTinv(this.T2, x2, y2);
        PerspectiveOps.multTranA(this.T2, F21, this.T1, this.Ft);
        this.extract.process(this.Ft, this.e1, this.e2);
        EpipolarMinimizeGeometricError.normalizeEpipole(this.e1);
        EpipolarMinimizeGeometricError.normalizeEpipole(this.e2);
        EpipolarMinimizeGeometricError.assignR(this.R1, this.e1);
        EpipolarMinimizeGeometricError.assignR(this.R2, this.e2);
        PerspectiveOps.multTranC(this.R2, this.Ft, this.R1, this.Ft);
        double f1 = this.e1.z;
        double f2 = this.e2.z;
        double a = this.Ft.get(1, 1);
        double b = this.Ft.get(1, 2);
        double c = this.Ft.get(2, 1);
        double d = this.Ft.get(2, 2);
        if (!this.solvePolynomial(f1, f2, a, b, c, d)) {
            return false;
        }
        if (!this.selectBestSolution(this.rootFinder.getRoots(), f1, f2, a, b, c, d)) {
            return false;
        }
        double t = this.solutionT;
        this.l1.set(t * f1, 1.0, -t);
        this.l2.set(-f2 * (c * t + d), a * t + b, c * t + d);
        this.closestPointToOrigin(this.l1, this.e1);
        this.closestPointToOrigin(this.l2, this.e2);
        this.originalCoordinates(this.T1, this.R1, this.e1);
        this.originalCoordinates(this.T2, this.R2, this.e2);
        p1.set(this.e1.x / this.e1.z, this.e1.y / this.e1.z);
        p2.set(this.e2.x / this.e2.z, this.e2.y / this.e2.z);
        return true;
    }

    void closestPointToOrigin(Vector3D_F64 l, Point3D_F64 p) {
        p.x = -l.x * l.z;
        p.y = -l.y * l.z;
        p.z = l.x * l.x + l.y * l.y;
    }

    void originalCoordinates(DMatrixRMaj T, DMatrixRMaj R, Point3D_F64 p) {
        GeometryMath_F64.multTran(R, p, p);
        GeometryMath_F64.mult(T, p, p);
    }

    public boolean solvePolynomial(double f1, double f2, double a, Double b, double c, double d) {
        double f1_2 = f1 * f1;
        double f1_4 = f1_2 * f1_2;
        double f2_2 = f2 * f2;
        double f2_4 = f2_2 * f2_2;
        double a_2 = a * a;
        double b_2 = b * b;
        double c_2 = c * c;
        double d_2 = d * d;
        double b_3 = b_2 * b;
        double d_3 = d_2 * d;
        double a_4 = a_2 * a_2;
        double b_4 = b_2 * b_2;
        double c_4 = c_2 * c_2;
        double d_4 = d_2 * d_2;
        this.poly.size = 6;
        this.poly.c[5] = a * b * c_2 * f1_4 - a_2 * c * d * f1_4;
        this.poly.c[4] = b_2 * c_2 * f1_4 - a_2 * d_2 * f1_4 + c_4 * f2_4 + 2.0 * a_2 * c_2 * f2_2 + a_4;
        this.poly.c[3] = 2.0 * (3.0 * c_2 * d_2 * f2_4 + b_2 * c_2 * f1_2 - a_2 * d_2 * f1_2 + b_2 * c_2 * f2_2 + 4.0 * a * b * c * d * f2_2 + a_2 * d_2 * f2_2 + 3.0 * a_2 * b_2);
        this.poly.c[2] = 4.0 * c * d_3 * f2_4 + 2.0 * b_2 * c * d * f1_2 - 2.0 * a * b * d_2 * f1_2 + 4.0 * b_2 * c * d * f2_2 + 4.0 * a * b * d_2 * f2_2 + 4.0 * a * b_3 + a * b * c_2 - a_2 * c * d;
        this.poly.c[1] = d_4 * f2_4 + 2.0 * b_2 * d_2 * f2_2 + b_4 + b_2 * c_2 - a_2 * d_2;
        this.poly.c[0] = b_2 * c * d - a * b * d_2;
        return this.rootFinder.process(this.poly);
    }

    boolean selectBestSolution(List<Complex_F64> roots, double f1, double f2, double a, Double b, double c, double d) {
        double best = 1.0 / (f1 * f1) + c * c / (a * a + f2 * f2 * c * c);
        int bestIndex = -1;
        for (int i = 0; i < roots.size(); ++i) {
            double right;
            double t;
            double left;
            double squaredDistance;
            Complex_F64 cr = roots.get(i);
            if (!cr.isReal() || !((squaredDistance = (left = (t = cr.real) * t / (1.0 + f1 * f1 * t * t)) + (right = BoofMiscOps.pow2(c * t + d) / (BoofMiscOps.pow2(a * t + b) + f2 * f2 * BoofMiscOps.pow2(c * t + d)))) < best)) continue;
            best = squaredDistance;
            bestIndex = i;
            this.solutionT = t;
        }
        return bestIndex != -1;
    }

    static void assignTinv(DMatrixRMaj T, double x, double y) {
        T.data[8] = 1.0;
        T.data[4] = 1.0;
        T.data[0] = 1.0;
        T.data[2] = x;
        T.data[5] = y;
    }

    static void assignR(DMatrixRMaj R, Point3D_F64 e) {
        R.data[0] = e.x;
        R.data[1] = e.y;
        R.data[3] = -e.y;
        R.data[4] = e.x;
        R.data[8] = 1.0;
    }

    static void normalizeEpipole(Point3D_F64 e) {
        double n = e.x * e.x + e.y * e.y;
        e.divideIP(Math.sqrt(n));
    }
}

