/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle.jacobians;

import boofcv.alg.geo.RodriguesRotationJacobian_F64;
import boofcv.alg.geo.bundle.jacobians.JacobianSo3;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.so.Rodrigues_F64;
import org.ejml.data.DMatrixRMaj;

public class JacobianSo3Rodrigues
implements JacobianSo3 {
    private RodriguesRotationJacobian_F64 jac = new RodriguesRotationJacobian_F64();
    private Rodrigues_F64 rodrigues = new Rodrigues_F64();
    private DMatrixRMaj R = new DMatrixRMaj(3, 3);

    @Override
    public void getParameters(DMatrixRMaj R, double[] parameters, int offset) {
        ConvertRotation3D_F64.matrixToRodrigues(R, this.rodrigues);
        parameters[offset] = this.rodrigues.unitAxisRotation.x * this.rodrigues.theta;
        parameters[offset + 1] = this.rodrigues.unitAxisRotation.y * this.rodrigues.theta;
        parameters[offset + 2] = this.rodrigues.unitAxisRotation.z * this.rodrigues.theta;
    }

    @Override
    public void setParameters(double[] parameters, int offset) {
        double x = parameters[offset];
        double y = parameters[offset + 1];
        double z = parameters[offset + 2];
        this.jac.process(x, y, z);
        this.rodrigues.setParamVector(x, y, z);
        ConvertRotation3D_F64.rodriguesToMatrix(this.rodrigues, this.R);
    }

    @Override
    public int getParameterLength() {
        return 3;
    }

    @Override
    public DMatrixRMaj getRotationMatrix() {
        return this.R;
    }

    @Override
    public DMatrixRMaj getPartial(int param) {
        switch (param) {
            case 0: {
                return this.jac.Rx;
            }
            case 1: {
                return this.jac.Ry;
            }
            case 2: {
                return this.jac.Rz;
            }
        }
        throw new RuntimeException("Out of bounds parameter!");
    }
}

