/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.alg.geo.PerspectiveOps;
import georegression.geometry.UtilCurves_F64;
import georegression.struct.curve.ConicGeneral_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixRMaj;

public class NormalizationPoint2D {
    public double meanX = 0.0;
    public double stdX = 1.0;
    public double meanY = 0.0;
    public double stdY = 1.0;
    private DMatrix3x3 work = new DMatrix3x3();

    public NormalizationPoint2D() {
    }

    public NormalizationPoint2D(double meanX, double stdX, double meanY, double stdY) {
        this.meanX = meanX;
        this.stdX = stdX;
        this.meanY = meanY;
        this.stdY = stdY;
    }

    public void set(double meanX, double stdX, double meanY, double stdY) {
        this.meanX = meanX;
        this.stdX = stdX;
        this.meanY = meanY;
        this.stdY = stdY;
    }

    public void apply(DMatrixRMaj H, DMatrixRMaj output) {
        output.reshape(3, H.numCols);
        int stride = H.numCols;
        for (int col = 0; col < H.numCols; ++col) {
            double h1 = H.data[col];
            double h2 = H.data[col + stride];
            double h3 = H.data[col + 2 * stride];
            output.data[col] = h1 / this.stdX - this.meanX * h3 / this.stdX;
            output.data[col + stride] = h2 / this.stdY - this.meanY * h3 / this.stdY;
            output.data[col + 2 * stride] = h3;
        }
    }

    public void remove(DMatrixRMaj H, DMatrixRMaj output) {
        output.reshape(3, H.numCols);
        int stride = H.numCols;
        for (int col = 0; col < H.numCols; ++col) {
            double h1 = H.data[col];
            double h2 = H.data[col + stride];
            double h3 = H.data[col + 2 * stride];
            output.data[col] = h1 * this.stdX + h3 * this.meanX;
            output.data[col + stride] = h2 * this.stdY + h3 * this.meanY;
            output.data[col + 2 * stride] = h3;
        }
    }

    public void apply(Point2D_F64 p, Point2D_F64 output) {
        output.x = (p.x - this.meanX) / this.stdX;
        output.y = (p.y - this.meanY) / this.stdY;
    }

    public void apply(Point3D_F64 p, Point3D_F64 output) {
        output.x = (p.x - p.z * this.meanX) / this.stdX;
        output.y = (p.y - p.z * this.meanY) / this.stdY;
    }

    public void apply(ConicGeneral_F64 p, ConicGeneral_F64 output) {
        DMatrixRMaj C = UtilCurves_F64.convert(p, (DMatrixRMaj)null);
        DMatrixRMaj Hinv = this.matrixInv();
        DMatrixRMaj CP = new DMatrixRMaj(3, 3);
        PerspectiveOps.multTranA(Hinv, C, Hinv, CP);
        UtilCurves_F64.convert(CP, output);
    }

    public void apply(DMatrix3x3 C, DMatrix3x3 output) {
        DMatrix3x3 Hinv = this.matrixInv3(this.work);
        PerspectiveOps.multTranA(Hinv, C, Hinv, output);
    }

    public void remove(Point2D_F64 p, Point2D_F64 output) {
        output.x = p.x * this.stdX + this.meanX;
        output.y = p.y * this.stdY + this.meanY;
    }

    public void remove(Point3D_F64 p, Point3D_F64 output) {
        output.x = p.x * this.stdX + p.z * this.meanX;
        output.y = p.y * this.stdY + p.z * this.meanY;
    }

    public void remove(ConicGeneral_F64 p, ConicGeneral_F64 output) {
        DMatrixRMaj C = UtilCurves_F64.convert(p, (DMatrixRMaj)null);
        DMatrixRMaj H = this.matrix();
        DMatrixRMaj CP = new DMatrixRMaj(3, 3);
        PerspectiveOps.multTranA(H, C, H, CP);
        UtilCurves_F64.convert(CP, output);
    }

    public void remove(DMatrix3x3 C, DMatrix3x3 output) {
        DMatrix3x3 H = this.matrix3(this.work);
        PerspectiveOps.multTranA(H, C, H, output);
    }

    public DMatrixRMaj matrix() {
        DMatrixRMaj M = new DMatrixRMaj(3, 3);
        M.set(0, 0, 1.0 / this.stdX);
        M.set(1, 1, 1.0 / this.stdY);
        M.set(0, 2, -this.meanX / this.stdX);
        M.set(1, 2, -this.meanY / this.stdY);
        M.set(2, 2, 1.0);
        return M;
    }

    public DMatrixRMaj matrixInv() {
        DMatrixRMaj M = new DMatrixRMaj(3, 3);
        M.set(0, 0, this.stdX);
        M.set(1, 1, this.stdY);
        M.set(0, 2, this.meanX);
        M.set(1, 2, this.meanY);
        M.set(2, 2, 1.0);
        return M;
    }

    public DMatrix3x3 matrix3(DMatrix3x3 M) {
        if (M == null) {
            M = new DMatrix3x3();
        } else {
            M.a21 = 0.0;
            M.a31 = 0.0;
            M.a31 = 0.0;
        }
        M.a11 = 1.0 / this.stdX;
        M.a12 = 1.0 / this.stdY;
        M.a13 = -this.meanX / this.stdX;
        M.a23 = -this.meanY / this.stdY;
        M.a22 = 1.0;
        return M;
    }

    public DMatrix3x3 matrixInv3(DMatrix3x3 M) {
        if (M == null) {
            M = new DMatrix3x3();
        } else {
            M.a21 = 0.0;
            M.a31 = 0.0;
            M.a31 = 0.0;
        }
        M.a11 = this.stdX;
        M.a12 = this.stdY;
        M.a13 = this.meanX;
        M.a23 = this.meanY;
        M.a22 = 1.0;
        return M;
    }

    public boolean isEquals(NormalizationPoint2D a, double tol) {
        if (Math.abs(a.meanX - this.meanX) > tol) {
            return false;
        }
        if (Math.abs(a.meanY - this.meanY) > tol) {
            return false;
        }
        if (Math.abs(a.stdX - this.stdX) > tol) {
            return false;
        }
        return !(Math.abs(a.stdY - this.stdY) > tol);
    }
}

