/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary.impl;

import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.concurrency.BoofConcurrency;
import boofcv.concurrency.FWorkArrays;
import boofcv.concurrency.IWorkArrays;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import javax.annotation.Nullable;

public class ImplThresholdImageOps_MT {
    public static GrayU8 threshold(GrayF32 input, GrayU8 output, float threshold, boolean down) {
        if (down) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                for (int i = input.width; i > 0; --i) {
                    output.data[indexOut++] = (byte)(input.data[indexIn++] <= threshold ? 1 : 0);
                }
            });
        } else {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                for (int i = input.width; i > 0; --i) {
                    output.data[indexOut++] = (byte)(input.data[indexIn++] > threshold ? 1 : 0);
                }
            });
        }
        return output;
    }

    public static GrayU8 threshold(GrayF64 input, GrayU8 output, double threshold, boolean down) {
        if (down) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                for (int i = input.width; i > 0; --i) {
                    output.data[indexOut++] = (byte)(input.data[indexIn++] <= threshold ? 1 : 0);
                }
            });
        } else {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                for (int i = input.width; i > 0; --i) {
                    output.data[indexOut++] = (byte)(input.data[indexIn++] > threshold ? 1 : 0);
                }
            });
        }
        return output;
    }

    public static GrayU8 threshold(GrayU8 input, GrayU8 output, int threshold, boolean down) {
        if (down) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                for (int i = input.width; i > 0; --i) {
                    output.data[indexOut++] = (byte)((input.data[indexIn++] & 0xFF) <= threshold ? 1 : 0);
                }
            });
        } else {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                for (int i = input.width; i > 0; --i) {
                    output.data[indexOut++] = (byte)((input.data[indexIn++] & 0xFF) > threshold ? 1 : 0);
                }
            });
        }
        return output;
    }

    public static GrayU8 threshold(GrayS16 input, GrayU8 output, int threshold, boolean down) {
        if (down) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                for (int i = input.width; i > 0; --i) {
                    output.data[indexOut++] = (byte)(input.data[indexIn++] <= threshold ? 1 : 0);
                }
            });
        } else {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                for (int i = input.width; i > 0; --i) {
                    output.data[indexOut++] = (byte)(input.data[indexIn++] > threshold ? 1 : 0);
                }
            });
        }
        return output;
    }

    public static GrayU8 threshold(GrayU16 input, GrayU8 output, int threshold, boolean down) {
        if (down) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                for (int i = input.width; i > 0; --i) {
                    output.data[indexOut++] = (byte)((input.data[indexIn++] & 0xFFFF) <= threshold ? 1 : 0);
                }
            });
        } else {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                for (int i = input.width; i > 0; --i) {
                    output.data[indexOut++] = (byte)((input.data[indexIn++] & 0xFFFF) > threshold ? 1 : 0);
                }
            });
        }
        return output;
    }

    public static GrayU8 threshold(GrayS32 input, GrayU8 output, int threshold, boolean down) {
        if (down) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                for (int i = input.width; i > 0; --i) {
                    output.data[indexOut++] = (byte)(input.data[indexIn++] <= threshold ? 1 : 0);
                }
            });
        } else {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                for (int i = input.width; i > 0; --i) {
                    output.data[indexOut++] = (byte)(input.data[indexIn++] > threshold ? 1 : 0);
                }
            });
        }
        return output;
    }

    public static GrayU8 localMean(GrayU8 input, GrayU8 output, ConfigLength width, float scale, boolean down, GrayU8 storage1, GrayU8 storage2, @Nullable IWorkArrays storage3) {
        int radius = width.computeI(Math.min(input.width, input.height)) / 2;
        GrayU8 mean = storage1;
        BlurImageOps.mean(input, mean, radius, storage2, storage3);
        if (down) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = mean.startIndex + y * mean.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = (float)(mean.data[indexMean++] & 0xFF) * scale;
                    output.data[indexOut++] = (float)(input.data[indexIn++] & 0xFF) <= threshold ? (byte)1 : (byte)0;
                }
            });
        } else {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = mean.startIndex + y * mean.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = mean.data[indexMean++] & 0xFF;
                    output.data[indexOut++] = (float)(input.data[indexIn++] & 0xFF) * scale > threshold ? (byte)1 : (byte)0;
                }
            });
        }
        return output;
    }

    public static GrayU8 localGaussian(GrayU8 input, GrayU8 output, ConfigLength width, float scale, boolean down, GrayU8 storage1, GrayU8 storage2) {
        int radius = width.computeI(Math.min(input.width, input.height)) / 2;
        GrayU8 blur = storage1;
        BlurImageOps.gaussian(input, blur, -1.0, radius, storage2);
        if (down) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = blur.startIndex + y * blur.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = (float)(blur.data[indexMean] & 0xFF) * scale;
                    output.data[indexOut] = (float)(input.data[indexIn] & 0xFF) <= threshold ? (byte)1 : (byte)0;
                    ++indexIn;
                    ++indexOut;
                    ++indexMean;
                }
            });
        } else {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = blur.startIndex + y * blur.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    int threshold = blur.data[indexMean] & 0xFF;
                    output.data[indexOut] = (float)(input.data[indexIn] & 0xFF) * scale > (float)threshold ? (byte)1 : (byte)0;
                    ++indexIn;
                    ++indexOut;
                    ++indexMean;
                }
            });
        }
        return output;
    }

    public static GrayU8 localMean(GrayU16 input, GrayU8 output, ConfigLength width, float scale, boolean down, GrayU16 storage1, GrayU16 storage2, @Nullable IWorkArrays storage3) {
        int radius = width.computeI(Math.min(input.width, input.height)) / 2;
        GrayU16 mean = storage1;
        BlurImageOps.mean(input, mean, radius, storage2, storage3);
        if (down) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = mean.startIndex + y * mean.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = (float)(mean.data[indexMean++] & 0xFFFF) * scale;
                    output.data[indexOut++] = (float)(input.data[indexIn++] & 0xFFFF) <= threshold ? (byte)1 : (byte)0;
                }
            });
        } else {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = mean.startIndex + y * mean.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = mean.data[indexMean++] & 0xFFFF;
                    output.data[indexOut++] = (float)(input.data[indexIn++] & 0xFFFF) * scale > threshold ? (byte)1 : (byte)0;
                }
            });
        }
        return output;
    }

    public static GrayU8 localGaussian(GrayU16 input, GrayU8 output, ConfigLength width, float scale, boolean down, GrayU16 storage1, GrayU16 storage2) {
        int radius = width.computeI(Math.min(input.width, input.height)) / 2;
        GrayU16 blur = storage1;
        BlurImageOps.gaussian(input, blur, -1.0, radius, storage2);
        if (down) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = blur.startIndex + y * blur.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = (float)(blur.data[indexMean] & 0xFFFF) * scale;
                    output.data[indexOut] = (float)(input.data[indexIn] & 0xFFFF) <= threshold ? (byte)1 : (byte)0;
                    ++indexIn;
                    ++indexOut;
                    ++indexMean;
                }
            });
        } else {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = blur.startIndex + y * blur.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    int threshold = blur.data[indexMean] & 0xFFFF;
                    output.data[indexOut] = (float)(input.data[indexIn] & 0xFFFF) * scale > (float)threshold ? (byte)1 : (byte)0;
                    ++indexIn;
                    ++indexOut;
                    ++indexMean;
                }
            });
        }
        return output;
    }

    public static GrayU8 localMean(GrayF32 input, GrayU8 output, ConfigLength width, float scale, boolean down, GrayF32 storage1, GrayF32 storage2, @Nullable FWorkArrays storage3) {
        int radius = width.computeI(Math.min(input.width, input.height)) / 2;
        GrayF32 mean = storage1;
        BlurImageOps.mean(input, mean, radius, storage2, storage3);
        if (down) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = mean.startIndex + y * mean.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = mean.data[indexMean++] * scale;
                    output.data[indexOut++] = input.data[indexIn++] <= threshold ? (byte)1 : (byte)0;
                }
            });
        } else {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = mean.startIndex + y * mean.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = mean.data[indexMean++];
                    output.data[indexOut++] = input.data[indexIn++] * scale > threshold ? (byte)1 : (byte)0;
                }
            });
        }
        return output;
    }

    public static GrayU8 localGaussian(GrayF32 input, GrayU8 output, ConfigLength width, float scale, boolean down, GrayF32 storage1, GrayF32 storage2) {
        int radius = width.computeI(Math.min(input.width, input.height)) / 2;
        GrayF32 blur = storage1;
        BlurImageOps.gaussian(input, blur, -1.0, radius, storage2);
        if (down) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = blur.startIndex + y * blur.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = blur.data[indexMean] * scale;
                    output.data[indexOut] = input.data[indexIn] <= threshold ? (byte)1 : (byte)0;
                    ++indexIn;
                    ++indexOut;
                    ++indexMean;
                }
            });
        } else {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = blur.startIndex + y * blur.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = blur.data[indexMean];
                    output.data[indexOut] = input.data[indexIn] * scale > threshold ? (byte)1 : (byte)0;
                    ++indexIn;
                    ++indexOut;
                    ++indexMean;
                }
            });
        }
        return output;
    }
}

