/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary.impl;

import boofcv.struct.border.ImageBorderValue;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayU8;
import org.ddogleg.struct.GrowQueue_I32;

public class BinaryThinning {
    public static byte[] mask0 = new byte[]{0, 0, 0, -1, 1, -1, 1, 1, 1};
    public static byte[] mask1 = new byte[]{-1, 0, 0, 1, 1, 0, -1, 1, -1};
    public static byte[] mask2 = new byte[]{1, -1, 0, 1, 1, 0, 1, -1, 0};
    public static byte[] mask3 = new byte[]{-1, 1, -1, 1, 1, 0, -1, 0, 0};
    public static byte[] mask4 = new byte[]{1, 1, 1, -1, 1, -1, 0, 0, 0};
    public static byte[] mask5 = new byte[]{-1, 1, -1, 0, 1, 1, 0, 0, -1};
    public static byte[] mask6 = new byte[]{0, -1, 1, 0, 1, 1, 0, -1, 1};
    public static byte[] mask7 = new byte[]{0, 0, -1, 0, 1, 1, -1, 1, -1};
    Mask[] masks = new Mask[]{new Mask0(), new Mask1(), new Mask2(), new Mask3(), new Mask4(), new Mask5(), new Mask6(), new Mask7()};
    GrayU8 binary;
    ImageBorder_S32<GrayU8> inputBorder = ImageBorderValue.wrap(this.binary, 0);
    GrowQueue_I32 ones0 = new GrowQueue_I32();
    GrowQueue_I32 ones1 = new GrowQueue_I32();
    GrowQueue_I32 zerosOut = new GrowQueue_I32();

    public void apply(GrayU8 binary, int maxLoops) {
        this.binary = binary;
        this.inputBorder.setImage(binary);
        this.ones0.reset();
        this.zerosOut.reset();
        this.findOnePixels(this.ones0);
        for (int loop = 0; (loop < maxLoops || maxLoops == -1) && this.ones0.size > 0; ++loop) {
            boolean changed = false;
            for (int i = 0; i < this.masks.length; ++i) {
                this.zerosOut.reset();
                this.ones1.reset();
                this.masks[i].apply(this.ones0, this.ones1, this.zerosOut);
                changed |= this.ones0.size != this.ones1.size;
                for (int j = 0; j < this.zerosOut.size(); ++j) {
                    binary.data[this.zerosOut.get((int)j)] = 0;
                }
                GrowQueue_I32 tmp = this.ones0;
                this.ones0 = this.ones1;
                this.ones1 = tmp;
            }
            if (!changed) break;
        }
    }

    protected void findOnePixels(GrowQueue_I32 ones) {
        for (int y = 0; y < this.binary.height; ++y) {
            int index = this.binary.startIndex + y * this.binary.stride;
            int x = 0;
            while (x < this.binary.width) {
                if (this.binary.data[index] != 0) {
                    ones.add(index);
                }
                ++x;
                ++index;
            }
        }
    }

    public class Mask7
    extends Mask {
        public Mask7() {
            super(mask7);
        }

        @Override
        protected boolean innerMask(int indexIn) {
            int rowTop = indexIn - BinaryThinning.this.binary.stride;
            if (BinaryThinning.this.binary.data[rowTop - 1] != 0 || BinaryThinning.this.binary.data[rowTop] != 0 || BinaryThinning.this.binary.data[indexIn - 1] != 0 || BinaryThinning.this.binary.data[indexIn + 1] != 1) {
                return true;
            }
            int rowBottom = indexIn + BinaryThinning.this.binary.stride;
            return BinaryThinning.this.binary.data[rowBottom] != 1;
        }
    }

    public class Mask6
    extends Mask {
        public Mask6() {
            super(mask6);
        }

        @Override
        protected boolean innerMask(int indexIn) {
            int rowTop = indexIn - BinaryThinning.this.binary.stride;
            if (BinaryThinning.this.binary.data[indexIn - 1] != 0 || BinaryThinning.this.binary.data[indexIn + 1] != 1 || BinaryThinning.this.binary.data[rowTop - 1] != 0 || BinaryThinning.this.binary.data[rowTop + 1] != 1) {
                return true;
            }
            int rowBottom = indexIn + BinaryThinning.this.binary.stride;
            return BinaryThinning.this.binary.data[rowBottom - 1] != 0 || BinaryThinning.this.binary.data[rowBottom + 1] != 1;
        }
    }

    public class Mask5
    extends Mask {
        public Mask5() {
            super(mask5);
        }

        @Override
        protected boolean innerMask(int indexIn) {
            int rowTop = indexIn - BinaryThinning.this.binary.stride;
            if (BinaryThinning.this.binary.data[indexIn - 1] != 0 || BinaryThinning.this.binary.data[indexIn + 1] != 1 || BinaryThinning.this.binary.data[rowTop] != 1) {
                return true;
            }
            int rowBottom = indexIn + BinaryThinning.this.binary.stride;
            return BinaryThinning.this.binary.data[rowBottom - 1] != 0 || BinaryThinning.this.binary.data[rowBottom] != 0;
        }
    }

    public class Mask4
    extends Mask {
        public Mask4() {
            super(mask4);
        }

        @Override
        protected boolean innerMask(int indexIn) {
            int rowTop = indexIn - BinaryThinning.this.binary.stride;
            if (BinaryThinning.this.binary.data[rowTop - 1] != 1 || BinaryThinning.this.binary.data[rowTop] != 1 || BinaryThinning.this.binary.data[rowTop + 1] != 1) {
                return true;
            }
            int rowBottom = indexIn + BinaryThinning.this.binary.stride;
            return BinaryThinning.this.binary.data[rowBottom - 1] != 0 || BinaryThinning.this.binary.data[rowBottom] != 0 || BinaryThinning.this.binary.data[rowBottom + 1] != 0;
        }
    }

    public class Mask3
    extends Mask {
        public Mask3() {
            super(mask3);
        }

        @Override
        protected boolean innerMask(int indexIn) {
            int rowTop = indexIn - BinaryThinning.this.binary.stride;
            if (BinaryThinning.this.binary.data[indexIn - 1] != 1 || BinaryThinning.this.binary.data[indexIn + 1] != 0 || BinaryThinning.this.binary.data[rowTop] != 1) {
                return true;
            }
            int rowBottom = indexIn + BinaryThinning.this.binary.stride;
            return BinaryThinning.this.binary.data[rowBottom] != 0 || BinaryThinning.this.binary.data[rowBottom + 1] != 0;
        }
    }

    public class Mask2
    extends Mask {
        public Mask2() {
            super(mask2);
        }

        @Override
        protected boolean innerMask(int indexIn) {
            int rowTop = indexIn - BinaryThinning.this.binary.stride;
            if (BinaryThinning.this.binary.data[indexIn - 1] != 1 || BinaryThinning.this.binary.data[indexIn + 1] != 0 || BinaryThinning.this.binary.data[rowTop - 1] != 1 || BinaryThinning.this.binary.data[rowTop + 1] != 0) {
                return true;
            }
            int rowBottom = indexIn + BinaryThinning.this.binary.stride;
            return BinaryThinning.this.binary.data[rowBottom - 1] != 1 || BinaryThinning.this.binary.data[rowBottom + 1] != 0;
        }
    }

    public class Mask1
    extends Mask {
        public Mask1() {
            super(mask1);
        }

        @Override
        protected boolean innerMask(int indexIn) {
            int rowTop = indexIn - BinaryThinning.this.binary.stride;
            int rowBottom = indexIn + BinaryThinning.this.binary.stride;
            if (BinaryThinning.this.binary.data[indexIn - 1] != 1 || BinaryThinning.this.binary.data[rowBottom] != 1) {
                return true;
            }
            return BinaryThinning.this.binary.data[rowTop] != 0 || BinaryThinning.this.binary.data[rowTop + 1] != 0 || BinaryThinning.this.binary.data[indexIn + 1] != 0;
        }
    }

    public class Mask0
    extends Mask {
        public Mask0() {
            super(mask0);
        }

        @Override
        protected boolean innerMask(int indexIn) {
            int rowTop = indexIn - BinaryThinning.this.binary.stride;
            if (BinaryThinning.this.binary.data[rowTop - 1] != 0 || BinaryThinning.this.binary.data[rowTop] != 0 || BinaryThinning.this.binary.data[rowTop + 1] != 0) {
                return true;
            }
            int rowBottom = indexIn + BinaryThinning.this.binary.stride;
            return BinaryThinning.this.binary.data[rowBottom - 1] != 1 || BinaryThinning.this.binary.data[rowBottom] != 1 || BinaryThinning.this.binary.data[rowBottom + 1] != 1;
        }
    }

    protected abstract class Mask {
        byte[] mask;

        public Mask(byte[] mask) {
            this.mask = mask;
        }

        public void apply(GrowQueue_I32 onesIn, GrowQueue_I32 onesOut, GrowQueue_I32 zerosOut) {
            int w = BinaryThinning.this.binary.width - 1;
            int h = BinaryThinning.this.binary.height - 1;
            for (int i = 0; i < onesIn.size; ++i) {
                int indexIn = onesIn.get(i);
                int x = (indexIn - BinaryThinning.this.binary.startIndex) % BinaryThinning.this.binary.stride;
                int y = (indexIn - BinaryThinning.this.binary.startIndex) / BinaryThinning.this.binary.stride;
                boolean staysAsOne = x == 0 || x == w || y == 0 || y == h ? this.borderMask(x, y) : this.innerMask(indexIn);
                if (staysAsOne) {
                    onesOut.add(indexIn);
                    continue;
                }
                zerosOut.add(indexIn);
            }
        }

        protected boolean borderMask(int cx, int cy) {
            int maskIndex = 0;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    byte m;
                    if ((m = this.mask[maskIndex++]) == -1) continue;
                    int pixel = BinaryThinning.this.inputBorder.get(cx + j, cy + i);
                    if (!(m == 0 ? pixel != 0 : pixel != 1)) continue;
                    return true;
                }
            }
            return false;
        }

        protected abstract boolean innerMask(int var1);
    }
}

