/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.alg.filter.binary.ThresholdLocalOtsu;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayU8;

public class ThresholdLocalOtsu_MT
extends ThresholdLocalOtsu {
    public ThresholdLocalOtsu_MT(boolean otsu2, ConfigLength regionWidthLength, double tuning, double scale, boolean down) {
        super(otsu2, regionWidthLength, tuning, scale, down);
    }

    @Override
    protected void process(GrayU8 input, GrayU8 output, int x0, int y0, int x1, int y1, byte a, byte b) {
        BoofConcurrency.loopBlocks(y0, y1, (block0, block1) -> {
            ThresholdLocalOtsu.ApplyHelper h = (ThresholdLocalOtsu.ApplyHelper)this.helpers.pop();
            for (int y = block0; y < block1; ++y) {
                int indexInput = input.startIndex + y * input.stride + x0;
                int indexOutput = output.startIndex + y * output.stride + x0;
                h.computeHistogram(0, y - y0, input);
                output.data[indexOutput++] = (double)(input.data[indexInput++] & 0xFF) <= h.otsu.threshold ? a : b;
                for (int x = x0 + 1; x < x1; ++x) {
                    h.updateHistogramX(x - x0, y - y0, input);
                    output.data[indexOutput++] = (double)(input.data[indexInput++] & 0xFF) <= h.otsu.threshold ? a : b;
                }
            }
            this.helpers.recycle(h);
        });
        ThresholdLocalOtsu.ApplyHelper h = (ThresholdLocalOtsu.ApplyHelper)this.helpers.pop();
        this.applyToBorder(input, output, y0, y1, x0, x1, h);
        this.helpers.recycle(h);
    }
}

