/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.filter.binary.ComputeOtsu;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import boofcv.struct.lists.RecycleStack;
import java.util.Arrays;

public class ThresholdLocalOtsu
implements InputToBinary<GrayU8> {
    ImageType<GrayU8> imageType = ImageType.single(GrayU8.class);
    private final boolean useOtsu2;
    private final double tuning;
    private final boolean down;
    private final double scale;
    ConfigLength regionWidthLength;
    int regionWidth;
    int numPixels;
    RecycleStack<ApplyHelper> helpers = new RecycleStack<ApplyHelper>(() -> new ApplyHelper());

    public ThresholdLocalOtsu(boolean otsu2, ConfigLength regionWidthLength, double tuning, double scale, boolean down) {
        this.regionWidthLength = regionWidthLength;
        this.useOtsu2 = otsu2;
        this.tuning = tuning;
        this.scale = scale;
        this.down = down;
    }

    @Override
    public void process(GrayU8 input, GrayU8 output) {
        byte b;
        byte a;
        output.reshape(input.width, input.height);
        this.regionWidth = this.regionWidthLength.computeI(Math.min(input.width, input.height));
        if (input.width < this.regionWidth || input.height < this.regionWidth) {
            this.regionWidth = Math.min(input.width, input.height);
        }
        this.numPixels = this.regionWidth * this.regionWidth;
        int y0 = this.regionWidth / 2;
        int y1 = input.height - (this.regionWidth - y0);
        int x0 = this.regionWidth / 2;
        int x1 = input.width - (this.regionWidth - x0);
        if (this.down) {
            a = 1;
            b = 0;
        } else {
            a = 0;
            b = 1;
        }
        this.process(input, output, x0, y0, x1, y1, a, b);
    }

    protected void process(GrayU8 input, GrayU8 output, int x0, int y0, int x1, int y1, byte a, byte b) {
        ApplyHelper h = this.helpers.pop();
        for (int y = y0; y < y1; ++y) {
            int indexInput = input.startIndex + y * input.stride + x0;
            int indexOutput = output.startIndex + y * output.stride + x0;
            h.computeHistogram(0, y - y0, input);
            output.data[indexOutput++] = (double)(input.data[indexInput++] & 0xFF) <= h.otsu.threshold ? a : b;
            for (int x = x0 + 1; x < x1; ++x) {
                h.updateHistogramX(x - x0, y - y0, input);
                output.data[indexOutput++] = (double)(input.data[indexInput++] & 0xFF) <= h.otsu.threshold ? a : b;
            }
        }
        this.applyToBorder(input, output, y0, y1, x0, x1, h);
        this.helpers.recycle(h);
    }

    void applyToBorder(GrayU8 input, GrayU8 output, int y0, int y1, int x0, int x1, ApplyHelper h) {
        int y;
        int x;
        h.computeHistogram(0, 0, input);
        h.applyToBlock(0, 0, x0 + 1, y0 + 1, input, output);
        for (x = x0 + 1; x < x1; ++x) {
            h.updateHistogramX(x - x0, 0, input);
            h.applyToBlock(x, 0, x + 1, y0, input, output);
        }
        h.updateHistogramX(x1 - x0, 0, input);
        h.applyToBlock(x1, 0, input.width, y0 + 1, input, output);
        for (y = y0 + 1; y < y1; ++y) {
            h.updateHistogramY(x1 - x0, y - y0, input);
            h.applyToBlock(x1, y, input.width, y + 1, input, output);
        }
        h.updateHistogramY(x1 - x0, y1 - y0, input);
        h.applyToBlock(x1, y1, input.width, input.height, input, output);
        h.computeHistogram(0, 0, input);
        for (y = y0 + 1; y < y1; ++y) {
            h.updateHistogramY(0, y - y0, input);
            h.applyToBlock(0, y, x0, y + 1, input, output);
        }
        h.updateHistogramY(0, y1 - y0, input);
        h.applyToBlock(0, y1, x0 + 1, input.height, input, output);
        for (x = x0 + 1; x < x1; ++x) {
            h.updateHistogramX(x - x0, y1 - y0, input);
            h.applyToBlock(x, y1, x + 1, input.height, input, output);
        }
    }

    @Override
    public ImageType<GrayU8> getInputType() {
        return this.imageType;
    }

    static /* synthetic */ boolean access$100(ThresholdLocalOtsu x0) {
        return x0.useOtsu2;
    }

    static /* synthetic */ double access$200(ThresholdLocalOtsu x0) {
        return x0.tuning;
    }

    static /* synthetic */ boolean access$300(ThresholdLocalOtsu x0) {
        return x0.down;
    }

    static /* synthetic */ double access$400(ThresholdLocalOtsu x0) {
        return x0.scale;
    }

    class ApplyHelper {
        int[] histogram = new int[256];
        ComputeOtsu otsu = new ComputeOtsu(ThresholdLocalOtsu.access$100(ThresholdLocalOtsu.this), ThresholdLocalOtsu.access$200(ThresholdLocalOtsu.this), ThresholdLocalOtsu.access$300(ThresholdLocalOtsu.this), ThresholdLocalOtsu.access$400(ThresholdLocalOtsu.this));

        ApplyHelper() {
        }

        private void applyToBlock(int x0, int y0, int x1, int y1, GrayU8 input, GrayU8 output) {
            byte b;
            byte a;
            if (this.otsu.down) {
                a = 1;
                b = 0;
            } else {
                a = 0;
                b = 1;
            }
            for (int y = y0; y < y1; ++y) {
                int indexInput = input.startIndex + y * input.stride + x0;
                int indexOutput = output.startIndex + y * output.stride + x0;
                int end = indexOutput + (x1 - x0);
                while (indexOutput < end) {
                    output.data[indexOutput++] = (double)(input.data[indexInput++] & 0xFF) <= this.otsu.threshold ? a : b;
                }
            }
        }

        void computeHistogram(int x0, int y0, GrayU8 input) {
            Arrays.fill(this.histogram, 0);
            for (int y = 0; y < ThresholdLocalOtsu.this.regionWidth; ++y) {
                int indexInput = input.startIndex + (y0 + y) * input.stride + x0;
                for (int x = 0; x < ThresholdLocalOtsu.this.regionWidth; ++x) {
                    int n = input.data[indexInput++] & 0xFF;
                    this.histogram[n] = this.histogram[n] + 1;
                }
            }
            this.otsu.compute(this.histogram, this.histogram.length, ThresholdLocalOtsu.this.numPixels);
        }

        void updateHistogramX(int x0, int y0, GrayU8 input) {
            if (x0 <= 0) {
                return;
            }
            int indexInput = input.startIndex + y0 * input.stride + x0 - 1;
            for (int y = 0; y < ThresholdLocalOtsu.this.regionWidth; ++y) {
                int n = input.data[indexInput] & 0xFF;
                this.histogram[n] = this.histogram[n] - 1;
                int n2 = input.data[indexInput + ThresholdLocalOtsu.this.regionWidth] & 0xFF;
                this.histogram[n2] = this.histogram[n2] + 1;
                indexInput += input.stride;
            }
            this.otsu.compute(this.histogram, this.histogram.length, ThresholdLocalOtsu.this.numPixels);
        }

        void updateHistogramY(int x0, int y0, GrayU8 input) {
            if (y0 <= 0) {
                return;
            }
            int offset = ThresholdLocalOtsu.this.regionWidth * input.stride;
            for (int x = 0; x < ThresholdLocalOtsu.this.regionWidth; ++x) {
                int indexInput = input.startIndex + (y0 - 1) * input.stride + x0 + x;
                int n = input.data[indexInput] & 0xFF;
                this.histogram[n] = this.histogram[n] - 1;
                int n2 = input.data[indexInput + offset] & 0xFF;
                this.histogram[n2] = this.histogram[n2] + 1;
            }
            this.otsu.compute(this.histogram, this.histogram.length, ThresholdLocalOtsu.this.numPixels);
        }
    }
}

