/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.alg.filter.binary.ThresholdBlock;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;

public class ThresholdBlock_MT<T extends ImageGray<T>, S extends ImageBase<S>>
extends ThresholdBlock<T, S> {
    public ThresholdBlock_MT(ThresholdBlock.BlockProcessor<T, S> processor, ConfigLength requestedBlockWidth, boolean thresholdFromLocalBlocks, Class<T> imageClass) {
        super(processor, requestedBlockWidth, thresholdFromLocalBlocks, imageClass);
    }

    @Override
    protected void computeStatistics(T input, int innerWidth, int innerHeight) {
        int statPixelStride = this.stats.getImageType().getNumBands();
        int statStride = this.stats.stride;
        int vblocks = innerHeight / this.blockHeight;
        if (vblocks * this.blockHeight < innerHeight) {
            ++vblocks;
        }
        BoofConcurrency.loopFor(0, vblocks, vblock -> {
            ThresholdBlock.BlockProcessor processor = (ThresholdBlock.BlockProcessor)this.processors.pop();
            processor.init(this.blockWidth, this.blockHeight, this.thresholdFromLocalBlocks);
            int y = vblock * this.blockHeight;
            int indexStats = y / this.blockHeight * statStride;
            int x = 0;
            while (x < innerWidth) {
                processor.computeBlockStatistics(x, y, this.blockWidth, this.blockHeight, indexStats, input, this.stats);
                x += this.blockWidth;
                indexStats += statPixelStride;
            }
            if (innerWidth != input.width) {
                processor.computeBlockStatistics(innerWidth, y, input.width - innerWidth, this.blockHeight, indexStats, input, this.stats);
            }
            this.processors.recycle(processor);
        });
        if (innerHeight != ((ImageGray)input).height) {
            ThresholdBlock.BlockProcessor processor = (ThresholdBlock.BlockProcessor)this.processors.pop();
            processor.init(this.blockWidth, this.blockHeight, this.thresholdFromLocalBlocks);
            int indexStats = innerHeight / this.blockHeight * statStride;
            int y = innerHeight;
            int blockHeight = ((ImageGray)input).height - innerHeight;
            int x = 0;
            while (x < innerWidth) {
                processor.computeBlockStatistics(x, y, this.blockWidth, blockHeight, indexStats, input, this.stats);
                x += this.blockWidth;
                indexStats += statPixelStride;
            }
            if (innerWidth != ((ImageGray)input).width) {
                processor.computeBlockStatistics(innerWidth, y, ((ImageGray)input).width - innerWidth, blockHeight, indexStats, input, this.stats);
            }
        }
    }

    @Override
    protected void applyThreshold(T input, GrayU8 output) {
        BoofConcurrency.loopFor(0, this.stats.height, blockY -> {
            ThresholdBlock.BlockProcessor processor = (ThresholdBlock.BlockProcessor)this.processors.pop();
            processor.init(this.blockWidth, this.blockHeight, this.thresholdFromLocalBlocks);
            for (int blockX = 0; blockX < this.stats.width; ++blockX) {
                processor.thresholdBlock(blockX, blockY, input, this.stats, output);
            }
        });
    }
}

