/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.abst.filter.binary.BinaryContourFinderLinearExternal;
import boofcv.abst.filter.binary.BinaryContourInterface;
import boofcv.abst.filter.binary.BinaryLabelContourFinder;
import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.ContourPacked;
import boofcv.alg.filter.binary.impl.BinaryThinning;
import boofcv.alg.filter.binary.impl.ImplBinaryBorderOps;
import boofcv.alg.filter.binary.impl.ImplBinaryImageOps;
import boofcv.alg.filter.binary.impl.ImplBinaryImageOps_MT;
import boofcv.alg.filter.binary.impl.ImplBinaryInnerOps;
import boofcv.alg.filter.binary.impl.ImplBinaryInnerOps_MT;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.filter.binary.FactoryBinaryContourFinder;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.struct.FastQueue;

public class BinaryImageOps {
    public static GrayU8 logicAnd(GrayU8 inputA, GrayU8 inputB, GrayU8 output) {
        InputSanityCheck.checkSameShape(inputA, inputB);
        output = InputSanityCheck.checkDeclare(inputA, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplBinaryImageOps_MT.logicAnd(inputA, inputB, output);
        } else {
            ImplBinaryImageOps.logicAnd(inputA, inputB, output);
        }
        return output;
    }

    public static GrayU8 logicOr(GrayU8 inputA, GrayU8 inputB, GrayU8 output) {
        InputSanityCheck.checkSameShape(inputA, inputB);
        output = InputSanityCheck.checkDeclare(inputA, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplBinaryImageOps_MT.logicOr(inputA, inputB, output);
        } else {
            ImplBinaryImageOps.logicOr(inputA, inputB, output);
        }
        return output;
    }

    public static GrayU8 logicXor(GrayU8 inputA, GrayU8 inputB, GrayU8 output) {
        InputSanityCheck.checkSameShape(inputA, inputB);
        output = InputSanityCheck.checkDeclare(inputA, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplBinaryImageOps_MT.logicXor(inputA, inputB, output);
        } else {
            ImplBinaryImageOps.logicXor(inputA, inputB, output);
        }
        return output;
    }

    public static GrayU8 invert(GrayU8 input, GrayU8 output) {
        output = InputSanityCheck.checkDeclare(input, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplBinaryImageOps_MT.invert(input, output);
        } else {
            ImplBinaryImageOps.invert(input, output);
        }
        return output;
    }

    public static GrayU8 erode4(GrayU8 input, int numTimes, GrayU8 output) {
        output = InputSanityCheck.checkDeclare(input, output);
        if (numTimes <= 0) {
            throw new IllegalArgumentException("numTimes must be >= 1");
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplBinaryInnerOps_MT.erode4(input, output);
        } else {
            ImplBinaryInnerOps.erode4(input, output);
        }
        ImplBinaryBorderOps.erode4(input, output);
        if (numTimes > 1) {
            GrayU8 tmp1 = new GrayU8(input.width, input.height);
            GrayU8 tmp2 = output;
            for (int i = 1; i < numTimes; ++i) {
                if (BoofConcurrency.USE_CONCURRENT) {
                    ImplBinaryInnerOps_MT.erode4(tmp2, tmp1);
                } else {
                    ImplBinaryInnerOps.erode4(tmp2, tmp1);
                }
                ImplBinaryBorderOps.erode4(tmp2, tmp1);
                GrayU8 a = tmp1;
                tmp1 = tmp2;
                tmp2 = a;
            }
            if (tmp2 != output) {
                output.setTo(tmp2);
            }
        }
        return output;
    }

    public static GrayU8 dilate4(GrayU8 input, int numTimes, GrayU8 output) {
        output = InputSanityCheck.checkDeclare(input, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplBinaryInnerOps_MT.dilate4(input, output);
        } else {
            ImplBinaryInnerOps.dilate4(input, output);
        }
        ImplBinaryBorderOps.dilate4(input, output);
        if (numTimes > 1) {
            GrayU8 tmp1 = new GrayU8(input.width, input.height);
            GrayU8 tmp2 = output;
            for (int i = 1; i < numTimes; ++i) {
                if (BoofConcurrency.USE_CONCURRENT) {
                    ImplBinaryInnerOps_MT.dilate4(tmp2, tmp1);
                } else {
                    ImplBinaryInnerOps.dilate4(tmp2, tmp1);
                }
                ImplBinaryBorderOps.dilate4(tmp2, tmp1);
                GrayU8 a = tmp1;
                tmp1 = tmp2;
                tmp2 = a;
            }
            if (tmp2 != output) {
                output.setTo(tmp2);
            }
        }
        return output;
    }

    public static GrayU8 edge4(GrayU8 input, GrayU8 output, boolean outsideZero) {
        output = InputSanityCheck.checkDeclare(input, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplBinaryInnerOps_MT.edge4(input, output);
        } else {
            ImplBinaryInnerOps.edge4(input, output);
        }
        ImplBinaryBorderOps.edge4(input, output, outsideZero);
        return output;
    }

    public static GrayU8 erode8(GrayU8 input, int numTimes, GrayU8 output) {
        output = InputSanityCheck.checkDeclare(input, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplBinaryInnerOps_MT.erode8(input, output);
        } else {
            ImplBinaryInnerOps.erode8(input, output);
        }
        ImplBinaryBorderOps.erode8(input, output);
        if (numTimes > 1) {
            GrayU8 tmp1 = new GrayU8(input.width, input.height);
            GrayU8 tmp2 = output;
            for (int i = 1; i < numTimes; ++i) {
                if (BoofConcurrency.USE_CONCURRENT) {
                    ImplBinaryInnerOps_MT.erode8(tmp2, tmp1);
                } else {
                    ImplBinaryInnerOps.erode8(tmp2, tmp1);
                }
                ImplBinaryBorderOps.erode8(tmp2, tmp1);
                GrayU8 a = tmp1;
                tmp1 = tmp2;
                tmp2 = a;
            }
            if (tmp2 != output) {
                output.setTo(tmp2);
            }
        }
        return output;
    }

    public static GrayU8 dilate8(GrayU8 input, int numTimes, GrayU8 output) {
        output = InputSanityCheck.checkDeclare(input, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplBinaryInnerOps_MT.dilate8(input, output);
        } else {
            ImplBinaryInnerOps.dilate8(input, output);
        }
        ImplBinaryBorderOps.dilate8(input, output);
        if (numTimes > 1) {
            GrayU8 tmp1 = new GrayU8(input.width, input.height);
            GrayU8 tmp2 = output;
            for (int i = 1; i < numTimes; ++i) {
                if (BoofConcurrency.USE_CONCURRENT) {
                    ImplBinaryInnerOps_MT.dilate8(tmp2, tmp1);
                } else {
                    ImplBinaryInnerOps.dilate8(tmp2, tmp1);
                }
                ImplBinaryBorderOps.dilate8(tmp2, tmp1);
                GrayU8 a = tmp1;
                tmp1 = tmp2;
                tmp2 = a;
            }
            if (tmp2 != output) {
                output.setTo(tmp2);
            }
        }
        return output;
    }

    public static GrayU8 edge8(GrayU8 input, GrayU8 output, boolean outsideZero) {
        output = InputSanityCheck.checkDeclare(input, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplBinaryInnerOps_MT.edge8(input, output);
        } else {
            ImplBinaryInnerOps.edge8(input, output);
        }
        ImplBinaryBorderOps.edge8(input, output, outsideZero);
        return output;
    }

    public static GrayU8 removePointNoise(GrayU8 input, GrayU8 output) {
        output = InputSanityCheck.checkDeclare(input, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplBinaryInnerOps_MT.removePointNoise(input, output);
        } else {
            ImplBinaryInnerOps.removePointNoise(input, output);
        }
        ImplBinaryBorderOps.removePointNoise(input, output);
        return output;
    }

    public static GrayU8 thin(GrayU8 input, int maxIterations, GrayU8 output) {
        output = InputSanityCheck.checkDeclare(input, output);
        output.setTo(input);
        BinaryThinning thinning = new BinaryThinning();
        thinning.apply(output, maxIterations);
        return output;
    }

    public static List<Contour> contour(GrayU8 input, ConnectRule rule, GrayS32 output) {
        if (output == null) {
            output = new GrayS32(input.width, input.height);
        } else {
            InputSanityCheck.checkSameShape(input, output);
        }
        BinaryLabelContourFinder alg = FactoryBinaryContourFinder.linearChang2004();
        alg.setConnectRule(rule);
        alg.process(input, output);
        return BinaryImageOps.convertContours(alg);
    }

    public static List<Contour> contourExternal(GrayU8 input, ConnectRule rule) {
        BinaryContourFinderLinearExternal alg = FactoryBinaryContourFinder.linearExternal();
        alg.setConnectRule(rule);
        alg.process(input);
        return BinaryImageOps.convertContours(alg);
    }

    public static List<Contour> convertContours(BinaryContourInterface alg) {
        List<ContourPacked> contours = alg.getContours();
        ArrayList<Contour> ret = new ArrayList<Contour>();
        for (int i = 0; i < contours.size(); ++i) {
            ContourPacked p = contours.get(i);
            Contour c = new Contour();
            c.external = BinaryContourInterface.copyContour(alg, p.externalIndex);
            for (int j = 0; j < p.internalIndexes.size; ++j) {
                c.internal.add(BinaryContourInterface.copyContour(alg, p.internalIndexes.get(j)));
            }
            ret.add(c);
        }
        return ret;
    }

    public static void relabel(GrayS32 input, int[] labels) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplBinaryImageOps_MT.relabel(input, labels);
        } else {
            ImplBinaryImageOps.relabel(input, labels);
        }
    }

    public static GrayU8 labelToBinary(GrayS32 labelImage, GrayU8 binaryImage) {
        binaryImage = InputSanityCheck.checkDeclare(labelImage, binaryImage, GrayU8.class);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplBinaryImageOps_MT.labelToBinary(labelImage, binaryImage);
        } else {
            ImplBinaryImageOps.labelToBinary(labelImage, binaryImage);
        }
        return binaryImage;
    }

    public static GrayU8 labelToBinary(GrayS32 labelImage, GrayU8 binaryImage, boolean[] selectedBlobs) {
        binaryImage = InputSanityCheck.checkDeclare(labelImage, binaryImage, GrayU8.class);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplBinaryImageOps_MT.labelToBinary(labelImage, binaryImage, selectedBlobs);
        } else {
            ImplBinaryImageOps.labelToBinary(labelImage, binaryImage, selectedBlobs);
        }
        return binaryImage;
    }

    public static GrayU8 labelToBinary(GrayS32 labelImage, GrayU8 binaryImage, int numLabels, int ... selected) {
        boolean[] selectedBlobs = new boolean[numLabels];
        for (int i = 0; i < selected.length; ++i) {
            selectedBlobs[selected[i]] = true;
        }
        return BinaryImageOps.labelToBinary(labelImage, binaryImage, selectedBlobs);
    }

    public static List<List<Point2D_I32>> labelToClusters(GrayS32 labelImage, int numLabels, FastQueue<Point2D_I32> queue) {
        ArrayList<List<Point2D_I32>> ret = new ArrayList<List<Point2D_I32>>();
        for (int i = 0; i < numLabels + 1; ++i) {
            ret.add(new ArrayList());
        }
        if (queue == null) {
            queue = new FastQueue<Point2D_I32>(numLabels, Point2D_I32::new);
        } else {
            queue.reset();
        }
        for (int y = 0; y < labelImage.height; ++y) {
            int start = labelImage.startIndex + y * labelImage.stride;
            int end = start + labelImage.width;
            for (int index = start; index < end; ++index) {
                int v = labelImage.data[index];
                if (v <= 0) continue;
                Point2D_I32 p = queue.grow();
                p.set(index - start, y);
                ((List)ret.get(v)).add(p);
            }
        }
        if (((List)ret.get(0)).size() != 0) {
            throw new RuntimeException("BUG!");
        }
        ret.remove(0);
        return ret;
    }

    public static void clusterToBinary(List<List<Point2D_I32>> clusters, GrayU8 binary) {
        ImageMiscOps.fill(binary, 0);
        for (List<Point2D_I32> l : clusters) {
            for (Point2D_I32 p : l) {
                binary.set(p.x, p.y, 1);
            }
        }
    }

    public static int[] selectRandomColors(int numBlobs, Random rand) {
        int[] colors = new int[numBlobs + 1];
        colors[0] = 0;
        int B = 100;
        for (int i = 1; i < colors.length; ++i) {
            int c;
            while (((c = rand.nextInt(0xFFFFFF)) & 0xFF) <= B && (c >> 8 & 0xFF) <= B && (c >> 8 & 0xFF) <= B) {
            }
            colors[i] = c;
        }
        return colors;
    }
}

