/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.circle;

import boofcv.alg.shapes.ellipse.BinaryEllipseDetector;
import georegression.struct.curve.EllipseRotated_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class EllipsesIntoClusters {
    private double maxDistanceToMajorAxisRatio;
    private double sizeSimilarityTolerance;
    private double ratioSimilarityTolerance;
    private double edgeIntensitySimilarityTolerance;
    private int minimumClusterSize = 3;
    private NearestNeighbor<BinaryEllipseDetector.EllipseInfo> nn = FactoryNearestNeighbor.kdtree(new KdTreeEllipseInfo());
    private NearestNeighbor.Search<BinaryEllipseDetector.EllipseInfo> search = this.nn.createSearch();
    private FastQueue<NnData<BinaryEllipseDetector.EllipseInfo>> searchResults = new FastQueue<NnData>(NnData::new);
    FastQueue<Node> nodes = new FastQueue<Node>(Node::new);
    FastQueue<List<Node>> clusters = new FastQueue<List>(ArrayList::new);

    public EllipsesIntoClusters(double maxDistanceToMajorAxisRatio, double sizeSimilarityTolerance, double edgeIntensitySimilarityTolerance) {
        this.maxDistanceToMajorAxisRatio = maxDistanceToMajorAxisRatio;
        this.sizeSimilarityTolerance = sizeSimilarityTolerance;
        this.ratioSimilarityTolerance = sizeSimilarityTolerance;
        this.edgeIntensitySimilarityTolerance = edgeIntensitySimilarityTolerance;
    }

    public void process(List<BinaryEllipseDetector.EllipseInfo> ellipses, List<List<Node>> output) {
        this.init(ellipses);
        this.connect(ellipses);
        output.clear();
        for (int i = 0; i < this.clusters.size(); ++i) {
            List c = (List)this.clusters.get(i);
            EllipsesIntoClusters.removeSingleConnections(c);
            if (c.size() < this.minimumClusterSize) continue;
            output.add(c);
        }
    }

    void connect(List<BinaryEllipseDetector.EllipseInfo> ellipses) {
        for (int i = 0; i < ellipses.size(); ++i) {
            List<Node> cluster1;
            BinaryEllipseDetector.EllipseInfo info1 = ellipses.get(i);
            EllipseRotated_F64 e1 = info1.ellipse;
            Node node1 = (Node)this.nodes.get(i);
            double maxDistance = e1.a * this.maxDistanceToMajorAxisRatio;
            maxDistance *= maxDistance;
            this.searchResults.reset();
            this.search.findNearest(ellipses.get(i), maxDistance, Integer.MAX_VALUE, this.searchResults);
            if (node1.cluster == -1) {
                node1.cluster = this.clusters.size;
                cluster1 = this.clusters.grow();
                cluster1.clear();
                cluster1.add(node1);
            } else {
                cluster1 = (List<Node>)this.clusters.get(node1.cluster);
            }
            double edge1 = info1.averageOutside - info1.averageInside;
            for (int j = 0; j < this.searchResults.size(); ++j) {
                double ratioB;
                double edge2;
                double intensityRatio;
                NnData d = (NnData)this.searchResults.get(j);
                BinaryEllipseDetector.EllipseInfo info2 = ellipses.get(d.index);
                EllipseRotated_F64 e2 = info2.ellipse;
                if (e2 == e1 || node1.connections.indexOf(d.index) != -1 || (intensityRatio = Math.abs(edge1 - (edge2 = info2.averageOutside - info2.averageInside)) / Math.max(edge1, edge2)) > this.edgeIntensitySimilarityTolerance || EllipsesIntoClusters.axisAdjustedDistanceSq(e1, e2) > maxDistance) continue;
                double ratioA = e1.a > e2.a ? e2.a / e1.a : e1.a / e2.a;
                double d2 = ratioB = e1.b > e2.b ? e2.b / e1.b : e1.b / e2.b;
                if (ratioA < this.sizeSimilarityTolerance && ratioB < this.sizeSimilarityTolerance) continue;
                double ratioC = e1.a * e2.b / (e1.b * e2.a);
                if (ratioC > 1.0) {
                    ratioC = 1.0 / ratioC;
                }
                if (ratioC < this.ratioSimilarityTolerance || intensityRatio + (1.0 - ratioC) > this.edgeIntensitySimilarityTolerance / 1.5 + (1.0 - this.ratioSimilarityTolerance)) continue;
                int indexNode2 = d.index;
                Node node2 = (Node)this.nodes.get(indexNode2);
                if (node2.cluster == -1) {
                    node2.cluster = node1.cluster;
                    cluster1.add(node2);
                    node1.connections.add(indexNode2);
                    node2.connections.add(i);
                    continue;
                }
                if (node2.cluster != node1.cluster) {
                    this.joinClusters(node1.cluster, node2.cluster);
                    node1.connections.add(indexNode2);
                    node2.connections.add(i);
                    continue;
                }
                node1.connections.add(indexNode2);
                node2.connections.add(i);
            }
        }
    }

    static void removeSingleConnections(List<Node> cluster) {
        ArrayList<Node> open = new ArrayList<Node>();
        ArrayList<Node> future = new ArrayList<Node>();
        open.addAll(cluster);
        while (!open.isEmpty()) {
            for (int i = open.size() - 1; i >= 0; --i) {
                Node n = (Node)open.get(i);
                if (n.connections.size != 1) continue;
                int index = EllipsesIntoClusters.findNode(n.which, cluster);
                cluster.remove(index);
                int parent = EllipsesIntoClusters.findNode(n.connections.get(0), cluster);
                n.connections.reset();
                if (parent == -1) {
                    throw new RuntimeException("BUG!");
                }
                Node p = cluster.get(parent);
                int edge = p.connections.indexOf(n.which);
                if (edge == -1) {
                    throw new RuntimeException("BUG!");
                }
                p.connections.remove(edge);
                if (p.connections.size != 1) continue;
                future.add(p);
            }
            open.clear();
            ArrayList<Node> tmp = open;
            open = future;
            future = tmp;
        }
    }

    static int findNode(int target, List<Node> cluster) {
        for (int i = 0; i < cluster.size(); ++i) {
            if (cluster.get((int)i).which != target) continue;
            return i;
        }
        return -1;
    }

    static double axisAdjustedDistanceSq(EllipseRotated_F64 a, EllipseRotated_F64 b) {
        double dx = b.center.x - a.center.x;
        double dy = b.center.y - a.center.y;
        double c = Math.cos(a.phi);
        double s = Math.sin(a.phi);
        double x = dx * c + dy * s;
        double y = (-dx * s + dy * c) * a.a / a.b;
        return x * x + y * y;
    }

    void init(List<BinaryEllipseDetector.EllipseInfo> ellipses) {
        this.nodes.resize(ellipses.size());
        this.clusters.reset();
        int i = 0;
        while (i < ellipses.size()) {
            Node n = (Node)this.nodes.get(i);
            n.connections.reset();
            n.which = i++;
            n.cluster = -1;
        }
        this.nn.setPoints(ellipses, true);
    }

    void joinClusters(int mouth, int food) {
        List listMouth = (List)this.clusters.get(mouth);
        List listFood = (List)this.clusters.get(food);
        for (int i = 0; i < listFood.size(); ++i) {
            listMouth.add((Node)listFood.get(i));
            ((Node)listFood.get((int)i)).cluster = mouth;
        }
        listFood.clear();
    }

    public double getMaxDistanceToMajorAxisRatio() {
        return this.maxDistanceToMajorAxisRatio;
    }

    public void setMaxDistanceToMajorAxisRatio(double maxDistanceToMajorAxisRatio) {
        this.maxDistanceToMajorAxisRatio = maxDistanceToMajorAxisRatio;
    }

    public double getSizeSimilarityTolerance() {
        return this.sizeSimilarityTolerance;
    }

    public void setSizeSimilarityTolerance(double sizeSimilarityTolerance) {
        this.sizeSimilarityTolerance = sizeSimilarityTolerance;
    }

    public int getMinimumClusterSize() {
        return this.minimumClusterSize;
    }

    public void setMinimumClusterSize(int minimumClusterSize) {
        this.minimumClusterSize = minimumClusterSize;
    }

    private static class KdTreeEllipseInfo
    implements KdTreeDistance<BinaryEllipseDetector.EllipseInfo> {
        private KdTreeEllipseInfo() {
        }

        @Override
        public double distance(BinaryEllipseDetector.EllipseInfo a, BinaryEllipseDetector.EllipseInfo b) {
            return a.ellipse.center.distance2(b.ellipse.center);
        }

        @Override
        public double valueAt(BinaryEllipseDetector.EllipseInfo point, int index) {
            switch (index) {
                case 0: {
                    return point.ellipse.center.x;
                }
                case 1: {
                    return point.ellipse.center.y;
                }
            }
            throw new IllegalArgumentException("Out of bounds. " + index);
        }

        @Override
        public int length() {
            return 2;
        }
    }

    public static class Node {
        public int which;
        public int cluster;
        public GrowQueue_I32 connections = new GrowQueue_I32();
    }
}

