/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation;

import boofcv.abst.feature.orientation.OrientationGradient;
import boofcv.alg.InputSanityCheck;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ImageRectangle;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.image.ImageGray;

public abstract class OrientationHistogram<D extends ImageGray<D>>
implements OrientationGradient<D> {
    protected double objectToSample;
    protected int radiusScale;
    protected D derivX;
    protected D derivY;
    protected ImageRectangle rect = new ImageRectangle();
    protected int numAngles;
    protected double[] sumDerivX;
    protected double[] sumDerivY;
    protected double angleDiv;
    protected double angleRound;
    protected boolean isWeighted;
    protected Kernel2D_F32 weights;

    public OrientationHistogram(double objectToSample, int numAngles, boolean isWeighted) {
        this.numAngles = numAngles;
        this.objectToSample = objectToSample;
        this.sumDerivX = new double[numAngles];
        this.sumDerivY = new double[numAngles];
        this.angleDiv = Math.PI * 2 / (double)numAngles;
        this.angleRound = Math.PI + this.angleDiv / 2.0;
        this.isWeighted = isWeighted;
    }

    public double getObjectToSample() {
        return this.objectToSample;
    }

    public void setObjectToSample(double objectToSample) {
        this.objectToSample = objectToSample;
        this.setObjectRadius(objectToSample);
    }

    public Kernel2D_F32 getWeights() {
        return this.weights;
    }

    @Override
    public void setObjectRadius(double objectRadius) {
        this.radiusScale = (int)Math.ceil(objectRadius * this.objectToSample);
        if (this.isWeighted) {
            this.weights = (Kernel2D_F32)FactoryKernelGaussian.gaussian(2, true, 32, -1.0, this.radiusScale);
        }
    }

    @Override
    public void setImage(D derivX, D derivY) {
        InputSanityCheck.checkSameShape(derivX, derivY);
        this.derivX = derivX;
        this.derivY = derivY;
    }

    @Override
    public double compute(double X2, double Y2) {
        int c_x = (int)X2;
        int c_y = (int)Y2;
        this.rect.x0 = c_x - this.radiusScale;
        this.rect.y0 = c_y - this.radiusScale;
        this.rect.x1 = c_x + this.radiusScale + 1;
        this.rect.y1 = c_y + this.radiusScale + 1;
        BoofMiscOps.boundRectangleInside(this.derivX, this.rect);
        for (int i = 0; i < this.numAngles; ++i) {
            this.sumDerivX[i] = 0.0;
            this.sumDerivY[i] = 0.0;
        }
        if (this.weights == null) {
            this.computeUnweightedScore();
        } else {
            this.computeWeightedScore(c_x, c_y);
        }
        double bestScore = -1.0;
        int bestIndex = -1;
        double bestX = -1.0;
        double bestY = -1.0;
        for (int i = 0; i < this.numAngles; ++i) {
            double x = this.sumDerivX[i];
            double y = this.sumDerivY[i];
            double score = x * x + y * y;
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestIndex = i;
            bestX = x;
            bestY = y;
        }
        return Math.atan2(bestY, bestX);
    }

    protected abstract void computeUnweightedScore();

    protected abstract void computeWeightedScore(int var1, int var2);
}

